/* --------------------------------------------------------------------------
 *
 * $Workfile: GDialogClientArea.cpp $
 * $Revision: 19 $
 *   $Author: Lel $
 *     $Date: 04.08.14 23:09 $
 *
 *   Created: January 25, 2000.
 *   Project: Larsen Commander.
 * Copyright: Leif Erik Larsen. 2000. Ski, Norway.
 *            This is unpublished property, all rights reserved.
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GDialogClientArea.h"
#include "glib/gui/GGraphics.h"

GDialogClientArea::GDialogClientArea ( GDialogPanel& parent,
                                       const GString& name,
                                       const GString& constraints )
                  :GWindow(name,
                           constraints,
                           &parent,
                           &parent,
                           GWindowClass::GENERIC,
                           GString::Empty,
                           WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN,
                           WS2_OS2Y),
                   ctrlsBag(4),
                   dlgPanel(parent)
{
}

GDialogClientArea::~GDialogClientArea ()
{
}

bool GDialogClientArea::onPaintBackground ( GGraphics& g, const GRectangle& rect )
{
   GColor bck = getBackgroundColor();
   g.setColor(bck);
   g.drawFilledRectangle(rect);

   /* ___?___
   // Do not attempt to paint the wallpaper image before it is 100% loaded.
   if (dlgWallPaper != null && dlgWallPaper.on && wallPaperImage != null)
   {
      Graphics g = (Graphics) msg.getParam1();
      Color bckColor = IStandardRGBColors.RGB_GRAY;
      g.setColor (bckColor);
      Rectangle r = g.getClipBounds();

      int x, y;
      Insets theInsets = getInsets();
      int imWidth = wallPaperImage.getWidth(this);
      int imHeight = wallPaperImage.getHeight(this);

      if (imWidth <= 0 || imHeight <= 0)
      {
         g.fillRect(r.x, r.y, r.width, r.height);
         return true;
      }

      int winWidth = clientArea->getSize().width;
      int winHeight = clientArea->getSize().height;

      // Paint the background wallpaper
      switch (dlgWallPaper.flag)
      {
         case GWallPaperParams::DWP_TILEIMAGE:
              for (x = theInsets.left; x < winWidth; x += imWidth)
                 for (y = theInsets.top; y < winHeight; y += imHeight)
                    g.drawImage(wallPaperImage, x, y, imWidth, imHeight, this);
              break;

         case GWallPaperParams::DWP_STRETCHIMAGE:
              g.drawImage(wallPaperImage, 0, 0, winWidth-1, winHeight-1, 0, 0, imWidth-1, imHeight-1, bckColor, this);
              break;

         case GWallPaperParams::DWP_CENTERIMAGE:
              g.fillRect(r.x, r.y, r.width, r.height);
              g.drawImage(wallPaperImage, winWidth/2 - imWidth/2, winHeight/2 - imHeight/2, imWidth, imHeight, this);
              break;
      }
   }
   */

   return true;
}

