/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_FONTMETRICS
#define __GLIB_FONTMETRICS

#include "glib/primitives/GString.h"

/**
 *
 * @author  Leif Erik Larsen
 * @since   2001.12.03
 */
class GFontMetrics : public GObject
{
   public:

      /** The type/structure that contains the OS specific font metrics data. */
      typedef FONTMETRICS FontData;

   private:

      /** This structure contains the OS specific font metrics data. */
      FontData data;

   public:

      GFontMetrics ();
      GFontMetrics ( const GFontMetrics& fm );
      explicit GFontMetrics ( const class GGraphics& g );
      explicit GFontMetrics ( const class GWindow& win );

   public:

      GFontMetrics& operator= ( const GFontMetrics& fm );

   public:

      /**
       * Get the height of the font, in pixels.
       */
      int getHeight () const;

      /**
       * Get the average character width of the font, in pixels.
       */
      int getAverageWidth () const;
};

#endif

