/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_GROUPBOX
#define __GLIB_GROUPBOX

#include "glib/gui/GWindow.h"

/**
 * This is the low level window class that is used to paint a static
 * group box with or without text in a container window.
 *
 * @author  Leif Erik Larsen
 * @since   2000.04.19
 */
class GGroupBox : public GWindow
{
   private:

      bool useHotKey;
      int hotKeyPos;
      GString text;
      bool noLeft;
      bool noRight;
      bool noTop;
      bool noBottom;

   public:

      GGroupBox ( const GString& name,
                  const GString& constraints,
                  GWindow& parentWin,
                  long winStyle = WS_VISIBLE,
                  long winStyle2 = 0,
                  bool hotKey = true,
                  bool noLeft = false,
                  bool noRight = false,
                  bool noTop = false,
                  bool noBottom = false );

      virtual ~GGroupBox ();

   private:

      /** Disable the copy constructor. */
      GGroupBox ( const GGroupBox& src ) {}

      /** Disable the assignment operator. */
      GGroupBox& operator= ( const GGroupBox& ) { return *this; }

   protected:

      virtual bool onPaint ( GGraphics& g, const GRectangle& rect );

   public:

      virtual void changeValue ( const GString& newValue, bool notify = true );
      virtual bool isEmpty () const;
      virtual GString queryValue () const;

      virtual GString getText () const;
      virtual void setText ( const GString& text );
};

#endif

