/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_LISTBOXITEM
#define __GLIB_LISTBOXITEM

#include "glib/primitives/GString.h"

/**
 * Each item in a {@link GListBox} and {@link GDropList} are represented
 * as an instance of this class.
 *
 * @author  Leif Erik Larsen
 * @since   2000.05.09
 * @see     GListBox
 */
class GListBoxItem : public GObject
{
   private:

      GString text;
      const class GIcon* icon;
      GObject* userData;
      bool autoDeleteUserData;

   public:

      GListBoxItem ();
      GListBoxItem ( const GListBoxItem& src );
      GListBoxItem ( const GString& text );
      GListBoxItem ( const GString& text, const class GIcon* icon );
      GListBoxItem ( const GString& text, GObject* userData, bool autoDeleteUserData );
      GListBoxItem ( const GString& text, const class GIcon* icon, GObject* userData, bool autoDeleteUserData );
      virtual ~GListBoxItem ();

   public:

      GListBoxItem& operator= ( const GListBoxItem& src );
      bool operator== ( const GListBoxItem& src ) const;
      bool operator!= ( const GListBoxItem& src ) const;

   public:

      const GIcon* getIcon () const;
      const GString& getText () const;
      GObject* getUserData () const;
      void setIcon ( const class GIcon* newIcon );
      void setText ( const GString& newText );
      void setUserData ( GObject* ud, bool autoDelete );
      virtual GString toString () const;
};

#endif

