/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GMenu.h"
#include "glib/GProgram.h"

GMenuPopupItem::GMenuPopupItem ( GMenuPopup& ownerMenu,
                                 GMenuItemParams& mi,
                                 int sysID )
               :GAbstractCommand(mi.getIDString()),
                sysID(sysID),
                text(GProgram::LoadText(mi.textID)),
                hint(GProgram::LoadText(mi.hintID, GResourceTable::LT_PREFER_HINT)),
                icon(GIcon::GetIcon(mi.iconID)),
                accelKeyID(mi.accelKeyID),
                mnemonicChar(-1),
                iType(mi.iType),
                ownerMenu(ownerMenu),
                subPopup(null)
{
   setUserData1(mi.getUserData1());
}

int GMenuPopupItem::getSysID () const
{
   return sysID;
}

char GMenuPopupItem::getMnemonicChar () const
{
   if (mnemonicChar < 0 || mnemonicChar >= text.length())
      return '\0';
   else
      return text[mnemonicChar];
}

GString GMenuPopupItem::getSystemText () const
{
   GString ret = text;

   if (!text.contains('\t'))
   {
      // The keyboard code is not already manually defined by the text of
      // the item, so we can safely append the keyboard code
      // automatically (if any).
      GMenu& topMenu = ownerMenu.getTopLevelMenu();
      GWindow& parentWin = topMenu.getParentWindow();
      const GString& id = getIDString();
      GAccelItem* ai = parentWin.getAccelItemByCommandID(id);
      if (ai == null)
         if (accelKeyID != "")
            ai = parentWin.getAccelItemByCommandID(accelKeyID);
      if (ai != null)
      {
         ret += '\t';
         ret += ai->getKeyNameForHumans();
      }
   }

   if (mnemonicChar >= 0 && mnemonicChar < text.length())
      ret.insert('~', mnemonicChar);

   return ret;
}

