/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GToolbar.h"
#include "glib/gui/GGraphics.h"
#include "glib/util/GLog.h"
#include "glib/resource/GResourceTable.h"
#include "glib/exceptions/GIllegalStateException.h"

GToolbar::GToolbar ( const GString& name,
                     const GString& constraints,
                     GWindow& parentWin,
                     const GString& resourceID )
         :GAbstractToolbarWindow(name,
                                 constraints,
                                 parentWin)
{
   // Add all the toolbar buttons and/or separators of the specified
   // toolbar resource to the toolbar window.
   GToolbarResource* tb = getResourceTable().getToolbarResource(resourceID);
   if (tb != null)
   {
      int num = tb->items.getCount();
      for (int i=0; i<num; i++)
      {
         GToolbarButtonParams& tbb = tb->items.get(i);
         switch (tbb.itemType)
         {
            case GToolbarButtonParams::Separator:
               addSeparator();
               break;

            case GToolbarButtonParams::PushButton:
               addButton(tbb.getIDString(), tbb.textID, tbb.iconID, GString::Empty);
               break;

            default:
               gthrow_(GIllegalStateException(GString("Uknown type of toolbar item: %d", GVArgs(tbb.itemType))));
         }
      }
   }
}

GToolbar::~GToolbar ()
{
}

int GToolbar::getPreferredHeight () const
{
   if (!isVisible())
      return 0;

   int ret = 0;
   int num = getElementCount();
   for (int i=0; i<num; i++)
   {
      GToolbarElement& elm = const_cast<GToolbar*>(this)->getElement(i);
      int temp = elm.getPreferredHeight();
      if (temp > ret)
         ret = temp;
   }
   return ret + 2;
}

int GToolbar::getPreferredWidth () const
{
   if (!isVisible())
      return 0;

   int ret = 0;
   int num = getElementCount();
   for (int i=0; i<num; i++)
   {
      GToolbarElement& elm = const_cast<GToolbar*>(this)->getElement(i);
      ret += elm.getPreferredWidth();
   }
   return ret;
}

void GToolbar::layout ()
{
   GRectangle r = getWindowRect();
   const GInsets& ins = getInsets();
   int xpos = ins.left; // 2
   int ypos = ins.bottom; // 3;
   int height = r.height - ins.bottom - ins.top;
   int num = getElementCount();
   for (int i=0; i<num; i++)
   {
      GToolbarElement& butt = getElement(i);
      int width = butt.getPreferredWidth();
      butt.setWindowBounds(xpos, ypos, width, height);
      xpos += width;
   }
}
