/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/border/GBorder.h"
#include "glib/gui/GGraphics.h"
#include "glib/primitives/GInsets.h"

GBorder::GBorder ()
{
}

GBorder::~GBorder ()
{
}

void GBorder::paintBackGround ( class GGraphics& g ) const
{
   g.drawFilledRectangle(topBackgroundArea);
   g.drawFilledRectangle(leftBackgroundArea);
   g.drawFilledRectangle(bottomBackgroundArea);
   g.drawFilledRectangle(rightBackgroundArea);
}

void GBorder::onPaint ( GGraphics& g,
                        const GRectangle& rect, 
                        const GInsets& ins ) const
{
   // Top area of the border.
   if (ins.top <= 0)
   {
      topBackgroundArea.clear();
   }
   else
   {
      topBackgroundArea.x = rect.x;
      topBackgroundArea.width = rect.width - rect.x;
      topBackgroundArea.y = rect.height - ins.top;
      topBackgroundArea.height = ins.top;
   }

   // Bottom area of the border.
   if (ins.bottom <= 0)
   {
      bottomBackgroundArea.clear();
   }
   else
   {
      bottomBackgroundArea.x = rect.x;
      bottomBackgroundArea.width = rect.width - rect.x;
      bottomBackgroundArea.y = rect.y;
      bottomBackgroundArea.height = ins.bottom;
   }

   // Left area of the border.
   if (ins.left <= 0)
   {
      leftBackgroundArea.clear();
   }
   else
   {
      leftBackgroundArea.x = rect.x;
      leftBackgroundArea.width = ins.left;
      leftBackgroundArea.y = rect.y + ins.bottom;
      leftBackgroundArea.height = rect.height - ins.top - ins.bottom;
   }

   // Right area of the border.
   if (ins.left <= 0)
   {
      rightBackgroundArea.clear();
   }
   else
   {
      rightBackgroundArea.x = rect.x + rect.width - ins.right;
      rightBackgroundArea.width = ins.right;
      rightBackgroundArea.y = rect.y + ins.bottom;
      rightBackgroundArea.height = rect.height - ins.top - ins.bottom;
   }

   // Do the subclassed painting.
   paintTheBorder(g, rect, ins);
}
