/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_EMPTYBORDER
#define __GLIB_EMPTYBORDER

#include "glib/gui/border/GBorder.h"

/**
 * A flat border with a thin line with optional color.
 *
 * @author  Leif Erik Larsen
 * @since   2004.09.18
 */
class GEmptyBorder : public GBorder
{
   private:
    
      class GColor* color;

   public:

      /**
       * Create an empty border with the default color.
       * The default color is the color of the graphics object that is
       * given to {@link #paintTheBorder}.
       *
       * @author  Leif Erik Larsen
       * @since   2004.09.18
       */
      GEmptyBorder ();

      /**
       * Create an empty border with the specified color.
       *
       * @author  Leif Erik Larsen
       * @since   2004.09.20
       */
      GEmptyBorder ( const class GColor& color );

      virtual ~GEmptyBorder ();

   protected:

      /**
       * @author  Leif Erik Larsen
       * @since   2004.09.18
       */
      virtual void paintTheBorder ( class GGraphics& g,
                                    const class GRectangle& rect, 
                                    const class GInsets& ins ) const;
};

#endif
