/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/event/GWindowMessage.h"
#include "glib/gui/GWindow.h"
#include "glib/sys/GSystem.h"

GWindowMessage::GWindowMessage ( int id, Param1 mp1, Param2 mp2 )
               :id(id),
                mp1(mp1),
                mp2(mp2),
                answer(0)
{
}

GWindowMessage::GWindowMessage ( const QMSG& msg )
               :id(msg.msg),
                mp1(msg.mp1),
                mp2(msg.mp2),
                answer(0)
{
}

GWindowMessage::~GWindowMessage ()
{
}

GWindowMessage::InputFlags::InputFlags ( int flags ) 
                           :flags(flags) 
{
   mouseButton1Down = GSystem::IsShiftKeyDown(GSystem::SK_MOUSE_BUTTON1);
   mouseButton2Down = GSystem::IsShiftKeyDown(GSystem::SK_MOUSE_BUTTON2);
}

GWindowMessage::InputFlags::~InputFlags ()
{
}

int GWindowMessage::InputFlags::getFlags () const 
{ 
   return flags; 
}

bool GWindowMessage::InputFlags::isAltKeyDown () const
{
   return ((flags & KC_ALT) != 0);
}

bool GWindowMessage::InputFlags::isControlKeyDown () const
{
   return ((flags & KC_CTRL) != 0);
}

bool GWindowMessage::InputFlags::isShiftKeyDown () const
{
   return ((flags & KC_SHIFT) != 0);
}

bool GWindowMessage::InputFlags::isMouseButton1Pressed () const
{
   return mouseButton1Down;
}

bool GWindowMessage::InputFlags::isMouseButton2Pressed () const
{
   return mouseButton2Down;
}

bool GWindowMessage::InputFlags::isAnyMouseButtonPressed () const
{
   if (isMouseButton1Pressed())
      return true;
   if (isMouseButton2Pressed())
      return true;
   return false;
}

GString GWindowMessage::toString () const
{
   GString s;

   switch (id)
   {
      case WM_CREATE: s = "WM_CREATE"; break;
      case WM_DESTROY: s = "WM_DESTROY"; break;
      case WM_ENABLE: s = "WM_ENABLE"; break;
      case WM_SHOW: s = "WM_SHOW"; break;
      case WM_TIMER: s = "WM_TIMER"; break;
      case WM_SIZE: s = "WM_SIZE"; break;
      case WM_ADJUSTWINDOWPOS: s = "WM_ADJUSTWINDOWPOS"; break;
      case WM_WINDOWPOSCHANGED: s = "WM_WINDOWPOSCHANGED"; break;
      case WM_SETWINDOWPARAMS: s = "WM_SETWINDOWPARAMS"; break;
      case WM_COMMAND: s = "WM_COMMAND"; break;
      case WM_TRANSLATEACCEL: s = "WM_TRANSLATEACCEL"; break;
      case WM_PAINT: s = "WM_PAINT"; break;
      case WM_MOUSEMOVE: s = "WM_MOUSEMOVE"; break;
      case WM_BUTTON1UP: s = "WM_BUTTON1UP"; break;
      case WM_BUTTON1DOWN: s = "WM_BUTTON1DOWN"; break;
      case WM_BUTTON1CLICK: s = "WM_BUTTON1CLICK"; break;
      case WM_BUTTON1DBLCLK: s = "WM_BUTTON1DBLCLK"; break;
      case WM_BUTTON2UP: s = "WM_BUTTON2UP"; break;
      case WM_BUTTON2DOWN: s = "WM_BUTTON2DOWN"; break;
      case WM_BUTTON2CLICK: s = "WM_BUTTON2CLICK"; break;
      case WM_BUTTON2DBLCLK: s = "WM_BUTTON2DBLCLK"; break;
      case WM_CONTROL: s = "WM_CONTROL"; break;
      case WM_BEGINDRAG: s = "WM_BEGINDRAG"; break;
      case DM_DRAGOVER: s = "DM_DRAGOVER"; break;
      case DM_DRAGLEAVE: s = "DM_DRAGLEAVE"; break;
      case DM_DROP: s = "DM_DROP"; break;
      case WM_SETFOCUS: s = "WM_SETFOCUS"; break;
      case WM_ACTIVATE: s = "WM_ACTIVATE"; break;
      case WM_FOCUSCHANGE: s = "WM_FOCUSCHANGE"; break;
      case WM_MENUEND: s = "WM_MENUEND"; break;

      case WM_PRESPARAMCHANGED: 
      {
         GString p1;
         switch (getParam1Int())
         {
            case PP_FONTNAMESIZE: p1 = "PP_FONTNAMESIZE"; break;
            case PP_BACKGROUNDCOLOR: p1 = "PP_BACKGROUNDCOLOR"; break;
            case PP_FOREGROUNDCOLOR: p1 = "PP_FOREGROUNDCOLOR"; break;
            default: p1 = GString("<%d>", GVArgs(getParam1Int())); break;
         }
         s += "WM_PRESPARAMCHANGED, param1=";
         s += p1;
         break; 
      }

      case WM_CHAR: s = "WM_CHAR"; break;
      case WM_CLOSE: s = "WM_CLOSE"; break;
      case WM_INITMENU: s = "WM_INITMENU"; break;
      case WM_MENUSELECT: s = "WM_MENUSELECT"; break;
      case WM_DRAWITEM: s = "WM_DRAWITEM"; break;
      case WM_MEASUREITEM: s = "WM_MEASUREITEM"; break;

      case GWindow::GM_ABSTRACTCOMMAND: s = "GWindow::GM_ABSTRACTCOMMAND"; break;
      case GWindow::GM_PRESPARAMCHANGED: s = "GWindow::GM_PRESPARAMCHANGED"; break;
      case GWindow::GM_USERMESSAGE: s = "GWindow::GM_USERMESSAGE"; break;
      case GWindow::GM_USERMESSAGE_FROM_THREAD: s = "GWindow::GM_USERMESSAGE_FROM_THREAD"; break;
      case GWindow::GM_ASYNC_PAINT: s = "GWindow::GM_ASYNC_PAINT"; break;
      case GWindow::GM_CREATE_CARET: s = "GWindow::GM_CREATE_CARET"; break;

      default:
         s = GString("0x%X", GVArgs(id));
         break;
   }

   return s;
}

int GWindowMessage::getID () const 
{ 
   return id; 
}

GWindowMessage::Answer GWindowMessage::getAnswer () const 
{ 
   return answer; 
}

GWindowMessage::Param1 GWindowMessage::getParam1 () const 
{ 
   return mp1; 
}

int GWindowMessage::getParam1Int () const 
{ 
   return int(mp1); 
}

bool GWindowMessage::getParam1Bool () const 
{ 
   return bool(mp1); 
}

int GWindowMessage::getParam1LoShort () const 
{ 
   return SHORT(LOUSHORT(mp1)); 
}

int GWindowMessage::getParam1HiShort () const 
{ 
   return SHORT(HIUSHORT(mp1)); 
}

int GWindowMessage::getParam1LoUShort () const 
{ 
   return LOUSHORT(mp1); 
}

int GWindowMessage::getParam1HiUShort () const 
{ 
   return HIUSHORT(mp1); 
}

GWindowMessage::Param2 GWindowMessage::getParam2 () const 
{ 
   return mp2; 
}

int GWindowMessage::getParam2Int () const 
{ 
   return int(mp2); 
}

bool GWindowMessage::getParam2Bool () const 
{ 
   return bool(mp2); 
}

int GWindowMessage::getParam2LoShort () const 
{ 
   return SHORT(LOUSHORT(mp2)); 
}

int GWindowMessage::getParam2HiShort () const 
{ 
   return SHORT(HIUSHORT(mp2)); 
}

int GWindowMessage::getParam2LoUShort () const 
{ 
   return LOUSHORT(mp2); 
}

int GWindowMessage::getParam2HiUShort () const 
{ 
   return HIUSHORT(mp2); 
}

void GWindowMessage::setID ( int id ) 
{ 
   this->id = id; 
}

void GWindowMessage::setAnswer ( Answer answer ) 
{ 
   this->answer = answer; 
}

void GWindowMessage::setParam1 ( Param1 mp1 ) 
{ 
   this->mp1 = mp1; 
}

void GWindowMessage::setParam2 ( Param2 mp2 ) 
{ 
   this->mp2 = mp2; 
}

