/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <limits.h>
#include "glib/gui/layout/GGridLayout.h"
#include "glib/gui/GWindow.h"

GGridLayout::GGridLayout ( int rows, int cols, int hgap, int vgap )
{
   if (rows == 0 && cols == 0)
      cols = 1;
   this->rows = rows;
   this->cols = cols;
   this->hgap = hgap;
   this->vgap = vgap;
}

GGridLayout::~GGridLayout ()
{
}

GDimension GGridLayout::preferredLayoutSize ( GWindow& parent )
{
   GInsets insets = parent.getInsets();
   int ncomponents = parent.getChildWindowCount();
   int nrows = rows;
   int ncols = cols;

   if (nrows > 0)
      ncols = (ncomponents + nrows - 1) / nrows;
   else
      nrows = (ncomponents + ncols - 1) / ncols;
   int w = 0;
   int h = 0;
   for (int i=0; i<ncomponents; i++)
   {
      const GWindow& comp = parent.getChildWindow(i);
      GDimension d = comp.getPreferredSize();
      if (w < d.width)
         w = d.width;
      if (h < d.height)
         h = d.height;
   }

   return GDimension(insets.left + insets.right + ncols*w + (ncols-1)*hgap,
                     insets.top + insets.bottom + nrows*h + (nrows-1)*vgap);
}

int GGridLayout::preferredLayoutWidth ( GWindow& parent )
{
   return preferredLayoutSize(parent).width;
}

int GGridLayout::preferredLayoutHeight ( GWindow& parent )
{
   return preferredLayoutSize(parent).height;
}

void GGridLayout::layoutWindow ( GWindow& parent )
{
   GInsets insets = parent.getInsets();
   int ncomponents = parent.getChildWindowCount();
   int nrows = rows;
   int ncols = cols;

   if (ncomponents == 0)
      return;

   if (nrows > 0)
      ncols = (ncomponents + nrows - 1) / nrows;
   else
      nrows = (ncomponents + ncols - 1) / ncols;
   GDimension parentSize = parent.getWindowSize();
   int w = parentSize.width - (insets.left + insets.right);
   int h = parentSize.height - (insets.top + insets.bottom);
   w = (w - (ncols - 1) * hgap) / ncols;
   h = (h - (nrows - 1) * vgap) / nrows;

   for (int c=0, x=insets.left; c<ncols; c++, x+=w+hgap)
   {
      for (int r=0, y=insets.top; r<nrows; r++, y+=h+vgap)
      {
         int i = r * ncols + c;
         if (i < ncomponents)
            parent.getChildWindow(i).setWindowBounds(x, y, w, h);
      }
   }
}


