/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/tree/GTreeModelEvent.h"
#include "glib/gui/tree/GTreePath.h"

GTreeModelEvent::GTreeModelEvent ( const GTreePath* path, 
                                   const GVector<int>& childIndexes,  
                                   const GArray<GTreeNode>& children ) 
                :path(null)
{
   if (path != null)
      this->path = new GTreePath(*path);
   for (int i=0, count=childIndexes.getCount(); i<count; i++)
   {
      this->childIndexes.add(childIndexes[i]);
      GTreeNode& child = const_cast<GTreeNode&>(children[i]); // Throw away const.
      this->children.add(&child, false);
   }
}

GTreeModelEvent::~GTreeModelEvent ()
{
   delete path;
}

const GTreePath* GTreeModelEvent::getTreePath () const
{ 
   return path; 
}

const GArray<GTreeNode>& GTreeModelEvent::getChildren () const
{
   return children;
}

const GVector<int>& GTreeModelEvent::getChildIndexes () const 
{
   return childIndexes;
}
