/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/tree/GTreeNode.h"
#include "glib/gui/tree/GTreePath.h"

GTreeNode::GTreeNode ( GObject* userObject, bool autoDeleteUserObject ) 
          :hSysHandle(0),
           userObject(userObject),
           autoDeleteUserObject(autoDeleteUserObject)
{
}

GTreeNode::~GTreeNode () 
{
   if (autoDeleteUserObject)
      delete userObject;
}

GTreeNode::SystemNodeHandle GTreeNode::getSysHandle () const
{
   return hSysHandle;
}

bool GTreeNode::isLeaf () const 
{
	return getChildCount() == 0;
}

bool GTreeNode::isNodeChild ( const GTreeNode& aNode ) const
{
   if (getChildCount() == 0)
      return false;
   return const_cast<GTreeNode&>(aNode).getParent() == this;
}

GTreePath GTreeNode::getPath () const
{
   int depth = 0;
   for (GTreeNode* parent = const_cast<GTreeNode*>(this); parent != null; parent = parent->getParent())
      depth++;
   GArray<GTreeNode> path(depth);
   for (GTreeNode* parent = const_cast<GTreeNode*>(this); parent != null; parent = parent->getParent())
      path.insert(parent, 0, false);
   return GTreePath(path);
}

GObject* GTreeNode::getUserObject () 
{
   return userObject;
}
