/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_STRINGSTREAM
#define __GLIB_STRINGSTREAM

#include "glib/io/GInputStream.h"

/**
 * A character input stream whose source is a string.
 *
 * @author  Leif Erik Larsen
 * @since   2000.07.29
 */
class GStringStream : public GInputStream
{
   private:

      GString src;
      mutable int curPos;

   public:

      explicit GStringStream ( const GString& src );

   public:

      /**
       * Implements {@link GInputStream#readByte}.
       *
       * @author  Leif Erik Larsen
       * @since   2000.07.29
       * @see     GInputStream#readByte
       */
      virtual int readByte () const;
};

#endif

