/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_INSETS
#define __GLIB_INSETS

#include "glib/primitives/GObject.h"

/**
 * Primitive class used to represent a rectangle insets.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.05
 * @see     GWindow#getInsets
 */
class GInsets : public GObject
{
   public:

      int top;
      int left;
      int bottom;
      int right;

   public:

      GInsets ();
      GInsets ( int top, int left, int bottom, int right );
      GInsets ( const GInsets& ins );

      virtual ~GInsets ();

   public:

      GInsets& operator= ( const GInsets& src );
      bool operator== ( const GInsets& src );
      bool operator!= ( const GInsets& src );

   private:

      GInsets& copyFrom ( const GInsets& ins );

   public:

      GInsets& clear ();

      /**
       * Return a string representation of the onsets, for debugging
       * purposes only.
       */
      GString toString () const;
};

#endif

