/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/primitives/GPoint.h"
#include "glib/primitives/GVArgs.h"

GPoint::GPoint ()
       :x(0),
        y(0)
{
}

GPoint::GPoint ( int x, int y )
       :x(x),
        y(y)
{
}

GPoint::GPoint ( const GPoint& pt )
       :x(pt.x),
        y(pt.y)
{
}

GPoint::~GPoint ()
{
}

GPoint& GPoint::operator= ( const GPoint& pt )
{
   if (this == &pt)
      return *this;
   else
      return copyFrom(pt);
}

bool GPoint::operator== ( const GPoint& pt ) const
{
   return pt.x == x && pt.y == y;
}

void GPoint::clear ()
{
   x = 0;
   y = 0;
}

void GPoint::set ( int x, int y )
{
   this->x = x;
   this->y = y;
}

bool GPoint::equals ( const GPoint& pt ) const
{
   return x == pt.x && y == pt.y;
}

bool GPoint::equals ( int x, int y ) const
{
   return this->x == x && this->y == y;
}

GPoint& GPoint::copyFrom ( const GPoint& pt )
{
   this->x = pt.x;
   this->y = pt.y;
   return *this;
}

GString GPoint::toString () const
{
   return GString("[x=%d, y=%d]", GVArgs(x).add(y));
}

