/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/resource/GMenuPopupParams.h"
#include "glib/resource/GMenuSeparatorParams.h"
#include "glib/resource/GRcCompiler.h"
#include "glib/resource/GRcException.h"

GMenuPopupParams::GMenuPopupParams ( const GString& id )
                 :GMenuItemParams(id),
                  items(8)
{
   iType = POPUP;
}

GMenuPopupParams::GMenuPopupParams ()
                 :GMenuItemParams(),
                  items(8)
{
   iType = POPUP;
}

GMenuPopupParams::~GMenuPopupParams ()
{
}

void GMenuPopupParams::loadFromScript ( GRcTokenizer& tokenizer, GResourceTable* table )
{
   GMenuItemParams::loadFromScript(tokenizer, table);

   const GRcToken* token = tokenizer.nextPreCompiledToken(false);
   if (*token != GRcTokenizer::Token_lbracket)
      gthrow_(GRcException(tokenizer, GRcException::ERR_EXPECTED_X_FOUND_Y, GVArgs("{").add(token->getString()))); // Expected '(' but found '%2' in statement!

   for (;;)
   {
      token = tokenizer.nextPreCompiledToken(false);

      if (*token == GRcTokenizer::Token_item)
      {
         aptr<GMenuItemParams> newItem(new GMenuItemParams());
         newItem->loadFromScript(tokenizer, table);
         items.add(newItem.release());
      }
      else
      if (*token == GRcTokenizer::Token_popup)
      {
         aptr<GMenuPopupParams> newPopup(new GMenuPopupParams());
         newPopup->loadFromScript(tokenizer, table);
         items.add(newPopup.release());
      }
      else
      if (*token == GRcTokenizer::Token_separator)
      {
         aptr<GMenuSeparatorParams> newSep(new GMenuSeparatorParams());
         newSep->loadFromScript(tokenizer, table);
         items.add(newSep.release());
      }
      else
      if (*token == GRcTokenizer::Token_rbracket)
      {
         break;
      }
      else
         gthrow_(GRcException(tokenizer, GRcException::ERRWUNKNOWN, GVArgs(token->getString()))); // Unknown token: %s
   }
}
