/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_RCINCLUDEMODULE
#define __GLIB_RCINCLUDEMODULE

#include "glib/io/GInputStream.h"

/**
 * This class is used to represent each <i>#include</i>-modile, as well as
 * the main entry module or stream of a resource script.
 *
 * @author  Leif Erik Larsen
 * @since   1999.03.07
 */
class GRcIncludeModule : public GObject
{
   public:

      /** Current line nr. of each "#include". */
      int lineNr;

      /** Index of current source line character. */
      int srcLinePos;

      /** Stack of nested "#include" streams/files. */
      GInputStream* stream;

      /** Trie if and only if we shall automatically delete the stream upon destruction. */
      bool autoDeleteStream;

      /** Full path of the file opened via "#include". */
      GString path;

      /** Buffer of current source line to parse. */
      GString srcLine;

      /** Level of nested #IF when this module was opened. */
      int startIfLevel;

   public:

      /**
       * @param   stream      The top level input stream.
       * @param   ifLevel     Initial zero-based #if-level. Typically -1.
       * @param   autoDelete  True if we shall automatically delete the
       *                      specified stream upon destruction,
       *                      or else false.
       */
      GRcIncludeModule ( GInputStream* stream, int ifLevel, bool autoDelete );

      /**
       * @throws  GFileNotFoundException if the specified file exists but is a
       *                                 directory rather than a regular
       *                                 file, or if file does not
       *                                 exist at all. <b>Note</b> that
       *                                 this class is a subclass of
       *                                 {@link GOpenFileException}.
       * @throws  GOpenFileException if the specified file is not
       *                             possible to open.
       */
      GRcIncludeModule ( class GVfs& vfs, const GString& fname, int ifLevel );

      /**
       */
      virtual ~GRcIncludeModule ();

   private:

      /**
       * Disable the assignment operator.
       */
      const GRcIncludeModule& operator= ( const GRcIncludeModule& src ) const { return *this; }
};

#endif
