/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/sys/GError.h"
#include "glib/sys/GSystem.h"

const GError GError::Ok(NO_ERROR);

const GError GError::AccessDenied(ERROR_ACCESS_DENIED);
const GError GError::BadCommand(ERROR_BAD_COMMAND);
const GError GError::BrokenPipe(ERROR_BROKEN_PIPE);
const GError GError::CorruptDataFormat(ERROR_BAD_FORMAT);
const GError GError::ExtendedAttributesNotSupported(ERROR_EAS_NOT_SUPPORTED);
const GError GError::FileExists(ERROR_FILE_EXISTS);
const GError GError::FilenameExceedRange(ERROR_FILENAME_EXCED_RANGE);
const GError GError::FileNotFound(ERROR_FILE_NOT_FOUND);
const GError GError::InvalidArgument(ERROR_BAD_ARGUMENTS);
const GError GError::InvalidHandle(ERROR_INVALID_HANDLE);
const GError GError::InvalidName(ERROR_INVALID_NAME);
const GError GError::InvalidParameter(ERROR_INVALID_PARAMETER);
const GError GError::NotSupported(ERROR_NOT_SUPPORTED);
const GError GError::PathNotFound(ERROR_PATH_NOT_FOUND);
const GError GError::CircularityRequested(ERROR_CIRCULARITY_REQUESTED);
const GError GError::OutOfMemory(ERROR_NOT_ENOUGH_MEMORY);
const GError GError::FunctionFailed(ERROR_GEN_FAILURE);

GError::GError () 
       :sysErrorCode(Ok.sysErrorCode) 
{
}

GError::GError ( int sysErrorCode ) 
       :sysErrorCode(sysErrorCode) 
{
}

GError::GError ( const GError& src ) 
       :sysErrorCode(src.sysErrorCode), 
        errorDetails(src.errorDetails) 
{
}

GError::~GError () 
{
}

bool GError::operator== ( const GError& o ) const 
{ 
   return sysErrorCode == o.sysErrorCode; 
}

bool GError::operator!= ( const GError& o ) const 
{ 
   return sysErrorCode != o.sysErrorCode; 
}

void GError::operator= ( int sysErrorCode_ ) 
{ 
   sysErrorCode = sysErrorCode_; 
}

GString GError::getErrorMessage () const
{
   return GSystem::GetApiRetString(sysErrorCode);
}

GString GError::getErrorDetails () const
{
   return errorDetails;
}
