/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_COMPARATOR
#define __GLIB_COMPARATOR

/**
 * This interface declares a comparator method that is needed 
 * for instance by sorting algorithms.
 *
 * One example is {@link GArray#sortItems}.
 *
 * @author  Leif Erik Larsen
 * @since   1999.09.17
 * @see     GArray#sortItems
 */
class GComparator
{
   public:

      /**
       * Compare the two objects.
       *
       * @param  obj1  The first object, to compare with the second.
       * @param  obj2  The second object, to compare with the first.
       * @return < 0 if obj1 is "less" than obj2, > 0 if obj2 is "less"
       *         than obj1, or == 0 is obj1 "equals" obj2.
       */
      virtual int compare2Objects ( const class GObject& obj1, const class GObject& obj2 ) const = 0;
};

#endif
