/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_ENUMERATION
#define __GLIB_ENUMERATION

#include "glib/primitives/GObject.h"

/**
 * An interface class that can be implemented by any subclasses that 
 * needs to support enumeration operations through its contained data set.
 *
 * @author  Leif Erik Larsen
 * @since   2004.07.14
 */
class GEnumeration
{
   public:

      /** Tests if this enumeration contains more elements. */
      virtual bool hasMoreElements () = 0;

      /**
       * Returns the next element of this enumeration if this enumeration
       * object has at least one more element to provide.
       * If the enumeration object has no more elements then a 
       * {@link GNoSuchElementException} might be thrown.
       *
       * @author  Leif Erik Larsen
       * @since   2006.11.14
       */
      virtual GObject* nextElement () = 0;
};

#endif
