/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/util/GSearchPath.h"

GSearchPath::GSearchPath ()
            :dirs(16)
{
}

GSearchPath::GSearchPath ( const GString& searchPath )
            :dirs(16)
{
   addSearchPath(searchPath);
}

GSearchPath::GSearchPath ( const GSearchPath& src )
            :dirs(src.dirs)
{
}

GSearchPath::~GSearchPath ()
{
}

GSearchPath& GSearchPath::operator= ( const GSearchPath& src )
{ 
   dirs = src.dirs;
   return *this; 
}

int GSearchPath::getCount () const 
{ 
   return dirs.getCount(); 
}

const GString& GSearchPath::getIndexedDir ( int index ) const 
{ 
   return dirs.get(index); 
}

void GSearchPath::addSearchPath ( const GString& searchPath )
{
   // Split each directory in the search path into its own element in array.
   GString nextPath(256);
   for (int i=0, len=searchPath.length(); i<len; i++)
   {
      while (i < len && searchPath[i] == ';')
         i++;
      if (i < len)
      {
         nextPath = "";
         while (i < len && searchPath[i] != ';')
            nextPath += searchPath[i++];
         nextPath.trim();
         nextPath.trim(GString::TrimEndsOnly, "\"");
         if (nextPath != "")
         {
            GString* s = new GString(nextPath);
            dirs.add(s);
         }
      }
   }
}
