/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_CMDLINEENTRYCOLOROPTIONS
#define __LCMD_CMDLINEENTRYCOLOROPTIONS

#include "glib/gui/GColor.h"

/**
 * This class contain the user customizable colors of the command
 * line entry window.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.19
 */
class LCmdCmdLineEntryColorOptions : public GObject
{
   public:

      /** Foreground Text Color for the Text Entry Field Area. */
      GColor entryTxt;

      /** Background Color for the Text Entry Field Area. */
      GColor entryBck;

      /** Foreground Color for the Text Entry Field Area when it is disabled. */
      GColor txtDisabled;

      /** Background Color for the Text Entry Field Area when it is disabled. */
      GColor bckDisabled;

      /** Foreground Color for the Text Entry Field Area when a child process is waiting for data on its STDIN. */
      GColor txtWaitForInput;

      /** Background Color for the Text Entry Field Area when a child process is waiting for data on its STDIN. */
      GColor bckWaitForInput;

   public:

      /**
       * Initiate all the options in the new object with their
       * respective default value.
       */
      LCmdCmdLineEntryColorOptions ();
      virtual ~LCmdCmdLineEntryColorOptions ();

   public:

      /**
       * Reset all the options in the object with their
       * respective default value.
       */
      virtual void resetToDefault ();
};

#endif // #ifndef __LCMD_CMDLINEENTRYCOLOROPTIONS
