/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdCmdLinePrompt.h"
#include "lcmd/LCmdFilePanel.h"
#include "lcmd/LCmd.h"

LCmdCmdLinePrompt::LCmdCmdLinePrompt ( LCmdCmdLine& cmdLine, 
                                       const GString& constraints )
                  :LCmdCmdLineButton(cmdLine, 
                                     "Prompt", 
                                     constraints, 
                                     "cmdDirHistory", 
                                     GString::Empty, 
                                     "IDP_TBDIRHIST", 
                                     GString::Empty, 
                                     GToolbarButton::IP_LEFT)
{
   defaultForegroundColor = GColor::DRED;
   setForegroundColor(defaultForegroundColor);
   defaultFontNameSize = lcmd->options.DefaultFontPrompt;
   setFontNameSize(defaultFontNameSize);
}

LCmdCmdLinePrompt::~LCmdCmdLinePrompt ()
{
}

GString LCmdCmdLinePrompt::getTooltipText () const
{
   GString text = "%" + getIDString();
   GString ret = getKeyboardShortcutKeyText();
   ret += GProgram::LoadText(text, GResourceTable::LT_PREFER_TEXT, 0);
   return ret;
}

void LCmdCmdLinePrompt::updatePromptText ()
{
   LCmdFilePanel& curPanel = LCmdFilePanel::GetCurrentPanel();
   GString txt = curPanel.getCurrentSysDirectory(false);
   txt += ">";
   setText(txt);
}

int LCmdCmdLinePrompt::getPreferredWidth () const
{
   LCmdCmdLinePrompt* self = const_cast<LCmdCmdLinePrompt*>(this);
   self->updatePromptText();
   GWindow* parentWin = getParentWindow();
   GRectangle r = parentWin->getWindowRect();
   int w = r.width;
   const GString& txt = getText();
   int ret = getWidthOfString(txt) + 18;
   if (ret > w - (w / 3))
      ret = w - (w / 3);
   const GIcon* icon = getIcon();
   if (icon != null)
      ret += icon->getWidth();
   return ret;
}
