/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgAbout.h"
#include "lcmd/LCmdVersion.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"

LCmdDlgAbout::LCmdDlgAbout ()
{
}

LCmdDlgAbout::~LCmdDlgAbout ()
{
}

void LCmdDlgAbout::execute ( GWindow* parentWin )
{
   GProgram& prg = GProgram::GetProgram();
   prg.executeDialog(parentWin, "DlgAbout", this);
}

GString LCmdDlgAbout::getCopyrightString ()
{
   return "(c) Leif Erik Larsen, 1999-2007.";
}

GString LCmdDlgAbout::getVersionString ()
{
   GString versionWithDate("%s, %s", GVArgs(LCMD_VERSIONSTR).add(__DATE__));
   return GStringl("%Txt_DlgAbout_Version", GVArgs(versionWithDate));
}

bool LCmdDlgAbout::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG:
      {
         GString verStr = getVersionString();
         dlg.setComponentValue("111", verStr);
         dlg.setComponentValue("102", GStringl("%Txt_DlgAbout_BuildInfo", GVArgs(__DATE__).add(__TIME__).add(COMPILER)));
         dlg.setComponentValue("103", getCopyrightString());
         dlg.setComponentValue("104", "leifel@online.no");
         dlg.setComponentValue("105", "http://home.online.no/~leifel/");

         // Make sure to use correct colors on this special dialog.
         GColor bck = dlg.getBackgroundColor();
         dlg.getComponentByID("111").setBackgroundColor(bck);
         dlg.getComponentByID("102").setBackgroundColor(bck);
         dlg.getComponentByID("108").setBackgroundColor(bck);
         dlg.getComponentByID("103").setBackgroundColor(bck);
         dlg.getComponentByID("106").setBackgroundColor(bck);
         dlg.getComponentByID("104").setBackgroundColor(bck);
         dlg.getComponentByID("107").setBackgroundColor(bck);
         dlg.getComponentByID("105").setBackgroundColor(bck);
         dlg.getComponentByID("Acknowledgements").setBackgroundColor(bck);
         dlg.getComponentByID("111").setForegroundColor(GColor::DRED);
         dlg.getComponentByID("102").setForegroundColor(GColor::BLACK);
         dlg.getComponentByID("103").setForegroundColor(GColor::BLACK);
         dlg.getComponentByID("104").setForegroundColor(GColor::BLACK);
         dlg.getComponentByID("105").setForegroundColor(GColor::BLACK);
         dlg.getComponentByID("Acknowledgements").setForegroundColor(GColor::BLACK);

         // Add the Acknowledgements.
         GString acknowledgements =
            "Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.\r\n"
            "\r\n"
            "This is the Open Source Edition of Larsen Commander, as "
            "available from http://home.online.no/~leifel/lcmd/.  This code is free "
            "software; you can redistribute it and/or modify it under the terms of "
            "the GNU General Public License version 3 only, as published by the "
            "Free Software Foundation.\r\n"
            "\r\n"
            "This code is distributed in the hope that it will be useful, but WITHOUT "
            "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or "
            "FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License "
            "version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details "
            "(a copy is included in the LICENSE file that accompanied this code).\r\n"
            "\r\n"
            "ACKNOWLEDGEMENTS\r\n"
            "\r\n"
            "Using \"ZLib\" (Zip Library) for built-in zip-file VFS support.\r\n"
            "Copyright (C) 1995-2004 Jean-loup Gailly and Mark Adler.\r\n"
            "Open source code available at:\r\n"
            "http://www.gzip.org/zlib/\r\n"
            "\r\n"
            "Using a stripped and modified version of \"More for C++\" for an auto-ptr "
            "based garbage collector for C++.\r\n"
            "Copyright (c) 1999-2003 by Thorsten Goertz (thorsten@morefor.org).\r\n"
            "Open source code available at:\r\n"
            "http://www.morefor.org/\r\n"
            "\r\n"
            "Developed using tools and libraries provided by IBM and Microsoft Corporation.\r\n"
            "\r\n"
            "The program author wishes to thank ALL USERS for your ideas, "
            "suggestions, criticism, discussions and bug reports. Thanks!\r\n";
         dlg.setComponentValue("Acknowledgements", acknowledgements);

         GProgram& prg = GProgram::GetProgram();
         GWindow& mwin = prg.getMainWindow();
         if (!mwin.isVisible())
         {
            // This is true if we are called upon execution to remind the
            // current unregistered user to register.
            GSystem::Beep(400, 40);
            dlg.setComponentEnabled("DLG_OK", false);
            dlg.startTimer("EnableOK1", 1000);
         }

         // Make the OK-button initially active
         dlg.setComponentFocus("DLG_OK");
         return true;
      }

      case GM_COMMAND:
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
            dlg.dismiss(cmdID);
         return true;
      }

      case GM_TIMER:
      {
         GString timerID = msg.getParam1String();
         if (timerID == "EnableOK1")
         {
            GSystem::Beep(800, 40);
            dlg.stopTimer("EnableOK1");
            dlg.startTimer("EnableOK2", 1000);
         }
         else
         if (timerID == "EnableOK2")
         {
            GSystem::Beep(1200, 40);
            dlg.stopTimer("EnableOK2");
            dlg.startTimer("EnableOK3", 1000);
         }
         else
         if (timerID == "EnableOK3")
         {
            GSystem::Beep(1600, 40);
            dlg.stopTimer("EnableOK3");
            dlg.startTimer("EnableOK4", 1000);
         }
         else
         if (timerID == "EnableOK4")
         {
            dlg.stopTimer("EnableOK4");
            dlg.setComponentEnabled("DLG_OK", true);
         }
         return true;
      }

      default:
         return false;
   }
}
