/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgCopyFile.h"
#include "lcmd/LCmdFilePanel.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"

LCmdDlgCopyFile::LCmdDlgCopyFile ()
                :dest(null),
                 dlgFrame(null)
{
}

LCmdDlgCopyFile::~LCmdDlgCopyFile ()
{
   delete dlgFrame;
}

void LCmdDlgCopyFile::execute ( GWindow& parentWin, LCmdCopy::SpecifyDestDir& dest )
{
   GProgram& prg = GProgram::GetProgram();
   if (dlgFrame == null)
      dlgFrame = prg.makeDialog("DlgCopyFile", this).release();
   this->dest = &dest;
   dlgFrame->executeModal(&parentWin);
}

bool LCmdDlgCopyFile::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG: 
      {
         // Default is that there is an error. This is in case the user
         // clicks on the window-close button, or select the close-command
         // in the system menu, which should operate as if the cancel-button
         // was selected.
         dest->iError = LCmdCopy::ERR_CANCELED;

         GDialogFrame& frame = dlg.getOwnerFrame();
         if (dest->move)
         {
            frame.setText("%Txt_DlgCopyFile_Title_Move");
            dlg.setComponentValue("101", "%Txt_DlgCopyFile_LeaderMove");
         }
         else
         {
            frame.setText("%Txt_DlgCopyFile_Title");
            dlg.setComponentValue("101", "%Txt_DlgCopyFile_LeaderCopy");
         }

         dlg.getComponentByID("106").setBackgroundColor(dlg.getBackgroundColor());
         dlg.getComponentByID("107").setBackgroundColor(dlg.getBackgroundColor());

         dlg.setComponentValue("102", dest->destPath);
         dlg.setComponentFocus("102");

         int num = dest->items.getCount();
         if (num == 1)
         {
            GString srcPath = dest->items[0].getSourcePath();
            GString text = GFile(srcPath).getFileName();
            dlg.setComponentValue("106", text);
         }
         else
         {
            GString text = GStringl("%Txt_DlgCopyFile_CopyTagged", GVArgs(num));
            dlg.setComponentValue("106", text);
         }

         GString text = dest->sourcePanel.getCurrentVfsDirectory(true);
         dlg.setComponentValue("107", text);
         return true; 
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
         {
            dest->iError = LCmdCopy::ERR_NONE;
            dest->destPath = dlg.getComponentValue("102");
            dlg.dismiss(cmdID);
         }
         else
         if (cmdID == "DLG_CANCEL")
         {
            dest->iError = LCmdCopy::ERR_CANCELED;
            dlg.dismiss(cmdID);
         }
         return true; 
      }

      default:
         return false;
   }
}
