/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgDebugOptions.h"

#include "glib/exceptions/GIllegalStateException.h"
#include "glib/gui/event/GDialogMessage.h"
#include "glib/gui/GDropList.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/GProgram.h"

LCmdDlgDebugOptions::LCmdDlgDebugOptions ()
                    :originalFilterIdx(0)
{
}

LCmdDlgDebugOptions::~LCmdDlgDebugOptions ()
{
}

void LCmdDlgDebugOptions::execute ( class GWindow* ownerWin )
{
   GProgram& prg = GProgram::GetProgram();
   prg.executeDialog(ownerWin, "DlgDebugOptions", this);
}

bool LCmdDlgDebugOptions::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG: 
      {
         GDropList& drop = dynamic_cast<GDropList&>(dlg.getComponentByID("LogLevel"));
         GLog::FilterId filterID = GLog::GetFilterLevel();
         switch (filterID)
         {
            case GLog::PROD: drop.setSelectedIndex(0); break;
            case GLog::TEST: drop.setSelectedIndex(1); break;
            case GLog::DEBUG: drop.setSelectedIndex(2); break;
            case GLog::LOGGING_IS_OFF: drop.setSelectedIndex(3); break;
            default: gthrow_(GIllegalStateException(GString("Unknown log-level: %d", GVArgs(int(filterID)))));
         }
         originalFilterIdx = drop.getSelectedIndex();
         return true; 
      }

      case GM_CTRLCHANGED:
      {
         GString compID = msg.getParam1String();
         if (compID == "LogLevel")
         {
            int selectedIdx = msg.getParam2Int();
            switch (selectedIdx) 
            {
               case 0: GLog::SetFilterLevel(GLog::PROD); break;
               case 1: GLog::SetFilterLevel(GLog::TEST); break;
               case 2: GLog::SetFilterLevel(GLog::DEBUG); break;
               case 3: GLog::SetFilterLevel(GLog::LOGGING_IS_OFF); break;
               default: break; // Will never happen. Just ignore this!
            }
         }
         return true;
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
            dlg.dismiss();
         else
         if (cmdID == "DLG_DEFAULT")
            dlg.setComponentValue("LogLevel", 0);
         else
         if (cmdID == "DLG_UNDO")
            dlg.setComponentValue("LogLevel", originalFilterIdx);
         else
         if (cmdID == "DLG_CANCEL")
         {
            dlg.sendDialogMessage(GM_COMMAND, "DLG_UNDO");
            dlg.dismiss();
         }
         return true; 
      }

      default:
         return false;
   }
}
