/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGEAEDITOR
#define __LCMD_DLGEAEDITOR

#include "glib/gui/event/GDialogMessageHandler.h"
#include "glib/primitives/GString.h"

/**
 * This is the dialog used to edit OS/2 Extended Attributes.
 *
 * @since   2001.03.19
 * @author  Leif Erik Larsen
 */
class LCmdDlgEAEditor : public GDialogMessageHandler
{
   private:

      GString fname;
      class GExtendedAttributes& eas;
      bool readOnly;

   private:

      /**
       * This inner class implements the message handler for the
       * sub-dialog that shows when user has clicked on the Add-button.
       *
       * @author  Leif Erik Larsen
       * @since   2001.03.20
       */
      class DlgAdd : public GDialogMessageHandler
      {
         friend class LCmdDlgEAEditor;
         GString name;
         GString value;
         DlgAdd () {}
         virtual ~DlgAdd () {}
         virtual bool handleDialogMessage ( class GDialogMessage& msg );
         GString execute ( class GWindow* ownerWin );
      };

      /**
       * This inner class implements the message handler for the
       * sub-dialog that shows when user has clicked on the Edit-button.
       *
       * @author  Leif Erik Larsen
       * @since   2001.03.20
       */
      class DlgEdit : public GDialogMessageHandler
      {
         friend class LCmdDlgEAEditor;
         GString name;
         GString value;
         DlgEdit () {}
         virtual ~DlgEdit () {}
         virtual bool handleDialogMessage ( class GDialogMessage& msg );
         GString execute ( class GWindow* ownerWin, 
                           const GString& name, 
                           const GString& value );
      };

   private:

      LCmdDlgEAEditor ( const GString& fname, 
                        class GExtendedAttributes& eas, 
                        bool readOnly );

   public:

      virtual ~LCmdDlgEAEditor () {}

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      virtual bool handleDialogMessage ( class GDialogMessage& msg );

      /**
       * Execute the modal dialog.
       */
      GString execute ( class GWindow* ownerWin );

      static void Doit ( class GWindow* ownerWin, bool readOnly );

   public:

      /**
       * Edit the extended attributes of the current selected filename
       * item of the active file panel.
       */
      static void EditEAs ( class GWindow* ownerWin = null );
      static void ShowEAs ( class GWindow* ownerWin = null );
};

#endif // #ifndef __LCMD_DLGEAEDITOR
