/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGFILEDETAILS
#define __LCMD_DLGFILEDETAILS

#include "glib/gui/event/GDialogMessageHandler.h"

#include "lcmd/LCmdFileItem.h"

/**
 * This class forms the definition of the dialog box used to execute
 * the menu command <i>cmdShowFileInfo</i>.
 *
 * @since   2000.04.27
 * @author  Leif Erik Larsen
 * @see     LCmdMainWindow#cmdShowFileInfo
 */
class LCmdDlgFileDetails : public GDialogMessageHandler
{
   private:

      LCmdFileItem fitem;

   public:

      explicit LCmdDlgFileDetails ( const class LCmdFileItem& fitem );
      virtual ~LCmdDlgFileDetails ();

   public:

      void execute ( class GWindow* ownerWin );

   private:

      bool handleDialogMessage ( class GDialogMessage& msg );
};

#endif // #ifndef __LCMD_DLGFILEDETAILS
