/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELFILTEROPTIONS
#define __LCMD_FILEPANELFILTEROPTIONS

#include "lcmd/LCmdAbstractOptions.h"
#include "glib/primitives/GString.h"

/**
 * This class is used to contain the file filter options
 * of a file panel.
 */
class LCmdFilePanelFilterOptions : public LCmdAbstractOptions
{
   public:

      /** Filenames to include. */
      GString include;

      /** Filenames to exclude. */
      GString exclude;

      /** True if hide files with the archive flag. */
      bool hideArchive;

      /** True if hide hidden files. */
      bool hideHidden;

      /** True if hide system files. */
      bool hideSystem;

      /** True if hide read-only files. */
      bool hideReadOnly;

      /** True if show directories. */
      bool showDirs;

      /** True if show files other than directories. */
      bool showFiles;

   public:

      /**
       * Initiate all the options in the new object with their
       * respective default value.
       */
      LCmdFilePanelFilterOptions ();

   public:

      /**
       * Compare all the variables with the corresponding variables of the
       * specified filter options object and return true if and only if all
       * of them are equal.
       */
      bool equals ( const LCmdFilePanelFilterOptions& filt );

      /**
       * Reset all the options in the object with their
       * respective default value.
       */
      void resetToDefault ();
};

#endif // #ifndef __LCMD_FILEPANELFILTEROPTIONS
