/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELINFOBAR
#define __LCMD_FILEPANELINFOBAR

#include "glib/gui/GStatusbar.h"
#include "glib/gui/GToolbarButton.h"

/**
 * This class is used to represent the statusbar/infobar window below
 * the file panel window.
 *
 * @since  1998.05.26
 * @author Leif Erik Larsen
 */
class LCmdFilePanelInfoBar : public GStatusbar
{
   private:

      /**
       * The class used  to represent buttons in the info bar, and which 
       * command id varies depending on whether the file panel is left 
       * or right.
       *
       * @author  Leif Erik Larsen
       * @since   2005.12.10
       */
      class Button : public GToolbarButton
      {
         public:

            LCmdFilePanelInfoBar& infoBar;
            GString cmdIdCurrent;
            GString cmdIdLeft;
            GString cmdIdRight;

         public:

            Button ( LCmdFilePanelInfoBar& ownerTB, 
                     const GString& cellName,
                     const GString& cmdIdCurrent,
                     const GString& cmdIdLeft,
                     const GString& cmdIdRight );

            virtual ~Button ();

         public:

            virtual GString getTooltipText () const;
            virtual void performAction ();
            virtual void updateIDString ();
            virtual bool onButton1Down ( int xpos, int ypos, const GWindowMessage::InputFlags& flags );
      };

   public:

      /** A reference to parent window. */
      class LCmdFilePanelFrame& panelFrame;

   private:

      void updateAllFileItemInfoCells_NoSelection ();
      void updateAllFileItemInfoCells_SingleItem ( class LCmdFileItem& item );

   public:

      LCmdFilePanelInfoBar ( class LCmdFilePanelFrame& parentWin, 
                             const GString& constraints );

      virtual ~LCmdFilePanelInfoBar ();

      virtual int getPreferredHeight () const;

      /**
       * @since   2004.10.05
       * @author  Leif Erik Larsen
       */
      void updateAllFileItemInfoCells ();
};

#endif // #ifndef __LCMD_FILEPANELINFOBAR
