/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_SELFTEST
#define __LCMD_SELFTEST

#include "glib/vfs/GVfsLocal.h"
#include "glib/gui/GWorkerThreadAdapter.h"

/**
 * This class is used to perform some self-tests on the various 
 * code blocks used by Larsen Commander.
 *
 * @author  Leif Erik Larsen
 * @since   2005.01.14
 */
class LCmdSelfTest : public GWorkerThreadAdapter
{
public:
   enum TestID {
      TID_All,
      TID_LowLevelAPIs,
      TID_GarbageCollector,
      TID_ObjectSynch,
      TID_ContainerClasses,
      TID_TextViewer,
      TID_LowLevelFileIO,
      TID_WorkerThread,
      TID_CopySingleFile,
      TID_MoveSingleFile,
      TID_ChangeFilenameCase,
      TID_ChangeFileAttributes,
      TID_ChangeFileTime
   };
private:
   class GProgram& prg;
   GVfsLocal localVfs;
   GString tempDir;
   GString currentTestDescr;
   TestID tid;
public:
   LCmdSelfTest ( TestID tid );
   virtual ~LCmdSelfTest ();
   void assertTrue ( bool b, const GString& errMsg = GString::Empty );
private:
   void doTestImpl ( class GWorkerThread& worker );
   void setCurrentTestDescr ( class GWorkerThread& worker, const GString& descr );
   void createFile ( const GString& path );
   void verifyFile ( const GString& path );
   void removeFile ( const GString& path );
   void removeDirectory ( const GString& dir );
   void copyOrMoveFile ( const GString& path1, const GString& path2, bool move );
   void copyFile ( const GString& path1, const GString& path2 );
   void moveFile ( const GString& path1, const GString& path2 );
   void compareContentOfFiles ( const GString& path1, const GString& path2 );
   void compareAttributesOfFiles ( const GString& path1, const GString& path2 );
   void addExtendedAttributes ( const GString& path );
   void verifyExtendedAttributes ( const GString& path );
   void testGarbageCollector ( GWorkerThread& worker );
   bool testWorkerThread ( GWorkerThread& worker, const GString& titleText, int stayInvisibleMillis );
   void testContainerClasses ( GWorkerThread& worker );
protected:
   virtual void runTheWorkerThread ( class GWorkerThread& worker );
   virtual void onWorkerThreadUpdateMonitor ( class GWorkerThread& worker, class GDialogPanel& monitor );
   virtual void onWorkerThreadCommand ( class GWorkerThread& worker, class GDialogPanel& monitor, const GString& cmdID );
   virtual void onWorkerThreadUserEvent ( class GWorkerThread& worker, class GDialogPanel& monitor, const GString& msgID, GObject* userParam );
private:
   class AutoFileDeleter : public GObject 
   {
   private:
      LCmdSelfTest& selfTest;
      GString path;
      bool isdir;
   public:
      AutoFileDeleter ( LCmdSelfTest& selfTest, const GString& path, bool isdir );
      virtual ~AutoFileDeleter ();
   };
   friend class AutoFileDeleter;
};

#endif // #ifndef __LCMD_SELFTEST
