{
  Mystic BBS Software
  ===========================================================================
  File    | BBS_RECORDS.PAS
  Desc    | This file holds the data file records for all data files used
            within Mystic BBS software.

  Created | August 22, 2002
  Author  | James Coyle

  Notes   | None
  -------------------------------------------------------------------------
}

// The following consists of constant variables used within Mystic's
// code and record structures.  This includes the version information and
// structure/software limitations.

Const
  mysCopyYear        = '1997-2007';                   // Copyright years
  mysVersionMajor    = 2;                             // Current major version
  mysVersionMinor    = 0;                             // Current minor version
  mysVersionBuild    = 2;                             // Current build version
  mysVersionText     = '2.0 Beta 3 <04/20/07>';
  mysMaxACSSize      = 30;                            // ACS string length
  mysMaxPathSize     = 60;                            // Max path name length
  mysMaxMenuItems    = 100;
  mysMaxMenuCmds     = 20;
  mysMaxMenuStack    = 8;
  mysMaxMenuInput    = 12;
  mysMaxMsgLines     = 800;
  mysMaxCallInfo     = 100;
  mysMaxInputHistory = 4;
  mysPathSep         = {$IFDEF UNIX} '/' {$ELSE} '\' {$ENDIF};
  mysOSID            = {$IFDEF UNIX} 'Linux' {$ELSE} 'Win32' {$ENDIF};
  mysMaxThemeText    = 294;

  // RecConfig is the file format for MYSTIC.DAT which is found in the root
  // Mystic BBS directory.  The file is a single record of the recConfig and
  // stores all of the general configuration items within Mystic BBS.

Type
  SmallWord      = System.Word;
  SmallInt       = System.Integer;
  Integer        = SmallInt;
  Word           = SmallWord;
  RecPrompt      = String[255];
  RecAccessFlags = Set of 1..26;
  RecMessageText = Array[1..mysMaxMsgLines] of String[79];

  RecEchoMailAddr = Packed Record
    Zone,
    Net,
    Node,
    Point : SmallWord;
  End;

  RecUserOptionalField = Packed Record
    Ask    : Boolean;
    Desc   : String[13];
    iType  : Byte;
    iField : Byte;
    iMax   : Byte;
  End;

  RecConfig = Packed Record
    SystemCalls    : LongInt;                     // System caller number
    VersionMajor   : Byte;                        // Major version number
    VersionMinor   : Byte;                        // Minor version number
    VersionBuild   : Byte;                        // Build version number
    MaintUser      : LongInt;                     //
    MaintMessage   : LongInt;                     //
    MaintFile      : LongInt;                     //
    MaintGeneral   : LongInt;                     //
    PathSystem     : String[mysMaxPathSize];      // System path
    PathData       : String[mysMaxPathSize];      // Data file path
    PathLogs       : String[mysMaxPathSize];      // Log file path
    PathMsgs       : String[mysMaxPathSize];      // Default msgs path
    PathAttach     : String[mysMaxPathSize];      // File attach path
    PathOffMail    : String[mysMaxPathSize];      // Local offline mail path
    PathMenu       : String[mysMaxPathSize];
    PathText       : String[mysMaxPathSize];
    PathTemplate   : String[mysMaxPathSize];
    PathScripts    : String[mysMaxPathSize];
    BBSName        : String[30];
    SysopName      : String[30];
    DefStartMenu   : String[20];
    DefThemeName   : String[20];
    DefTermMode    : Byte;            //0=detect, 1=detect/ask 2=ask 3=forceANSI 4=forceASCII
    DefScreenSize  : Byte;
    AcsSysOp       : String[mysMaxAcsSize];
    AcsInvLogin    : String[mysMaxAcsSize];
    AcsSeeInvis    : String[mysMaxAcsSize];
    AcsMultiLogin  : String[mysMaxAcsSize];
    SystemPW       : String[20];
    SysopPW        : String[20];
    Inactivity     : SmallWord;
    TaskBar        : Boolean;
    PWChange       : SmallWord;
    LoginAttempts  : Byte;
    PWAttempts     : Byte;
    LoginTime      : Byte;
    PWInquiry      : Boolean;
    UseMatrix      : Boolean;
    MatrixMenu     : String[20];
    MatrixAccess   : String[mysMaxAcsSize];
 // NEW USER SETTINGS
    AllowNewUsers  : Boolean;
    NewUserPW      : String[20];
    NewUserSec     : Byte;
    NewDateFormat  : Byte; //0=ask, 1=mm/dd/yy, 2=dd/mm/yy 3=yy/mm/dd
    UsaPhones      : Boolean;
    FirstMsgGroup  : SmallWord;
    FirstFileGroup : SmallWord;
    MsgReaderType  : Byte; //0=ask 1=standard 2=full
    MsgAtIndex     : Byte; //0=no 1=yes 2=ask
    EmailAtIndex   : Byte; //0=no 1=yes 2=ask
    QuoteWindow    : Byte;
    FileListType   : Byte;
    HotKeys        : Byte;
    ChatType       : Byte;
    FSEditor       : Byte;
    AskAlias       : Boolean;
    AskRealName    : Boolean;
    AskStreet      : Boolean;
    AskCityState   : Boolean;
    AskZipCode     : Boolean;
    AskHomePhone   : Boolean;
    AskDataPhone   : Boolean;
    AskBirthdate   : Boolean;
    AskGender      : Boolean;
    AskEmail       : Boolean;
    AskUserInfo    : Boolean;
    AskScreenSize  : Boolean;
    AskTheme       : Boolean;
    AskChatHandle  : Boolean;
    OptionalField  : Array[1..10] of RecUserOptionalField;
 // MESSAGE BASE SETTINGS
    MCompress      : Boolean;
    MGroups        : Boolean;
    MColumns       : Byte;
    DispMsgHdr     : Boolean;
    MaxAutoSig     : Byte;
    AcsCrossPost   : String[mysMaxAcsSize];
    AcsFileAttach  : String[mysMaxAcsSize];
    AcsNodeLookup  : String[mysMaxAcsSize];
    nmCrash        : Boolean;
    nmHold         : Boolean;
    nmKill         : Boolean;
    UseFSEditor    : Boolean;
    FSCommand      : String[60];
    OriginLine     : String[50];
    ColorQuote     : Byte;
    ColorText      : Byte;
    ColorTear      : Byte;
    ColorOrigin    : Byte;
    ColorKludge    : Byte;
    MailPacket     : String[8];
    DefArchive     : String[4];
    MailMaxBase    : SmallWord;
    MailMaxPacket  : SmallWord;
    NetAddress     : Array[1..20] of RecEchoMailAddr;
    NetDesc        : Array[1..20] of String[20];
 // INTERNET SERVER SETTINGS
    InetDomain     : String[30];                  // BBS/Internet domain name
    InetTNUse      : Boolean;
    InetTNPort     : SmallWord;
    InetTNMax      : Byte;
    InetTNIPs      : Byte;
    InetFTPUse     : Boolean;
    InetFTPPort    : SmallWord;
    InetFTPMax     : Byte;
    InetFTPIPs     : Byte;
    InetSMTPUse    : Boolean;
    InetSMTPPort   : SmallWord;
    InetSMTPMax    : Byte;
    InetSMTPIPs    : Byte;
    InetPOP3Use    : Boolean;
    InetPOP3Port   : SmallWord;
    InetPOP3Max    : Byte;
    InetPOP3IPs    : Byte;
    InetNNTPUse    : Boolean;
    InetNNTPPort   : SmallWord;
    InetNNTPMax    : Byte;
    InetNNTPIPs    : Byte;
    UserChatType   : Byte;     // not implemented
    MinUploadKB    : LongInt;  // not implemented
    MaxBatchQueue  : Word;     // not implemented
    FCompress      : Boolean;  // not implemented
    FGroups        : Boolean;  // not implemented
    FColumns       : Byte;     // not implemented
    FReDisplay     : Boolean;  // not implemented
    FDefUpload     : Word;     // not implemented
    FDupeScan      : Byte;
    FMinCDCopy     : LongInt;
    FImportDIZ     : Boolean;
    FMaxDescSize   : Byte;
    AcsAutoValid   : String[mysMaxAcsSize];
    AcsSeeUnvalid  : String[mysMaxAcsSize];
    AcsDLUnvalid   : String[mysMaxAcsSize];
    AcsSeeFailed   : String[mysMaxAcsSize];
    AcsDLFailed    : String[mysMaxAcsSize];
    FULScanner     : Byte;  //0/none 1/internal 2/external
    FULCmdLine     : String[80];
    FULPassed      : Byte;
    Reserved       : Array[1..228] of Byte;
  End;

  // RecUser is the file format for USERS.DAT which is found in the data
  // directory.  This file contains a series of recUser records, one for
  // each user.

Const
  UserDeleted    = $00000001;
  UserLockedOut  = $00000002;
  UserNoDelete   = $00000004;
  UserNoPWChange = $00000008;
  UserNoLastCall = $00000010;
  UserNoInactive = $00000020;

Type
  RecUser = Packed Record
 // USER INFORMATION
    UserID       : LongInt;
    RealName     : String[30];
    Handle       : String[30];
    Password     : String[20];
    Street       : String[30];
    CityState    : String[25];
    ZipCode      : String[10];
    HomePhone    : String[15];
    DataPhone    : String[15];
    Gender       : Char;
    Birthdate    : LongInt;     // Julian date
    Email        : String[40];
    UserInfo     : String[40];
    Security     : Byte;
    StartMenu    : String[20];
    Expires      : String[8];
    ExpiresTo    : Byte;
    AF1          : recAccessFlags;
    AF2          : recAccessFlags;
 // PREFERENCES
    DateType     : Byte; //1=mm/dd/yy 2=dd/mm/yy 3=yy/mm/dd
    ScreenSize   : Byte;
    HotKeys      : Boolean;
    FSEditor     : Boolean;
    QuoteWindow  : Boolean;
    FSFileList   : Boolean;
    FSMsgReader  : Boolean;
    FSMsgIndex   : Boolean;
    FSMsgEIndex  : Boolean;
    FSNodeChat   : Boolean;
    AutoSig      : Boolean;
    AutoSigPtr   : LongInt;
    AutoSigSize  : Byte;
    Archive      : String[4];
    Theme        : String[20];
    ChatName     : String[30];
    Invisible    : Boolean;
    Available    : Boolean;
 // STATISTICS
    PeerIP       : String[20];
    PeerName     : String[50];
    TimeLeft     : SmallInt;
    LastMGroup   : SmallWord;
    LastFGroup   : SmallWord;
    LastFBase    : SmallWord;
    LastMBase    : SmallWord;
    Calls        : LongInt;
    CallsToday   : SmallWord;
    Downloads    : LongInt;
    DLsToday     : SmallWord;
    DownloadKB   : LongInt;
    DLkbToday    : LongInt;
    FirstCall    : LongInt;
    LastCall     : LongInt;
    MsgPosts     : LongInt;
    Emails       : SmallWord;
    Uploads      : LongInt;
    UploadKB     : LongInt;
    TimeBank     : SmallWord;
    LastPWChange : String[8];
    YesVotes     : Byte;
    NoVotes      : Byte;
    AbsVotes     : Byte;
    DoorsRan     : LongInt;
 // OPTIONAL FIELDS
    Optional     : Array[1..10] of String[60];
 // FLAGS
    Flags        : LongInt;
 // UNSORTED AND RESERVED
    Reserved     : Array[1..391] of Byte;
  End;

  RecSecurity = Packed Record
    Desc      : String[30];
    Time      : SmallWord;
    MaxCalls  : SmallWord;
    MaxDLs    : SmallWord;
    MaxDLk    : LongInt;
    MaxTB     : SmallWord;
    DLRatio   : Byte;
    DLKRatio  : SmallWord;
    AF1       : RecAccessFlags;
    AF2       : RecAccessFlags;
    Hard      : Boolean;
    StartMenu : String[20];
    PCRatio   : SmallWord;
    Expires   : SmallWord;
    ExpiresTo : Byte;
    Posts     : Word;
    PostsTo   : Byte;
    Reserved  : Array[1..12] of Byte;
  End;

  RecGroup = Packed Record
    Desc   : String[40];
    Access : String[mysMaxAcsSize];
    Hidden : Boolean;
  End;

  RecPercentBar = Packed Record
    BarType : Byte;
    BarLen  : Byte;
    LoAttr  : Byte;
    HiAttr  : Byte;
    LoChar  : Char;
    HiChar  : Char;
    LastPos : Integer;
  End;

  RecTheme = Packed Record
    FileName     : String[20];
    Description  : String[40];
    PathText     : String[mysMaxPathSize];
    PathMenu     : String[mysMaxPathSize];
    PathTemplate : String[mysMaxPathSize];
    PathScripts  : String[mysMaxPathSize];
    PathFallback : Boolean;
    AllowAnsi    : Boolean;
    AllowAscii   : Boolean;
    LightBarYN   : Boolean;
    UserInputFmt : Byte;      //0=typed 1=upcase 2=lowcase 3=proper 4=elite
    PasswordEcho : Char;
    InputChar    : Char;
    InputField1  : Byte;
    InputField2  : Byte;
    Colors       : Array[0..9] of Byte;
    BarAnsiView  : RecPercentBar;
    BarMsgReader : RecPercentBar;
    BarVote      : RecPercentBar;
    BarFileList  : RecPercentBar;
    LineChat1    : Byte;
    LineChat2    : Byte;
    Reserved     : Array[1..165] of Byte;
  End;

  PtrMenuCmd = ^RecMenuCmd;
  RecMenuCmd = Packed Record
    MenuCmd : String[2];
    Access  : String[mysMaxAcsSize];
    Data    : String[80];
    JumpID  : Byte;
  End;

  PtrMenuItem = ^RecMenuItem;
  RecMenuItem = Packed Record
    Text       : String[80];
    TextLo     : String[80];
    TextHi     : String[80];
    HotKey     : String[12];
    Access     : String[mysMaxAcsSize];
    ShowType   : Byte;
    Redraw     : Boolean;
    JumpUp     : Byte;
    JumpDown   : Byte;
    JumpLeft   : Byte;
    JumpRight  : Byte;
    JumpEscape : Byte;
    JumpTab    : Byte;
    JumpPgUp   : Byte;
    JumpPgDn   : Byte;
    CmdData    : Array[1..mysMaxMenuCmds] of PtrMenuCmd;
    Commands   : Byte;
    X          : Byte;
    Y          : Byte;
  End;

  RecMenuInfo = Packed Record
    Description : String[30];
    Access      : String[mysMaxAcsSize];
    DispFile    : String[20];
    NodeStatus  : String[30];
    Header      : String[70];
    Footer      : String[70];
    MenuType    : Byte;
    InputType   : Byte;
    CharType    : Byte;
    Global      : Boolean;
    DoneX       : Byte;
    DoneY       : Byte;
    DispCols    : Byte;
    CmdTimer    : Byte;
  End;

Const
  RecMessageRealName = $00000001;
  RecMessageForced   = $00000002;
  RecMessageAutoSig  = $00000004;
  RecMessageFAttach  = $00000008;
  RecMessageKFilter  = $00000010;

Type
  RecMessageBase = Packed Record
    Idx         : LongInt;                         // Msg base permanent index
    FileName    : String[60];                      // Msgbase data filename
    Path        : String[mysMaxPathSize];          // Msgbase storage path
    Name        : String[40];                      // Msgbase name
    NewsName    : String[80];                      // Newsgroup name
    BaseType    : Byte;                            // Base type. 0=JAM 1=Squish
    NetType     : Byte;                            // Network type. 0=Local, 1=EchoMail, 2=NetMail, 3=UseNet
    PostType    : Byte;                            // Posting type. 0=Public, 1=Private
    ListACS     : String[mysMaxAcsSize];           // See/List ACS requirements
    PostACS     : String[mysMaxAcsSize];           // Post ACS requirements
    ReadACS     : String[mysMaxAcsSize];           // Read ACS requirements
    SysopACS    : String[mysMaxAcsSize];           // SysOp ACS requirements
    Sponsor     : String[30];                      // Sponsor's User name
    NewScan     : Boolean;                         // User's new scan default.
    MaxMsgs     : SmallWord;                       // Max # of messages to keep in base
    MaxAge      : SmallWord;                       // Max # of days to keep messages
    Header      : String[20];                      // Msg header display file
    Template    : String[20];                      // Msg reader template
    NetAddr     : Byte;                            // Echomail network address
    Origin      : String[50];                      // Echomail origin line
    ColorQuote  : Byte;                            // Quote text color
    ColorText   : Byte;                            // Normal Text color
    ColorTear   : Byte;                            // Tear line text color
    ColorOrigin : Byte;                            // Origin line text color
    ColorKludge : Byte;
    Flags       : LongInt;                         // Message base flags
    Reserved    : Array[1..127] of Byte;
  End;

  RecMessageScan = Packed Record
    NewScan : Byte;                             // In newscan? 0=Off, 1=On
  End;

Const
  RecDoorStats    = $00000001;
  RecDoorDropPath = $00000002;
  RecDoorRealName = $00000004;
  RecDoorLoading  = $00000008;
  RecDoorAction   = $00000010;

Type
  RecDoors = Packed Record
    Name      : String[30];
    DoorID    : String[12];
    StartPath : String[60];
    Command   : String[160];
    Flags     : LongInt;
    LastRan   : LongInt;
    RanToday  : LongInt;
    RanTotal  : LongInt;
    Res       : Array[1..128] of Byte;
  End;

  RecSauceInfo = Packed Record
    ID       : String[4];
    Version  : String[1];
    Title    : String[34];
    Author   : String[19];
    Group    : String[19];
    Date     : String[7];
    FileSize : LongInt;
    DataType : Byte;
    FileType : Byte;
    TInfo1   : Word;
    TInfo2   : Word;
    TInfo3   : Word;
    TInfo4   : Word;
    Comments : Byte;
    Flags    : Byte;
    Filler   : Array[1..22] of Char;
  End;

  RecCallInfo = Packed Record
    NewUser  : Boolean;
    Name     : String[30];
    City     : String[25];
    Node     : Byte;
    Caller   : LongInt;
    DateTime : LongInt;
    Email    : String[40];
    UserInfo : String[40];
    Gender   : Char;
    Optional : Array[1..10] of String[60];
    Res      : Array[1..12] of Byte;
  End;

Const
  nodeBroadcast   = 0;
  nodeMessage     = 1;
  nodeSystemMsg   = 2;
  nodeChatRequest = 3;
  nodeChatOkay    = 4;
  nodeChatDecline = 5;
  nodeTelePublic  = 6;
  nodeTeleStatus  = 7;
  nodeTeleAll     = 8;

Type
  PtrNodeMsg = ^RecNodeMsg;
  RecNodeMsg = Packed Record
    MsgOrigin : Byte;
    MsgType   : Byte;
    MsgData   : String[255];
    MsgRoom   : Byte;
  End;

  RecChatRoom = Packed Record
    Topic   : String[40];
    JoinACS : String[mysMaxAcsSize];
    OpACS   : String[mysMaxAcsSize];
    // moderator
    Res     : Array[1..128] of Byte;
  End;

Const
  RecFileBaseFree     = $00000001;
  RecFileBaseNoFTP    = $00000002;
  RecFileBaseAnon     = $00000004;

Type
  RecFileBasePath = Packed Record
    Path  : String[mysMaxPathSize];
    CdRom : Boolean;
  End;

  PtrFileBase = ^RecFileBase;
  RecFileBase = Packed Record
    FileName    : String[60];
    Path        : Array[1..5] of RecFileBasePath;
    Name        : String[40];
    ListACS     : String[mysMaxAcsSize];
    UploadACS   : String[mysMaxAcsSize];
    DownloadACS : String[mysMaxAcsSize];
    SysopACS    : String[mysMaxAcsSize];
    DispFile    : String[20];
    NewScan     : Boolean;
    Flags       : LongInt;
    Res         : Array[1..512] of Byte;
  End;

  RecArchive = Packed Record
    OSType : Byte;
    Desc   : String[20];
    Ext    : String[4];
    Pack   : String[80];
    Unpack : String[80];
    View   : String[80];
    Res    : Array[1..256] of Byte;
  End;

  RecProtocol = Packed Record
    OSID     : Byte;
    Active   : Boolean;
    Batch    : Boolean;
    Key      : Char;
    Desc     : String[40];
    SendCmd  : String[60];
    RecvCmd  : String[60];
    Reserved : String[255];
  End;

