{$I M_OPS.PAS}

// MAKE SEPARATE PROCESSBUF PROCEDURES DEPENDING ON TELNETCLIENT AND
// TELNETSERVER VARIABLES SO ITS NOT SO DAMN CONFUSING

Unit m_Socket_Class;

Interface

Uses
  {$IFDEF FPC}
    Math,
  {$ENDIF}
  {$IFDEF VPC}
    VPUtils,   // for MIN function.  make own in common.pas
  {$ENDIF}
  m_Socket_Types,
  m_Socket,
  m_DateTime,
  Classes,
  m_Strings,
  SysUtils;   // For StrPas function only

Const
  TSocketBufferSize = 8 * 1024 - 1;

Type
  TSocketBuffer = Array[0..TSocketBufferSize] of Char;

  TSocketClass = Class
    SocketStatus   : TStringList;
    StatusUpdated  : Boolean;
    FSocketHandle  : LongInt;
    FPort          : LongInt;
    FPeerName      : String;
    FPeerIP        : String;
    FInBuf         : TSocketBuffer;
    FInBufPos      : LongInt;
    FInBufEnd      : LongInt;
    FOutBuf        : TSocketBuffer;
    FOutBufPos     : LongInt;
    FTelnetState   : Byte;
    FTelnetReply   : Array[1..14] of Char;
    FTelnetCmd     : Char;
    FTelnetSubCmd  : Char;
    FTelnetLen     : Byte;
    FTelnetEcho    : Boolean;
    FTelnetSubData : String;
    FTelnetClient  : Boolean;
    FTelnetServer  : Boolean;

    Constructor Create;
    Destructor  Destroy; Override;
    Function    ResolvePort (Port: String) : LongInt;
    Procedure   Disconnect;
    Function    WaitForData (TimeOut: LongInt) : LongInt;
    Function    DataWaiting : Boolean;
    Function    ReadBuf (Var Buf; Len: LongInt) : LongInt;
    Function    ReadLine (Var Str: String) : LongInt;
    Function    WriteBuf (Var Buf; Len: LongInt) : LongInt;
    Function    WriteLine (Str: String) : LongInt;
    Function    WriteStr (Str: String) : LongInt;
    Function    WriteFile (Str: String) : Boolean;
    Procedure   BufWriteChar (Ch: Char);
    Procedure   BufWriteStr (Str: String);
    Procedure   BufFlush;
    Function    Connect (Address, Port: String) : Boolean;
    Procedure   WaitInit (Port: String);
    Function    WaitConnection : TSocketClass;
    Procedure   ProcessBuf (Var Buf: TSocketBuffer; Var Len: LongInt);
    Procedure   Status (Str: String);

    Property SocketHandle : LongInt READ FSocketHandle WRITE FSocketHandle;
    Property PeerPort     : LongInt READ FPort         WRITE FPort;
    Property PeerName     : String  READ FPeerName     WRITE FPeerName;
    Property PeerIP       : String  READ FPeerIP       WRITE FPeerIP;
  End;

Implementation

{ TELNET NEGOTIATION CONSTANTS }

Const
  Telnet_IAC    = #255;
  Telnet_DONT   = #254;
  Telnet_DO     = #253;
  Telnet_WONT   = #252;
  Telnet_WILL   = #251;
  Telnet_SB     = #250;
  Telnet_BINARY = #000;
  Telnet_ECHO   = #001;
  Telnet_SE     = #240;
  Telnet_TERM   = #24;
  Telnet_SGA    = #003;

Constructor TSocketClass.Create;
Begin
  Inherited Create;

  FSocketHandle := -1;
  FPort         := 0;
  FPeerName     := 'Unknown';
  FPeerIP       := FPeerName;
  FInBufPos     := 0;
  FInBufEnd     := 0;
  FOutBufPos    := 0;
  FTelnetState  := 0;
  FTelnetEcho   := False;
  FTelnetClient := False;
  FTelnetServer := False;
  StatusUpdated := False;

  SocketStatus := TStringList.Create;
End;

Destructor TSocketClass.Destroy;
Begin
  Disconnect;

  SocketStatus.Destroy;

  Inherited Destroy;
End;

Function TSocketClass.ResolvePort (Port: String) : LongInt;
Var
  PSE : PServEnt;
Begin
  PSE := SockGetServByName(Port, 'tcp');

  If Not Assigned(PSE) Then Begin
    Result := Swap(Word(strS2I(Port)));
    FPort  := strS2I(Port);
  End Else Begin
    Result := PSE^.S_Port;
    FPort  := Swap(PSE^.S_Port);
  End;
End;

Procedure TSocketClass.Disconnect;
Begin
  If FSocketHandle <> -1 Then Begin
    SockShutdown(FSocketHandle, 2);
    SockClose(FSocketHandle);

    FSocketHandle := -1;
  End;
End;

Function TSocketClass.DataWaiting : Boolean;
Begin
  Result := FInBufPos < FInBufEnd;
End;

Function TSocketClass.WaitForData (TimeOut: LongInt) : LongInt;
Begin
  Result := SockSelect(FSocketHandle, 1, 0, 0, TimeOut);
End;

Procedure TSocketClass.ProcessBuf (Var Buf: TSocketBuffer; Var Len: LongInt);

  Procedure SendCommand (YesNo, CmdType: Char);
  Var
    Reply : String[3];
  Begin
    Reply[1] := Telnet_IAC;
    Reply[2] := Char(YesNo); {DO/DONT, WILL/WONT}
    Reply[3] := CmdType;

    SockSend (FSocketHandle, Reply[1], 3, 0);
  End;

  Procedure SendData (CmdType: Char; Data: String);
  Var
    Reply   : String;
    DataLen : Byte;
  Begin
    DataLen  := Length(Data);
    Reply[1] := Telnet_IAC;
    Reply[2] := Telnet_SB;
    Reply[3] := CmdType;
    Reply[4] := #0;

    Move (Data[1], Reply[5], DataLen);

    Reply[5 + DataLen] := #0;
    Reply[6 + DataLen] := Telnet_IAC;
    Reply[7 + DataLen] := Telnet_SE;

    SockSend (FSocketHandle, Reply[1], 7 + DataLen, 0);
  End;

Var
  Count     : LongInt;
  TempPos   : LongInt;
  Temp      : TSocketBuffer;
  ReplyGood : Char;
  ReplyBad  : Char;
Begin
  TempPos := 0;

  For Count := 0 to Len - 1 Do Begin
    Case FTelnetState of
      1 : If Buf[Count] = Telnet_IAC Then Begin
            FTelnetState := 0;
            Temp[TempPos] := Telnet_IAC;
            Inc (TempPos);
          End Else Begin
            Inc (FTelnetState);
            FTelnetCmd := Buf[Count];
          End;
      2 : Begin
            FTelnetState := 0;

            Case FTelnetCmd of
              Telnet_WONT : Begin
//                              FTelnetSubCmd := Telnet_DONT;
//                              SockSend(FSocketHandle, FTelnetSubCmd, 1, 0);
                            End;
              Telnet_DONT : Begin
//                              FTelnetSubCmd := Telnet_WONT;
//                              SockSend(FSocketHandle, FTelnetSubCmd, 1, 0);
                            End;
              Telnet_SB   : Begin
                              FTelnetState  := 3;
                              FTelnetSubCmd := Buf[Count];
                            End;
              Telnet_WILL,
              Telnet_DO   : Begin
                              If FTelnetCmd = Telnet_DO Then Begin
                                ReplyGood := Telnet_WILL;
                                ReplyBad  := Telnet_WONT;
                              End Else Begin
                                ReplyGood := Telnet_DO;
                                ReplyBad  := Telnet_DONT;
                              End;

                              If FTelnetClient Then Begin
                                Case Buf[Count] of
                                  Telnet_BINARY,
                                  Telnet_ECHO,
                                  Telnet_SGA,
                                  Telnet_TERM : SendCommand(ReplyGood, Buf[Count])
                                Else
                                  SendCommand(ReplyBad, Buf[Count]);
                                End;

                                If Buf[Count] = Telnet_Echo Then
                                  FTelnetEcho := (FTelnetCmd = Telnet_DO);
                              End Else Begin
                                Case Buf[Count] of
                                  Telnet_ECHO : FTelnetEcho := True;
                                  Telnet_SGA  : ;
                                Else
                                  SendCommand(ReplyBad, Buf[Count]);
                                End;
                              End;
                            End;
            End;
          End;
      3 : If Buf[Count] = Telnet_SE Then Begin
            If FTelnetClient Then
              Case FTelnetSubCmd of
                Telnet_TERM : SendData(Telnet_TERM, 'vt100');
              End;

            FTelnetState   := 0;
            FTelnetSubData := '';
          End Else
            FTelnetSubData := FTelnetSubData + Buf[Count];
    Else
      If Buf[Count] = Telnet_IAC Then Begin
        Inc (FTelnetState);
      End Else Begin
        Temp[TempPos] := Buf[Count];
        Inc (TempPos);
      End;
    End;
  End;

  Buf := Temp;
  Len := TempPos;
End;

Function TSocketClass.ReadBuf (Var Buf; Len: LongInt) : LongInt;
Begin
  If FInBufPos = FInBufEnd Then Begin
    FInBufEnd := SockRecv(FSocketHandle, FInBuf, TSocketBufferSize, 0);
    FInBufPos := 0;
    If FInBufEnd <= 0 Then Begin
      FInBufEnd := 0;
      Result    := -1;
      Exit;
    End;

    If FTelnetClient or FTelnetServer Then ProcessBuf(FInBuf, FInBufEnd);
  End;

  If Len > FInBufEnd - FInBufPos Then Len := FInBufEnd - FInBufPos;

  Move (FInBuf[FInBufPos], Buf, Len);
  Inc  (FInBufPos, Len);

  Result := Len;
End;

Function TSocketClass.ReadLine (Var Str: String) : LongInt;
Var
  Ch  : Char;
  Res : LongInt;
Begin
  Str := '';
  Res := 0;

  Repeat
    If FInBufPos = FInBufEnd Then Res := ReadBuf(Ch, 0);

    Ch := FInBuf[FInBufPos];
    Inc (FInBufPos);
    If (Ch <> #10) And (Ch <> #13) And (FInBufEnd > 0) Then Str := Str + Ch;
  Until (Ch = #10) Or (Res < 0) Or (FInBufEnd = 0);

  If Res < 0 Then Result := -1 Else Result := Length(Str);
End;

Function TSocketClass.WriteBuf (Var Buf; Len: LongInt) : LongInt;
Begin
  Result := SockSend(FSocketHandle, Buf, Len, 0);
End;

Function TSocketClass.WriteStr (Str: String) : LongInt;
Begin
  Result := SockSend(FSocketHandle, Str[1], Length(Str), 0);
End;

Function TSocketClass.WriteFile (Str: String) : Boolean;
Var
  Buf  : Array[1..4096] of Char;
  Size : LongInt;
  F    : File;
Begin
  Result := False;

  FileMode := 66;

  Assign (F, Str);
  Reset  (F, 1);

  If IoResult <> 0 Then Exit;

  Repeat
    BlockRead (F, Buf, SizeOf(Buf), Size);

    If Size = 0 Then Break;

    If Buf[Size] = #26 Then Dec(Size);

    WriteBuf (Buf, Size);
  Until Size <> SizeOf(Buf);

  Result := True;
End;

Function TSocketClass.WriteLine (Str: String) : LongInt;
Begin
  Str    := Str + #13#10;
  Result := SockSend(FSocketHandle, Str[1], Length(Str), 0);
End;

Function TSocketClass.Connect (Address, Port: String) : Boolean;
Var
  Sin : TSockAddrIn;
  PHE : PHostEnt;
Begin
  Result        := False;
  FSocketHandle := SockSocket(PF_INET, SOCK_STREAM, 0);

  If FSocketHandle = -1 Then Exit;

  FillChar(Sin, SizeOf(Sin), 0);

  Sin.sin_Family      := PF_INET;
  Sin.sin_Port        := ResolvePort(Port);
  Sin.sin_Addr.S_Addr := Sockinetaddr(Address);

  If Sin.Sin_Addr.S_Addr <= 0 Then Begin
    PHE := SockGetHostByName(Address);

    If Not Assigned(PHE) Then Exit;

    Sin.Sin_Addr := PInAddr(PHE^.AddrList^)^;
  End;

  FPeerName := Address;
  FPeerIP   := Sockinetntoa(Sin.Sin_Addr);
  Result    := SockConnect(FSocketHandle, Sin, SizeOf(Sin)) = 0;
End;

Procedure TSocketClass.WaitInit (Port: String);
Var
  SIN : TSockAddrIn;
Begin
  FSocketHandle := SockSocket(PF_INET, SOCK_STREAM, 0);

  SIN.sin_family      := PF_INET;
  SIN.sin_addr.s_addr := 0; //INADDR_ANY;
  SIN.sin_port        := ResolvePort(Port);

  SockBind(FSocketHandle, SIN, SizeOf(SIN));

  SockSetBlocking(FSocketHandle, True);
End;

Function TSocketClass.WaitConnection : TSocketClass;
Var
  Sock   : LongInt;
  Client : TSocketClass;
  PHE    : PHostEnt;
  SIN    : TSockAddrIn;
  Temp   : LongInt;
Begin
  Result := NIL;

  If Not SockListen(FSocketHandle, 5) Then Exit;

  Temp := SizeOf(SIN);
  Sock := SockAccept(FSocketHandle, SIN, Temp);

  If Sock = -1 Then Exit;

  FPeerIP := Sockinetntoa(SIN.sin_addr);

  PHE := SockGetHostByAddr(SIN.sin_addr, 4, PF_INET);
  If Not Assigned(PHE) Then
    FPeerName := 'Unknown'
  Else
    FPeerName := StrPas(PHE^.name);

  Client := TSocketClass.Create;

  Client.SocketHandle  := Sock;
  Client.PeerName      := FPeerName;
  Client.PeerIP        := FPeerIP;
  Client.PeerPort      := FPort;
  Client.FTelnetServer := FTelnetServer;
  Client.FTelnetClient := FTelnetClient;

  If FTelnetServer Then
    Client.WriteStr(#255#251#001#255#251#003);  // IAC WILL ECHO

  Result := Client;
End;

Procedure TSocketClass.Status (Str: String);
Var
  Final : String;
Begin
  Try
    If SocketStatus.Count > 20 Then
      SocketStatus.Delete(0);

    Final := '(' + Copy(DateDos2Str(CurDateDos, 1), 1, 5) + ' ' + TimeDos2Str(CurDateDos, False) + ') ' + Str;

    If Length(Final) > 74 Then Begin
      SocketStatus.Add(Copy(Final, 1, 74));

      If SocketStatus.Count > 20 Then
        SocketStatus.Delete(0);

      SocketStatus.Add(strRep(' ', 14) + Copy(Final, 75, 255));
    End Else
      SocketStatus.Add(Final);
  Except
    { ignore exceptions here -- happens when socketstatus is NIL}
  End;

  StatusUpdated := True;
End;

Procedure TSocketClass.BufWriteChar (Ch: Char);
Begin
  FOutBuf[FOutBufPos] := Ch;
  Inc(FOutBufPos);

  If FOutBufPos > TSocketBufferSize Then Begin
    WriteBuf (FOutBuf, FOutBufPos - 1);
    FOutBufPos := 0;
  End;
End;

Procedure TSocketClass.BufWriteStr (Str: String);
Var
  Count : LongInt;
Begin
  For Count := 1 to Length(Str) Do
    BufWriteChar(Str[Count]);
End;

Procedure TSocketClass.BufFlush;
Begin
  If FOutBufPos > 0 Then Begin
    WriteBuf (FOutBuf, FOutBufPos);
    FOutBufPos := 0;
  End;
End;

End.
