{$I M_OPS.PAS}

Unit m_Socket_Linux;

Interface

{$LINKLIB c}

Uses
  Linux,
  m_Socket_Types;

Function getservbyname (name : pchar  ; protocol : pchar) : PServEnt;cdecl;
Function gethostbyname ( HostName : Pchar) : PHostEnt;cdecl;
Function gethostbyaddr ( Addr : pointer; Len : Longint; HType : Longint) : PHostEnt;cdecl;
Function inet_addr     (ipaddr: pchar): ULONG; cdecl;
Function hton          (Host : integer) : integer;
Function ntohs         (Net : integer) : integer;

Const
  SOCK_STREAM     = 1;               { stream (connection) socket   }
  SOCK_DGRAM      = 2;               { datagram (conn.less) socket  }
  SOCK_RAW        = 3;               { raw socket                   }
  SOCK_RDM        = 4;               { reliably-delivered message   }
  SOCK_SEQPACKET  = 5;               { sequential packet socket     }
  SOCK_PACKET     =10;
  AF_UNSPEC       = 0;
  AF_UNIX         = 1;      { Unix domain sockets          }
  AF_INET         = 2;      { Internet IP Protocol         }
  AF_AX25         = 3;      { Amateur Radio AX.25          }
  AF_IPX          = 4;      { Novell IPX                   }
  AF_APPLETALK    = 5;      { Appletalk DDP                }
  AF_NETROM       = 6;      { Amateur radio NetROM         }
  AF_BRIDGE       = 7;       { Multiprotocol bridge         }
  AF_AAL5         = 8;       { Reserved for Werner's ATM    }
  AF_X25          = 9;       { Reserved for X.25 project    }
  AF_INET6        = 10;      { IP version 6                 }
  AF_MAX          = 12;
  PF_UNSPEC       = AF_UNSPEC;
  PF_UNIX         = AF_UNIX;
  PF_INET         = AF_INET;
  PF_AX25         = AF_AX25;
  PF_IPX          = AF_IPX;
  PF_APPLETALK    = AF_APPLETALK;
  PF_NETROM       = AF_NETROM;
  PF_BRIDGE       = AF_BRIDGE;
  PF_AAL5         = AF_AAL5;
  PF_X25          = AF_X25;
  PF_INET6        = AF_INET6;
  PF_MAX          = AF_MAX;

Const
  { Two constants to determine whether part of soket is for in or output }
  S_IN = 0;
  S_OUT = 1;

Type
  TSockAddr = packed Record
    family:word;  { was byte, fixed }
    data  :array [0..13] of char;
    end;

  TUnixSockAddr = packed Record
    family:word; { was byte, fixed }
    path:array[0..108] of char;
    end;

  TInetSockAddr = packed Record
    family:Word;
    port  :Word;
    addr  :Cardinal;
    pad   :array [1..8] of byte; { to get to the size of sockaddr... }
    end;

  TSockArray = Array[1..2] of Longint;

Var
  SocketError:Longint;

{Basic Socket Functions}
Function Socket(Domain,SocketType,Protocol:Longint):Longint;
Function Send(Sock:Longint;var Addr;AddrLen,Flags:Longint):Longint;
Function Recv(Sock:Longint;var Addr;AddrLen,Flags:Longint):Longint;
Function Bind(Sock:Longint;var Addr;AddrLen:Longint):longint;
Function Listen (Sock,MaxConnect:Longint):longint;
Function Accept(Sock:Longint;Var Addr;Var Addrlen:Longint):Longint;
Function Connect(Sock:Longint;Var Addr;Addrlen:Longint):Longint;
Function Shutdown(Sock:Longint;How:Longint):Longint;
Function GetSockName(Sock:Longint;Var Addr;Var Addrlen:Longint):Longint;
Function GetPeerName(Sock:Longint;Var Addr;Var Addrlen:Longint):Longint;
Function SetSockOpt(Sock,Level,OptName:Longint;Var OptVal;optlen:longint):Longint;
Function GetSockOpt(Sock,Level,OptName:Longint;Var OptVal;optlen:longint):Longint;
Function SocketPair(Domain,SocketType,Protocol:Longint;var Pair:TSockArray):Longint;
Function CloseSocket (S: longint): LongInt;

Implementation

function getservbyname (name : pchar  ; protocol : pchar) : PServEnt; cdecl; external;
function gethostbyname ( HostName : Pchar) : PHostEnt; cdecl; external;
function gethostbyaddr ( Addr : Pointer; Len : Longint; HType : Longint) : PHostent ; cdecl; external;
function inet_addr(ipaddr: pchar): ULONG; cdecl; external;

Function hton (Host : integer) : integer;
 begin
  hton:=lo(host)*256+Hi(Host);
end;

Function ntohs(Net : integer) : integer;
begin
  ntohs:=lo(Net)*256+Hi(Net);
end;

Const
  Socket_Sys_SOCKET      = 1;
  Socket_Sys_BIND        = 2;
  Socket_Sys_CONNECT     = 3;
  Socket_Sys_LISTEN      = 4;
  Socket_Sys_ACCEPT      = 5;
  Socket_Sys_GETSOCKNAME = 6;
  Socket_Sys_GETPEERNAME = 7;
  Socket_Sys_SOCKETPAIR  = 8;
  Socket_Sys_SEND        = 9;
  Socket_Sys_RECV        = 10;
  Socket_Sys_SENDTO      = 11;
  Socket_Sys_RECVFROM    = 12;
  Socket_Sys_SHUTDOWN    = 13;
  Socket_Sys_SETSOCKOPT  = 14;
  Socket_Sys_GETSOCKOPT  = 15;
  Socket_Sys_SENDMSG     = 16;
  Socket_Sys_RECVMSG     = 17;

Function SocketCall(SockCallNr,a1,a2,a3,a4,a5,a6:longint):longint;
var
  Regs:SysCallRegs;
  Args:array[1..6] of longint;
begin
  args[1]:=a1;
  args[2]:=a2;
  args[3]:=a3;
  args[4]:=a4;
  args[5]:=a5;
  args[6]:=a6;
  regs.reg2:=SockCallNr;
  regs.reg3:=Longint(@args);
  SocketCall:=Syscall(syscall_nr_socketcall,regs);
  if Result < 0 then
   SocketError:=Errno
  else
   SocketError:=0;
end;

Function socket(Domain,SocketType,Protocol:Longint):Longint;
begin
  Socket:=SocketCall(Socket_Sys_Socket,Domain,SocketType,ProtoCol, 0, 0, 0);
end;

Function Send(Sock:Longint;var Addr;AddrLen,Flags:Longint):Longint;
begin
  Send:=SocketCall(Socket_Sys_Send,Sock,Longint(@Addr),AddrLen,Flags,0,0);
end;

Function Recv(Sock:Longint;var Addr;AddrLen,Flags:Longint):Longint;
begin
  Recv:=SocketCall(Socket_Sys_Recv,Sock,Longint(@Addr),AddrLen,Flags,0,0);
end;

Function Bind(Sock:Longint;Var Addr;AddrLen:Longint):longint;
begin
  Bind:=SocketCall(Socket_Sys_Bind,Sock,Longint(@Addr),AddrLen, 0, 0, 0);
end;

Function Listen(Sock,MaxConnect:Longint):longint;
begin
  Listen:=SocketCall(Socket_Sys_Listen,Sock,MaxConnect,0,0,0,0);
end;

Function Accept(Sock:Longint;Var Addr;Var Addrlen:Longint):Longint;
begin
  Result := SocketCall(Socket_Sys_Accept,Sock,longint(@Addr),longint(@AddrLen),0,0,0);
  If Result < 0 Then Result := -1;
end;

Function Connect(Sock:Longint;Var Addr;Addrlen:Longint):Longint;
begin
  Result := SocketCall(Socket_Sys_Connect,Sock,longint(@Addr),AddrLen,0,0,0);
  If Result < 0 Then
    Result := -1;
end;

Function Shutdown(Sock:Longint;How:Longint):Longint;
begin
  ShutDown:=SocketCall(Socket_Sys_ShutDown,Sock,How,0,0,0,0);
end;

Function GetSockName(Sock:Longint;Var Addr;Var Addrlen:Longint):Longint;
begin
  GetSockName:=SocketCall(Socket_Sys_GetSockName,Sock,longint(@Addr),longint(@AddrLen),0,0,0);
end;

Function GetPeerName(Sock:Longint;Var Addr;Var Addrlen:Longint):Longint;
begin
  GetPeerName:=SocketCall(Socket_Sys_GetPeerName,Sock,longint(@Addr),longint(@AddrLen),0,0,0);
end;

Function SetSockOpt(Sock,Level,OptName:Longint;Var OptVal;optlen:longint):Longint;
begin
  SetSockOpt:=SocketCall(Socket_Sys_SetSockOpt,Sock,Level,OptName,Longint(@OptVal),OptLen,0);
end;

Function GetSockOpt(Sock,Level,OptName:Longint;Var OptVal;optlen:longint):Longint;
begin
  GetSockOpt:=SocketCall(Socket_Sys_GetSockOpt,Sock,Level,OptName,Longint(@OptVal),OptLen,0);
end;

Function SocketPair(Domain,SocketType,Protocol:Longint;var Pair:TSockArray):Longint;
begin
  SocketPair:=SocketCall(Socket_Sys_SocketPair,Domain,SocketType,Protocol,longint(@Pair),0,0);
end;

Procedure Str2UnixSockAddr(const addr:string;var t:TUnixSockAddr;var len:longint);
begin
  Move(Addr[1],t.Path,length(Addr));
  t.Family:=AF_UNIX;
  t.Path[length(Addr)]:=#0;
  Len:=Length(Addr)+3;
end;

Function DoAccept(Sock:longint;Var addr:TInetSockAddr):longint;
Var AddrLen : Longint;
begin
  AddrLEn:=SizeOf(Addr);
  DoAccept:=Accept(Sock,Addr,AddrLen);
end;

Function CloseSocket (S: longint): LongInt;
begin
//  closesocket := close(s);
// what do we do here
end;

End.
