{$I M_OPS.PAS}

Unit MCFG_Arcs;

Interface

Procedure ArchiveEditor;

Implementation

Uses
  m_FileIO,
  m_MenuBox,
  m_MenuForm,
  m_Strings,
  MCFG_Common;

Procedure EditArchive (Var Arc: RecArchive);
Var
  Box      : TMenuBox;
  Form     : TMenuForm;
  Topic    : String;
Begin
  Topic := '|03(|09Archive Editor|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' Archive Editor: ' + Arc.Desc + ' ';

  Box.Open (13, 5, 67, 14);

  VerticalLine (28, 7, 12);

  Form.AddStr  ('X', ' Extension '      , 17,  7, 30,  7, 11, 4, 4, @Arc.Ext, Topic + 'File archive extension');
  Form.AddTog  ('O', ' OS '             , 24,  8, 30,  8,  4, 7, 0, 1, 'Windows Linux', @Arc.OSType, Topic + 'Operating system for this archive setup');
  Form.AddStr  ('D', ' Description '    , 15,  9, 30,  9, 13, 20, 20, @Arc.Desc, Topic + 'Description of archiver');
  Form.AddStr  ('P', ' Pack Cmd '       , 18, 10, 30, 10, 10, 35, 80, @Arc.Pack, Topic + 'Command line to pack files');
  Form.AddStr  ('U', ' Unpack Cmd '     , 16, 11, 30, 11, 12, 35, 80, @Arc.Unpack, Topic + 'Command line to unpack files');
  Form.AddStr  ('V', ' View Cmd '       , 18, 12, 30, 12, 10, 35, 80, @Arc.View, Topic + 'Command line to view contents of archive');

  Form.Execute;
  Box.Close;

  Form.Free;
  Box.Free;
End;

Procedure ArchiveEditor;
Var
  Box  : TMenuBox;
  List : TMenuList;
  F    : TBufFile;
  Arc  : RecArchive;

  // SORT THIS LIST BY NON CASE SENSITIVE ARCHIVE EXTENSION
  Procedure MakeList;
  Var
    OS : String;
  Begin
    List.Clear;

    F.Reset;
    While Not F.Eof Do Begin
      F.Read (Arc);

      Case Arc.OSType of
        0 : OS := 'Windows';
        1 : OS := 'Linux  ';
      End;

      List.Add (strPadR(Arc.Ext, 7, ' ') + OS + '   ' + Arc.Desc, 0);
    End;

    List.Add ('', 2);
  End;

Begin
  F := TBufFile.Create(SizeOf(RecDoors));

  F.Open (BbsConfig.PathData + 'archive.dat', fmOpenCreate, fmReadWrite + fmDenyNone, SizeOf(RecDoors));

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  Box.Header    := ' Archive Editor ';
  List.NoWindow := True;
  List.LoChars  := #01#04#13#27;

  Box.Open (13, 5, 67, 20);

  Console.WriteXY (15,  6, 112, 'Ext    OSID      Description');
  Console.WriteXY (15,  7, 112, strRep('', 51));
  Console.WriteXY (15, 18, 112, strRep('', 51));
  Console.WriteXY (18, 19, 112, '(CTRL/A) Add   (CTRL/D) Delete   (ENTER) Edit');

  Repeat
    MakeList;

    List.Open (13, 7, 67, 18);
    List.Close;

    Case List.ExitCode of
      #04 : If List.Picked < List.ListMax Then
              If ShowMsgBox(1, 'Delete this entry?') Then Begin
                F.RecordDelete (List.Picked);
                MakeList;
              End;
      #01 : Begin
              F.RecordInsert (List.Picked);

              Arc.OSType := {$IFDEF WIN32} 0 {$ELSE} 1 {$ENDIF};
              Arc.Desc   := 'New archive';
              Arc.Ext    := 'NEW';
              Arc.Pack   := '';
              Arc.Unpack := '';
              Arc.View   := '';

              F.Write (Arc);

              MakeList;
            End;
      #13 : If List.Picked <> List.ListMax Then Begin
              F.Seek (List.Picked - 1);
              F.Read (Arc);

              EditArchive(Arc);

              F.Seek  (List.Picked - 1);
              F.Write (Arc);
            End;
      #27 : Break;
    End;
  Until False;

  F.Close;
  F.Free;

  Box.Close;
  List.Free;
  Box.Free;
End;

End.
