Unit MCFG_CHAT;

Interface

Uses
  m_Strings,
  m_FileIO,
  m_MenuBox,
  m_MenuForm,
  MCFG_Common;

Procedure ChatRoomEditor;

Implementation

Procedure EditRoom (Var Room: RecChatRoom);
Var
  Box      : TMenuBox;
  Form     : TMenuForm;
  Topic    : String;
  LastDate : String[8];
Begin
  Topic    := '|03(|09Chat Room Editor|03) |01-|09> |15';
  Box      := TMenuBox.Create(Console);
  Form     := TMenuForm.Create(Console);

  Box.Header := ' Room Editor: ' + Room.Topic + ' ';

  Box.Open     (11, 5, 70, 11);
  VerticalLine (27, 7, 9);

  Form.AddStr ('T', ' Topic '       , 20, 7, 29, 7,  7, 40, 40, @Room.Topic, Topic + 'Current room topic');
  Form.AddStr ('J', ' Join ACS '    , 17, 8, 29, 8, 10, mysMaxAcsSize, mysMaxAcsSize, @Room.JoinACS, Topic + 'Access level to join this channel');
  Form.AddStr ('O', ' Operator ACS ', 13, 9, 29, 9, 14, mysMaxAcsSize, mysMaxAcsSize, @Room.OpACS,   Topic + 'Access level for operator status');
  Form.Execute;
  Box.Close;

  Form.Free;
  Box.Free;
End;

Procedure ChatRoomEditor;
Var
  Box  : TMenuBox;
  List : TMenuList;
  F    : TBufFile;
  Room : RecChatRoom;

  Procedure MakeList;
  Begin
    List.Clear;

    F.Reset;
    While Not F.Eof Do Begin
      F.Read (Room);
      List.Add (strPadR(strI2S(F.FilePos), 2, ' ') + '  ' + Room.Topic, 0);
    End;

    List.Add ('', 2);
  End;

Begin
  F := TBufFile.Create(SizeOf(RecChatRoom));

  F.Open (BbsConfig.PathData + 'chatroom.dat', fmOpenCreate, fmReadWrite + fmDenyNone, SizeOf(RecChatRoom));

  If F.FileSize = 0 Then Begin
    Room.Topic   := 'General chat';
    Room.JoinACS := '';
    Room.OpACS   := '';
    F.Write (Room);
  End;

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  Box.Header    := ' Chat Room Editor ';
  List.NoWindow := True;
  List.LoChars  := #01#04#13#27;

  Box.Open (13, 5, 67, 20);

  Console.WriteXY (15,  6, 112, '##  Topic');
  Console.WriteXY (15,  7, 112, strRep('-', 51));
  Console.WriteXY (15, 18, 112, strRep('-', 51));
  Console.WriteXY (18, 19, 112, '(CTRL/A) Add   (CTRL/D) Delete   (ENTER) Edit');

  Repeat
    MakeList;

    List.Open (13, 7, 67, 18);
    List.Close;

    Case List.ExitCode of
      #04 : If (List.Picked <> 1) And (List.Picked < List.ListMax) Then
              If ShowMsgBox(1, 'Delete this entry?') Then Begin
                F.RecordDelete (List.Picked);
                MakeList;
              End;
      #01 : If List.ListMax < 100 Then Begin
              F.RecordInsert (List.Picked);

              Room.Topic   := 'General chat';
              Room.JoinACS := '';
              Room.OpACS   := '';

              F.Write (Room);

              MakeList;
            End;
      #13 : If List.Picked <> List.ListMax Then Begin
              F.Seek   (List.Picked - 1);
              F.Read   (Room);
              EditRoom (Room);
              F.Seek   (List.Picked - 1);
              F.Write  (Room);
            End;
      #27 : Break;
    End;
  Until False;

  F.Close;
  F.Free;

  Box.Close;
  List.Free;
  Box.Free;
End;

End.
