Unit MCFG_Group;

Interface

Procedure GroupEditor (Msg: Boolean);

Implementation

Uses
  m_MenuBox,
  m_MenuForm,
  m_FileIO,
  m_Strings,
  MCFG_Common;

Procedure EditGroup (Var Group: RecGroup);
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Topic := '|03(|09Group Editor|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' Group Editor ';

  Box.Open (14, 10, 67, 16);

  VerticalLine (24, 12, 14);

  Form.AddStr ('N', ' Name '  , 18, 12, 26, 12, 6, 40, 40, @Group.Desc, Topic + 'Description of group');
  Form.AddStr ('A', ' Access ', 16, 13, 26, 13, 8, 30, 30, @Group.Access, Topic + 'Access level to access this group');
  Form.AddBol ('H', ' Hidden ', 16, 14, 26, 14, 8,  3, @Group.Hidden, Topic + 'Group is hidden from group listing?');
  Form.Execute;

  Box.Close;
  Form.Free;
  Box.Free;
End;

Procedure GroupEditor (Msg: Boolean);
Const
  Status = '(CTRL+A) Add   (CTRL+D) Delete   (ENTER) Edit';
Var
  Box       : TMenuBox;
  List      : TMenuList;
  GroupFile : TBufFile;
  Group     : RecGroup;

  Procedure MakeList;
  Begin
    List.Clear;

    GroupFile.Reset;

    While Not GroupFile.EOF Do Begin
      GroupFile.Read (Group);

      List.Add(strPadR(strI2S(GroupFile.FilePos), 3, ' ') + '  ' + strStripMCI(Group.Desc), 0);
    End;

    List.Add('', 2);
  End;

Begin
  GroupFile := TBufFile.Create(4096);

  If Msg Then Begin
    If Not GroupFile.Open(bbsConfig.PathData + 'groups_m.dat', fmOpenCreate, fmReadWrite + fmDenyNone, SizeOf(RecGroup)) Then Begin
      GroupFile.Free;
      Exit;
    End;
  End Else Begin
    If Not GroupFile.Open(bbsConfig.PathData + 'groups_f.dat', fmOpenCreate, fmReadWrite + fmDenyNone, SizeOf(RecGroup)) Then Begin
      GroupFile.Free;
      Exit;
    End;
  End;

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  Console.WriteXYPipe (5, 25, 7, 75, Status);

  List.NoWindow := True;
  List.LoChars  := #01#04#13#27;

  Box.Header := ' Group Editor ';

  Box.Open (21, 7, 59, 19);

  If Msg Then
    Console.WriteXY (23, 8, 112, '###  Message Group Name')
  Else
    Console.WriteXY (23, 8, 112, '###  File Group Name');

  Console.WriteXY (22, 9, 112, strRep('', 37));

  Repeat
    MakeList;

    List.Open (21, 9, 59, 19);
    List.Close;

    Case List.ExitCode of
      #04 : If List.Picked < List.ListMax Then
              If ShowMsgBox(1, 'Delete this entry?') Then Begin
                GroupFile.RecordDelete (List.Picked);
                MakeList;
              End;
      #01 : Begin
              GroupFile.RecordInsert (List.Picked);

              Group.Desc   := 'New Group';
              Group.Access := '';
              Group.Hidden := False;

              GroupFile.Write (Group);

              MakeList;
            End;
      #13 : If List.Picked <> List.ListMax Then Begin
              GroupFile.Seek (List.Picked - 1);
              GroupFile.Read (Group);

              EditGroup(Group);

              GroupFile.Seek  (List.Picked - 1);
              GroupFile.Write (Group);

              Console.WriteXYPipe (5, 25, 7, 75, Status);
            End;
      #27 : Break;
    End;
  Until False;

  Box.Close;

  GroupFile.Free;
  List.Free;
  Box.Free;
End;

End.
