{$I M_OPS.PAS}

// find way to eliminate findvariable function.. will speed up a *LOT*
// possibly save a symbol table in each .mpe?
// remove the mplverlength stuff in movetopos??

Unit MPL_Execute;

Interface

Uses
  DOS,
  MPL_FileIO,
  BBS_Common;

{$I MPL_TYPES.PAS}

Const
  mplExecuteBuffer = 16 * 1024;

Type
  TInterpEngine = Class
    Owner      : Pointer;
    ErrStr     : String;
    ErrNum     : Byte;
    DataFile   : PCharFile;
    CurVarNum  : Word;
    CurVarID   : Word;
    CurRecNum  : Word;
    VarData    : VarDataRec;
    RecData    : RecDataRec;
    Ch         : Char;
    W          : Word;
//    CurPos     : LongInt;
    IoError    : LongInt;
    ReloadMenu : Boolean;
    DirInfo    : SearchRec;
    IdxVarDir  : Word;
    IdxVarUser : Word;
    ParamsStr  : String;
    MPEName    : String;
    Done       : Boolean;
    ExitProc   : Boolean;

    Function  GetErrorMsg : String;
    Function  FindVariable (ID: Word) : Word;
    Procedure Error (Err: Byte; Str: String);
    Procedure MoveToPos (Num: LongInt);
    Procedure SkipBlock;

    Function  CurFilePos : LongInt;
    Procedure NextChar;
    Procedure NextWord;
    Procedure PrevChar;
    Function  xDataPtr (VN: Word; Var A: TArrayInfo) : Pointer;
    Procedure xCheckArray (VN: Word; Var A: TArrayInfo);
    Function  xVarNumReal (VN: Word; Var A: TArrayInfo) : Real;
    Function  xNumReal (Var Num; T: TIdentTypes) : Real;
    Function  EvaluateNumber : Real;
    Function  EvaluateString : String;
    Function  EvaluateBoolean : Boolean;
    Procedure SetString (VarNum: Word; Var A: TArrayInfo; Str: String);
    Procedure SetVariable (VarNum: Word);
    Procedure SetNumber (VN: Word; R: Real; Var A: TArrayInfo);
    Function  xDataSize (VarNum: Word) : Word;

    Procedure DefineVariable;
    Procedure DefineProcedure;
    Procedure DefineRecord;

    Procedure StatementRepeatUntil;
    Function  StatementIfThenElse : Byte;
    Function  StatementCase : Byte;
    Procedure StatementForLoop;
    Procedure StatementWhileDo;

    Function  ExecuteProcedure (DP: Pointer) : TIdentTypes;
    Function  ExecuteBlock (StartVar, StartRec: Word) : Byte;

 // BBS DATA ACCESS FUNCTIONS
    Procedure GetUserVars   (Var U: RecUser);
    Function  GetUserRecord (Num: LongInt) : Boolean;
    Function  GetUserByName (Str: String) : Boolean;
    Function  GetUserByID   (ID: LongInt) : Boolean;
    Procedure PutUserVars   (Var U: RecUser);
    Procedure PutUserRecord (Num: LongInt);
    Function  GetSauce      (Var FN, Title, Author, Group, Date: String) : Boolean;
    Procedure FileReadLine  (Var F: File; Var Str: String);
    Procedure FileWriteLine (Var F: File; Str: String);

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;
    Function    Execute (FN: String) : Byte;
  End;

Function ExecuteMPE (Owner: Pointer; Str: String) : Byte;

Implementation

Uses
  m_Bits,
  m_Strings,
  m_DateTime,
  m_Types,
  BBS_Core,
  BBS_User,
  m_FileIO;

{$I MPL_COMMON.PAS}

Constructor TInterpEngine.Create (O: Pointer);
Begin
  Inherited Create;

  Owner     := O;
  ErrNum    := 0;
  ErrStr    := '';
  Ch        := #0;
  W         := 0;
End;

Destructor TInterpEngine.Destroy;
Var
  Count : LongInt;
Begin
//  writeln('freeing vars: ', curvarnum);

  For Count := 1 to CurVarNum Do Begin
//    if vardata[count] = nil then writeln('var is NIL');
    If (VarData[Count]^.Kill) And (VarData[Count]^.Data <> NIL) Then //begin
//      writeln('freeing: ', vardata[count]^.datasize);
      FreeMem(VarData[Count]^.Data, VarData[Count]^.DataSize);
//    end;

    Dispose(VarData[Count]);
  End;

  For Count := 1 to CurRecNum Do
    Dispose(RecData[Count]);

  CurVarNum := 0;
  CurRecNum := 0;

  Inherited Destroy;
End;

Procedure TInterpEngine.PutUserVars (Var U: RecUser);
Var
  Temp : String[1];
Begin
  Move (VarData[IdxVarUser     ]^.Data^, U.UserID,       SizeOf(U.UserID));
  Move (VarData[IdxVarUser + 1 ]^.Data^, U.RealName,     SizeOf(U.RealName));
  Move (VarData[IdxVarUser + 2 ]^.Data^, U.Handle,       SizeOf(U.Handle));
  Move (VarData[IdxVarUser + 3 ]^.Data^, U.Password,     SizeOf(U.Password));
  Move (VarData[IdxVarUser + 4 ]^.Data^, U.Street,       SizeOf(U.Street));
  Move (VarData[IdxVarUser + 5 ]^.Data^, U.CityState,    SizeOf(U.CityState));
  Move (VarData[IdxVarUser + 6 ]^.Data^, U.ZipCode,      SizeOf(U.ZipCode));
  Move (VarData[IdxVarUser + 7 ]^.Data^, U.HomePhone,    SizeOf(U.HomePhone));
  Move (VarData[IdxVarUser + 8 ]^.Data^, U.DataPhone,    SizeOf(U.DataPhone));

  Move (VarData[IdxVarUser + 9 ]^.Data^, Temp, SizeOf(Temp));
  U.Gender := Temp[1];

  Move (VarData[IdxVarUser + 10]^.Data^, U.Birthdate,    SizeOf(U.Birthdate));
  Move (VarData[IdxVarUser + 11]^.Data^, U.Email,        SizeOf(U.Email));
  Move (VarData[IdxVarUser + 12]^.Data^, U.UserInfo,     SizeOf(U.UserInfo));
  Move (VarData[IdxVarUser + 13]^.Data^, U.Security,     SizeOf(U.Security));
  Move (VarData[IdxVarUser + 14]^.Data^, U.StartMenu,    SizeOf(U.StartMenu));
  Move (VarData[IdxVarUser + 15]^.Data^, U.Expires,      SizeOf(U.Expires));
  Move (VarData[IdxVarUser + 16]^.Data^, U.ExpiresTo,    SizeOf(U.ExpiresTo));
  Move (VarData[IdxVarUser + 17]^.Data^, U.AF1,          SizeOf(U.AF1));
  Move (VarData[IdxVarUser + 18]^.Data^, U.AF2,          SizeOf(U.AF2));
  Move (VarData[IdxVarUser + 19]^.Data^, U.DateType,     SizeOf(U.DateType));
  Move (VarData[IdxVarUser + 20]^.Data^, U.ScreenSize,   SizeOf(U.ScreenSize));
  Move (VarData[IdxVarUser + 21]^.Data^, U.HotKeys,      SizeOf(U.HotKeys));
  Move (VarData[IdxVarUser + 22]^.Data^, U.FSEditor,     SizeOf(U.FSEditor));
  Move (VarData[IdxVarUser + 23]^.Data^, U.QuoteWindow,  SizeOf(U.QuoteWindow));
  Move (VarData[IdxVarUser + 24]^.Data^, U.FSFileList,   SizeOf(U.FSFileList));
  Move (VarData[IdxVarUser + 25]^.Data^, U.FSMsgReader,  SizeOf(U.FSMsgReader));
  Move (VarData[IdxVarUser + 26]^.Data^, U.FSMsgIndex,   SizeOf(U.FSMsgIndex));
  Move (VarData[IdxVarUser + 27]^.Data^, U.FSMsgEIndex,  SizeOf(U.FSMsgEIndex));
  Move (VarData[IdxVarUser + 28]^.Data^, U.FSNodeChat,   SizeOf(U.FSNodeChat));
  Move (VarData[IdxVarUser + 29]^.Data^, U.AutoSig,      SizeOf(U.AutoSig));
  Move (VarData[IdxVarUser + 30]^.Data^, U.AutoSigPtr,   SizeOf(U.AutoSigPtr));
  Move (VarData[IdxVarUser + 31]^.Data^, U.Archive,      SizeOf(U.Archive));
  Move (VarData[IdxVarUser + 32]^.Data^, U.Theme,        SizeOf(U.Theme));
  Move (VarData[IdxVarUser + 33]^.Data^, U.ChatName,     SizeOf(U.ChatName));
  Move (VarData[IdxVarUser + 34]^.Data^, U.Invisible,    SizeOf(U.Invisible));
  Move (VarData[IdxVarUser + 35]^.Data^, U.Available,    SizeOf(U.Available));
  Move (VarData[IdxVarUser + 36]^.Data^, U.PeerIP,       SizeOf(U.PeerIP));
  Move (VarData[IdxVarUser + 37]^.Data^, U.PeerName,     SizeOf(U.PeerName));
  Move (VarData[IdxVarUser + 38]^.Data^, U.TimeLeft,     SizeOf(U.TimeLeft));
  Move (VarData[IdxVarUser + 39]^.Data^, U.LastMBase,    SizeOf(U.LastMBase));
  Move (VarData[IdxVarUser + 40]^.Data^, U.LastMGroup,   SizeOf(U.LastMGroup));
  Move (VarData[IdxVarUser + 41]^.Data^, U.LastFBase,    SizeOf(U.LastFBase));
  Move (VarData[IdxVarUser + 42]^.Data^, U.LastFGroup,   SizeOf(U.LastFGroup));
  Move (VarData[IdxVarUser + 43]^.Data^, U.Calls,        SizeOf(U.Calls));
  Move (VarData[IdxVarUser + 44]^.Data^, U.CallsToday,   SizeOf(U.CallsToday));
  Move (VarData[IdxVarUser + 45]^.Data^, U.Downloads,    SizeOf(U.Downloads));
  Move (VarData[IdxVarUser + 46]^.Data^, U.DLsToday,     SizeOf(U.DLsToday));
  Move (VarData[IdxVarUser + 47]^.Data^, U.DownloadKB,   SizeOf(U.DownloadKB));
  Move (VarData[IdxVarUser + 48]^.Data^, U.DLkbToday,    SizeOf(U.DLkbToday));
  Move (VarData[IdxVarUser + 49]^.Data^, U.FirstCall,    SizeOf(U.FirstCall));
  Move (VarData[IdxVarUser + 50]^.Data^, U.LastCall,     SizeOf(U.LastCall));
  Move (VarData[IdxVarUser + 51]^.Data^, U.MsgPosts,     SizeOf(U.MsgPosts));
  Move (VarData[IdxVarUser + 52]^.Data^, U.Emails,       SizeOf(U.Emails));
  Move (VarData[IdxVarUser + 53]^.Data^, U.Uploads,      SizeOf(U.Uploads));
  Move (VarData[IdxVarUser + 54]^.Data^, U.UploadKB,     SizeOf(U.UploadKB));
  Move (VarData[IdxVarUser + 55]^.Data^, U.TimeBank,     SizeOf(U.TimeBank));
  Move (VarData[IdxVarUser + 56]^.Data^, U.LastPWChange, SizeOf(U.LastPWChange));
  Move (VarData[IdxVarUser + 57]^.Data^, U.YesVotes,     SizeOf(U.YesVotes));
  Move (VarData[IdxVarUser + 58]^.Data^, U.NoVotes,      SizeOf(U.NoVotes));
  Move (VarData[IdxVarUser + 59]^.Data^, U.DoorsRan,     SizeOf(U.DoorsRan));
  Move (VarData[IdxVarUser + 60]^.Data^, U.Flags,        SizeOf(U.Flags));
  Move (VarData[IdxVarUser + 61]^.Data^, U.Optional,     SizeOf(U.Optional));
End;

Procedure TInterpEngine.GetUserVars (Var U: RecUser);
Var
  Temp : String[1];
Begin
  Move (U.UserID,       VarData[IdxVarUser     ]^.Data^, SizeOf(U.UserID));
  Move (U.RealName,     VarData[IdxVarUser + 1 ]^.Data^, SizeOf(U.RealName));
  Move (U.Handle,       VarData[IdxVarUser + 2 ]^.Data^, SizeOf(U.Handle));
  Move (U.Password,     VarData[IdxVarUser + 3 ]^.Data^, SizeOf(U.Password));
  Move (U.Street,       VarData[IdxVarUser + 4 ]^.Data^, SizeOf(U.Street));
  Move (U.CityState,    VarData[IdxVarUser + 5 ]^.Data^, SizeOf(U.CityState));
  Move (U.ZipCode,      VarData[IdxVarUser + 6 ]^.Data^, SizeOf(U.ZipCode));
  Move (U.HomePhone,    VarData[IdxVarUser + 7 ]^.Data^, SizeOf(U.HomePhone));
  Move (U.DataPhone,    VarData[IdxVarUser + 8 ]^.Data^, SizeOf(U.DataPhone));

  Temp := U.Gender;
  Move (Temp, VarData[IdxVarUser + 9 ]^.Data^, SizeOf(Temp));

  Move (U.Birthdate,    VarData[IdxVarUser + 10]^.Data^, SizeOf(U.Birthdate));
  Move (U.Email,        VarData[IdxVarUser + 11]^.Data^, SizeOf(U.Email));
  Move (U.UserInfo,     VarData[IdxVarUser + 12]^.Data^, SizeOf(U.UserInfo));
  Move (U.Security,     VarData[IdxVarUser + 13]^.Data^, SizeOf(U.Security));
  Move (U.StartMenu,    VarData[IdxVarUser + 14]^.Data^, SizeOf(U.StartMenu));
  Move (U.Expires,      VarData[IdxVarUser + 15]^.Data^, SizeOf(U.Expires));
  Move (U.ExpiresTo,    VarData[IdxVarUser + 16]^.Data^, SizeOf(U.ExpiresTo));
  Move (U.AF1,          VarData[IdxVarUser + 17]^.Data^, SizeOf(U.AF1));
  Move (U.AF2,          VarData[IdxVarUser + 18]^.Data^, SizeOf(U.AF2));
  Move (U.DateType,     VarData[IdxVarUser + 19]^.Data^, SizeOf(U.DateType));
  Move (U.ScreenSize,   VarData[IdxVarUser + 20]^.Data^, SizeOf(U.ScreenSize));
  Move (U.HotKeys,      VarData[IdxVarUser + 21]^.Data^, SizeOf(U.HotKeys));
  Move (U.FSEditor,     VarData[IdxVarUser + 22]^.Data^, SizeOf(U.FSEditor));
  Move (U.QuoteWindow,  VarData[IdxVarUser + 23]^.Data^, SizeOf(U.QuoteWindow));
  Move (U.FSFileList,   VarData[IdxVarUser + 24]^.Data^, SizeOf(U.FSFileList));
  Move (U.FSMsgReader,  VarData[IdxVarUser + 25]^.Data^, SizeOf(U.FSMsgReader));
  Move (U.FSMsgIndex,   VarData[IdxVarUser + 26]^.Data^, SizeOf(U.FSMsgIndex));
  Move (U.FSMsgEIndex,  VarData[IdxVarUser + 27]^.Data^, SizeOf(U.FSMsgEIndex));
  Move (U.FSNodeChat,   VarData[IdxVarUser + 28]^.Data^, SizeOf(U.FSNodeChat));
  Move (U.AutoSig,      VarData[IdxVarUser + 29]^.Data^, SizeOf(U.AutoSig));
  Move (U.AutoSigPtr,   VarData[IdxVarUser + 30]^.Data^, SizeOf(U.AutoSigPtr));
  Move (U.Archive,      VarData[IdxVarUser + 31]^.Data^, SizeOf(U.Archive));
  Move (U.Theme,        VarData[IdxVarUser + 32]^.Data^, SizeOf(U.Theme));
  Move (U.ChatName,     VarData[IdxVarUser + 33]^.Data^, SizeOf(U.ChatName));
  Move (U.Invisible,    VarData[IdxVarUser + 34]^.Data^, SizeOf(U.Invisible));
  Move (U.Available,    VarData[IdxVarUser + 35]^.Data^, SizeOf(U.Available));
  Move (U.PeerIP,       VarData[IdxVarUser + 36]^.Data^, SizeOf(U.PeerIP));
  Move (U.PeerName,     VarData[IdxVarUser + 37]^.Data^, SizeOf(U.PeerName));
  Move (U.TimeLeft,     VarData[IdxVarUser + 38]^.Data^, SizeOf(U.TimeLeft));
  Move (U.LastMBase,    VarData[IdxVarUser + 39]^.Data^, SizeOf(U.LastMBase));
  Move (U.LastMGroup,   VarData[IdxVarUser + 40]^.Data^, SizeOf(U.LastMGroup));
  Move (U.LastFBase,    VarData[IdxVarUser + 41]^.Data^, SizeOf(U.LastFBase));
  Move (U.LastFGroup,   VarData[IdxVarUser + 42]^.Data^, SizeOf(U.LastFGroup));
  Move (U.Calls,        VarData[IdxVarUser + 43]^.Data^, SizeOf(U.Calls));
  Move (U.CallsToday,   VarData[IdxVarUser + 44]^.Data^, SizeOf(U.CallsToday));
  Move (U.Downloads,    VarData[IdxVarUser + 45]^.Data^, SizeOf(U.Downloads));
  Move (U.DLsToday,     VarData[IdxVarUser + 46]^.Data^, SizeOf(U.DLsToday));
  Move (U.DownloadKB,   VarData[IdxVarUser + 47]^.Data^, SizeOf(U.DownloadKB));
  Move (U.DLkbToday,    VarData[IdxVarUser + 48]^.Data^, SizeOf(U.DLkbToday));
  Move (U.FirstCall,    VarData[IdxVarUser + 49]^.Data^, SizeOf(U.FirstCall));
  Move (U.LastCall,     VarData[IdxVarUser + 50]^.Data^, SizeOf(U.LastCall));
  Move (U.MsgPosts,     VarData[IdxVarUser + 51]^.Data^, SizeOf(U.MsgPosts));
  Move (U.Emails,       VarData[IdxVarUser + 52]^.Data^, SizeOf(U.Emails));
  Move (U.Uploads,      VarData[IdxVarUser + 53]^.Data^, SizeOf(U.Uploads));
  Move (U.UploadKB,     VarData[IdxVarUser + 54]^.Data^, SizeOf(U.UploadKB));
  Move (U.TimeBank,     VarData[IdxVarUser + 55]^.Data^, SizeOf(U.TimeBank));
  Move (U.LastPWChange, VarData[IdxVarUser + 56]^.Data^, SizeOf(U.LastPWChange));
  Move (U.YesVotes,     VarData[IdxVarUser + 57]^.Data^, SizeOf(U.YesVotes));
  Move (U.NoVotes,      VarData[IdxVarUser + 58]^.Data^, SizeOf(U.NoVotes));
  Move (U.DoorsRan,     VarData[IdxVarUser + 59]^.Data^, SizeOf(U.DoorsRan));
  Move (U.Flags,        VarData[IdxVarUser + 60]^.Data^, SizeOf(U.Flags));
  Move (U.Optional,     VarData[IdxVarUser + 61]^.Data^, SizeOf(U.Optional));
End;

Function TInterpEngine.GetUserByID (ID: LongInt) : Boolean;
Var
  F : File;
  U : RecUser;
Begin
  Result := False;

  Assign (F, bbsConfig.PathData + 'users.dat');
  If Not ioReset(F, SizeOf(RecUser), fmReadWrite + fmDenyNone) Then Exit;

  While Not Eof(F) Do Begin
    ioRead (F, U);
    If U.UserID = ID Then Begin
      Result := True;
      GetUserVars(U);
      Break;
    End;
  End;

  Close (F);
End;

Function TInterpEngine.GetUserByName (Str: String) : Boolean;
Var
  U : RecUser;
  P : LongInt;
Begin
  Result := SearchForUser(Str, U, P);

  If Result Then GetUserVars(U);
End;

Function TInterpEngine.GetUserRecord (Num: LongInt) : Boolean;
Var
  F : File;
  U : RecUser;
Begin
  Result := False;

  Assign (F, bbsConfig.PathData + 'users.dat');
  If Not ioReset(F, SizeOf(RecUser), fmReadWrite + fmDenyNone) Then Exit;

  If (IoSeek(F, Pred(Num))) And (IoRead(F, U)) Then Begin
    GetUserVars(U);
    Result := True;
  End;

  Close (F);
End;

Procedure TInterpEngine.PutUserRecord (Num: LongInt);
Var
  F : File;
  U : RecUser;
Begin
  Assign (F, bbsConfig.PathData + 'users.dat');
  If Not ioReset(F, SizeOf(RecUser), fmReadWrite + fmDenyAll) Then Exit;

  PutUserVars(U);

  If Not IoSeek (F, Pred(Num)) Then Begin
    Close(F);
    Exit;
  End;

  IoWrite (F, U);
  Close   (F);
End;

Function TInterpEngine.GetSauce (Var FN, Title, Author, Group, Date: String) : Boolean;
Var
  Sauce : RecSauceInfo;
Begin
  Result := ReadSauceInfo(FN, Sauce);

  If Result Then Begin
    Title  := Sauce.Title;
    Author := Sauce.Author;
    Group  := Sauce.Group;
    Date   := strWide2Str(Sauce.Date, 8);
    Date   := Copy(Date, 5, 2) + '/' + Copy(Date, 7, 2) + '/' + Copy(Date, 1, 4);
  End;
End;

Function TInterpEngine.GetErrorMsg : String;
Begin
  Result := '';

  Case ErrNum of
    xrrUeEndOfFile    : Result := 'Unexpected end of file';
    xrrInvalidFile    : Result := 'Invalid executable: ' + ErrStr;
    xrrVerMismatch    : Result := 'Version mismatch: ' + ErrStr + ' / ' + mplVersion;
    xrrUnknownOp      : Result := 'Unknown Token: ' + ErrStr;
    xrrMultiInit      : Result := 'Unable to initialize variable'; //Variable initialized recursively';
    xrrDivisionByZero : Result := 'Division by zero';
    xrrMathematical   : Result := 'Parsing error';
  End;
End;

Procedure TInterpEngine.Error (Err: Byte; Str: String);
Begin
  If ErrNum > 0 Then Exit;

  ErrNum := Err;
  ErrStr := Str;
End;

Procedure TInterpEngine.MoveToPos (Num: LongInt);
Begin
  DataFile^.Seek (Num + mplVerLength);
//  CurPos := Num + 1;
End;

Function TInterpEngine.CurFilePos : LongInt;
Begin
  Result := DataFile^.FilePos - mplVerLength;
End;

Procedure TInterpEngine.NextChar;
Begin
  Ch := DataFile^.Read;
//  Ch := Char(Byte(DataFile^.Read) XOR (CurPos MOD 255));
//  Inc (CurPos);
End;

Procedure TInterpEngine.NextWord;
Var
//  Temp : Array[1..2] of Byte Absolute W;
  Res  : LongInt;
Begin
  DataFile^.BlockRead (W, 2, Res);
//  DataFile^.BlockRead (Temp, 2, Res);

//  Temp[1] := Temp[1] XOR (CurPos MOD 255);
//  Temp[2] := Temp[2] XOR ((CurPos + 1) MOD 255);

//  Inc (CurPos, 2);
End;

(*
Procedure TInterpEngine.NextChar;
Var
  Res : LongInt;
Begin
  If (Not DataFile^.EOF) And (ErrNum = 0) Then Begin
    DataFile^.BlockRead(Ch, 1, Res);
    Ch := Chr(Byte(Ch) XOR ((CurFilePos - 1) MOD 255));
    Inc (CurPos);
  End Else Begin
    Ch := #0;
    Error (xrrUeEndOfFile, '');
  End;
End;

Procedure TInterpEngine.NextWord;
Var
  Temp : Array[1..2] of Byte Absolute W;
  Res  : LongInt;
Begin
  If (Not DataFile^.EOF) And (ErrNum = 0) Then Begin
    DataFile^.BlockRead (Temp, 2, Res);

//    Temp[1] := Temp[1] XOR ((CurFilePos - 2) MOD 255);
//    Temp[2] := Temp[2] XOR ((CurFilePos - 1) MOD 255);

//    Inc (CurPos, 2);
  End Else Begin
    W := 0;
    Error (xrrUeEndOfFile, '');
  End;
End;
*)

Procedure TInterpEngine.PrevChar;
Begin
  // remove this prevchar procedure????  not really needed...

  //  If (CurPos = 0) or (ErrNum <> 0) Then Exit;

  MoveToPos (CurFilePos - 1);
End;

Function TInterpEngine.FindVariable (ID: Word) : Word;
Var
  Count : LongInt;
Begin
  Result := 0;
  Count  := CurVarNum;

  If CurVarNum = 0 Then Exit;

  Repeat
    If VarData[Count]^.VarID = ID Then Begin
      Result := Count;
      Exit;
    End;

    Dec (Count);
  Until (Count = 0);

//  tbbscore(owner).systemlog('variable not found');
End;

(*
Function TInterpEngine.FindVariable (ID: Word) : Word;
Var
  Count : LongInt;
Begin
//  writeln('findvariable: ', curvarnum);

  Result := 0;
  Count  := 0;

  If CurVarNum = 0 Then Exit;

  Repeat
    Inc (Count);

    If VarData[Count]^.VarID = ID Then Begin
      Result := Count;
      Exit;
    End;
  Until (Count = CurVarNum);
End;
*)

Function TInterpEngine.xDataPtr (VN: Word; Var A: TArrayInfo) : Pointer;
Begin
  With VarData[VN]^ Do
    Case ArrPos of
      0 : Result := Data;
      1 : Result := @Data^[VarSize * (A[1] - 1) + 1];
      2 : Result := @Data^[VarSize * ((A[1] - 1) * ArrDim[2] + A[2])];
      3 : Result := @Data^[VarSize * ((A[1] - 1) * (ArrDim[2] * ArrDim[3]) + (A[2] - 1) * ArrDim[3] + A[3])];
    End;
End;

Procedure TInterpEngine.xCheckArray (VN: Word; Var A: TArrayInfo);
Var
  Count : Word;
Begin
//  tbbscore(owner).systemlog('var num: ' + stri2s(vn));
//  if vardata[vn] = NIL then tbbscore(owner).systemlog('NIL!');
  For Count := 1 to mplMaxArrayDem Do A[Count] := 1;
//  if vn = 0 then exit;
  If VarData[VN]^.ArrPos = 0 Then Exit;
  For Count := 1 to VarData[VN]^.ArrPos do A[Count] := Round(EvaluateNumber);
End;

Function TInterpEngine.xVarNumReal(VN: Word; Var A: TArrayInfo) : Real;
Begin
  Case VarData[VN]^.vType of
    iByte    : Result := Byte(xDataPtr(VN, A)^);
    iShort   : Result := ShortInt(xDataPtr(VN, A)^);
    iWord    : Result := Word(xDataPtr(VN, A)^);
    iInteger : Result := Integer(xDataPtr(VN, A)^);
    iLongInt : Result := LongInt(xDataPtr(VN, A)^);
    iReal    : Result := Real(xDataPtr(VN, A)^);
  End;
End;

Function TInterpEngine.xNumReal (Var Num; T: TIdentTypes) : Real;
Begin
  Case T of
    iByte    : Result := Byte(Num);
    iShort   : Result := ShortInt(Num);
    iWord    : Result := Word(Num);
    iInteger : Result := Integer(Num);
    iLongInt : Result := LongInt(Num);
    iReal    : Result := Real(Num);
  End;
End;

Function TInterpEngine.EvaluateNumber : Real;
Var
  CheckChar : Char;
  VarNum    : Word;
  PowerRes  : Real;

  Procedure ParseNext;
  Begin
    NextChar;
    If Ch = Char(opCloseNum) Then CheckChar := ^M Else CheckChar := Ch;
  End;

  Function Add_Subtract : Real;
  Var
    E   : Real;
    Opr : Char;

    function mult_DIV : Real;
    var
      S   : Real;
      Opr : Char;

      function Power : Real;
      var
        T : Real;

        function SignedOp : Real;

          function UnsignedOp : Real;
          var
            Start : longint;
            F     : Real;
            ad    : tArrayInfo;
            ns    : String;

            function Fact (I : Integer) : Real;
            begin
              If I > 0 then Result := I * Fact(I-1) Else Result := 1;
            end;

          begin //unsigned op
            Case TTokenOpsRec(Byte(CheckChar)) of
              opLeftParan : Begin
                              ParseNext;
                              F := Add_Subtract;
                              ParseNext;
                            End;
              opVariable  : Begin
                              NextWord;
// combine these and remove VN variable
                              VarNum := FindVariable(w);
                              xCheckArray(VarNum, ad);
                              F := xVarNumReal(VarNum,ad);
                              ParseNext;
                            End;
              opProcExec  : Begin
//                              F := 0;
                              F := xNumReal(F, ExecuteProcedure(@F));
                              ParseNext;
                            End;
            Else
              ns := '';
              repeat
                ns := ns + CheckChar;
                ParseNext;
              until not (CheckChar in ['0'..'9', '.', 'E']);

              Val(ns,F,start);
            End;

            Result := F;
          End; //unsigned op

        begin //signed op
          if CheckChar = '-' then begin
            ParseNext;
            Result := -UnsignedOp;
          end else
            Result := UnsignedOp;
        end;  //signed op

      begin //power
        T := SignedOp;
        while CheckChar = '^' do begin
          ParseNext;
          if t <> 0 then t := Exp(Ln(abs(t))*SignedOp) else t := 0;
        end;
        Result:=t;
      end; //power

    Begin // mult_div
      S := Power;
      While CheckChar in ['*','/'] Do Begin
        Opr := CheckChar;
        ParseNext;
        Case Opr of
          '*' : S := S * Power;
          '/' : Begin
                  PowerRes := Power;
                  If PowerRes = 0 Then
                    Error (xrrDivisionByZero, '')
                  Else
                    S := S / PowerRes;
                End;
        End;
      End;
      Result := S;
    End; //mult_div

  begin //add_subt
    E := mult_DIV;

    while CheckChar in ['+','-'] do begin
      Opr := CheckChar;
      ParseNext;
      case Opr of
        '+' : e := e + mult_DIV;
        '-' : e := e - mult_DIV;
      end;
    end;

    result := E;
  end; //add_subt

begin // xEvalNumber
  NextChar; { open num }  // < remove this crap...???
  ParseNext;
  Result := Add_Subtract;
end;

Function TInterpEngine.EvaluateString : String;
Var
  VarNum    : Word;
  ArrayData : TArrayInfo;
  Res       : LongInt;
Begin
  Result := '';

  NextChar;

  Case TTokenOpsRec(Byte(Ch)) of
    opVariable   : Begin
                     NextWord;
                     VarNum := FindVariable(W);
                     xCheckArray (VarNum, ArrayData);
                     Result := String(xDataPtr(VarNum, ArrayData)^);
                   End;
    opOpenString : Begin
                     NextChar;
                     Result[0] := Ch;
                     DataFile^.BlockRead (Result[1], Byte(Ch), Res);

//                     For VarNum := 1 to Res Do Begin
//                       Result[VarNum] := Char(Byte(Result[VarNum]) XOR (CurPos MOD 255));
//                       Inc (CurPos);
//                     End;
                   End;
    opProcExec   : ExecuteProcedure(@Result);
  End;

  NextChar;

  If Ch = Char(opStrArray) Then Begin
    Result := Result[Round(EvaluateNumber)];
    NextChar;
  End;

  If Ch = Char(opStrAdd) Then
    Result := Result + EvaluateString
  Else
    PrevChar;
End;

Function TInterpEngine.EvaluateBoolean : Boolean;
Type
  tOp = (
    tOpNone,
    tOpEqual,
    tOpNotEqual,
    tOpGreater,
    tOpLess,
    tOpEqGreat,
    tOpEqLess
  );

Var
  VarNum    : Word;
  VarType1  : TIdentTypes;
  VarType2  : TIdentTypes;
  OpType    : tOp;
  GotA      : Boolean;
  GotB      : Boolean;
  BooleanA  : Boolean;
  BooleanB  : Boolean;
  IsNot     : Boolean;
  RealA     : Real;
  RealB     : Real;
  StringA   : String;
  StringB   : String;
  ArrayData : TArrayInfo;
begin
  VarType1 := iNone;
  VarType2 := iNone;
  GotA     := False;
  GotB     := False;
  OpType   := tOpNone;
  IsNot    := False;

  Repeat
    NextChar;

// put these in numerical order...
    Case TTokenOpsRec(Byte(Ch)) of
      opLeftParan  : Begin
                       BooleanA := EvaluateBoolean;
                       VarType1 := iBool;
                       GotA     := True;
                       NextChar;
                     End;
      opVariable   : Begin
                       NextWord;
                       VarNum := FindVariable(W);
                       xCheckArray(VarNum, ArrayData);
                       VarType1 := VarData[VarNum]^.vType;

                       If VarType1 = iBool Then
                         BooleanA := ByteBool(xDataPtr(VarNum, ArrayData)^)
                       Else
                       If VarType1 = iString Then Begin
                         NextChar;
                         If Ch = Char(opStrArray) Then
                           StringA := String(xDataPtr(VarNum, ArrayData)^)[Round(EvaluateNumber)]
                         Else Begin
                           PrevChar;
                           StringA := String(xDataPtr(VarNum, ArrayData)^);
                         End;
                       End Else
                       If VarType1 in vNums Then
                         RealA := xVarNumReal(VarNum, ArrayData);  // evalnumber here

                       GotA := True;
                     End;
      opProcExec   : Begin
                       VarType1 := ExecuteProcedure(@StringA);
                       If VarType1 = iBool Then BooleanA := Boolean(Byte(StringA[0])) else
                       If VarType1 in vNums Then RealA := xNumReal(StringA, VarType1);
                       GotA := True;
                     End;
      opTrue       : Begin // we can combine true/false here...
                       BooleanA := True;
                       VarType1 := iBool;
                       GotA     := True;
                     End;
      opFalse      : Begin
                       BooleanA := False;
                       VarType1 := iBool;
                       GotA     := True;
                     End;
      opOpenString : Begin
                       PrevChar;
                       StringA  := EvaluateString;
                       VarType1 := iString;
                       GotA     := True;
                     End;
      opOpenNum    : Begin
                       PrevChar;
                       RealA    := EvaluateNumber;
                       VarType1 := iReal;
                       GotA     := True;
                     End;
      opNot        : IsNot := Not IsNot;
    End;
  Until (ErrNum <> 0) or GotA;

  If ErrNum <> 0 Then Exit;

  NextChar;

  // we shouldnt even need this... just use the actual tokens...???
  Case TTokenOpsRec(Byte(Ch)) of
    opEqual    : OpType := tOpEqual;
    opNotEqual : OpType := tOpNotEqual;
    opGreater  : OpType := tOpGreater;
    opLess     : OpType := tOpLess;
    opEqGreat  : OpType := tOpEqGreat;
    opEqLess   : OpType := tOpEqLess;
  Else
    Result := BooleanA;
    PrevChar;
  End;

  If OpType <> tOpNone Then Begin
    Repeat
      NextChar;

      Case TTokenOpsRec(Byte(Ch)) of
        opLeftParan  : Begin
                         BooleanB := EvaluateBoolean;
                         VarType2 := iBool;
                         GotB     := True;
                         NextChar;
                       End;
        opVariable   : Begin
                         NextWord;
                         VarNum := FindVariable(w);
                         xCheckArray (VarNum, ArrayData);
                         VarType2 := VarData[VarNum]^.vType;

                         If VarType2 = iBool Then
                           BooleanB := ByteBool(xDataPtr(VarNum,ArrayData)^)
                         Else
                         If VarType2 = iString Then Begin
                           NextChar;
                           If Ch = Char(opStrArray) Then
                             StringB := String(xDataPtr(VarNum, ArrayData)^)[Round(EvaluateNumber)]
                           Else Begin
                             PrevChar;
                             StringB := String(xDataPtr(VarNum, ArrayData)^)
                           End;
                         End Else
                         If VarType2 in vNums Then
                           RealB := xVarNumReal(VarNum, ArrayData);

                         GotB := True;
                       End;
        opProcExec   : Begin
                         VarType2 := ExecuteProcedure(@StringB);
                         If VarType2 = iBool Then BooleanB := Boolean(Byte(StringB[0])) Else
                         If VarType2 in vNums Then RealB := xNumReal(StringB, VarType2);
                         GotB := True;
                       End;
        opTrue       : Begin
                         BooleanB := True;
                         VarType2 := iBool;
                         GotB     := True;
                       End;
        opFalse      : Begin
                         BooleanB := False;
                         VarType2 := iBool;
                         GotB     := True;
                       End;
        opOpenString : Begin
                         PrevChar;
                         StringB  := EvaluateString;
                         VarType2 := iString;
                         GotB     := True;
                       End;
        opOpenNum    : Begin
                         PrevChar;
                         RealB    := EvaluateNumber;
                         VarType2 := iReal;
                         GotB     := True;
                       End;
      End;
    Until (ErrNum <> 0) or GotB;

    If ErrNum <> 0 Then Exit;

    Result := False;

    Case OpType of
      tOpEqual    : If VarType1 = iString Then Result := StringA = StringB Else
                    If VarType1 = iBool Then Result := BooleanA = BooleanB Else
                    Result := RealA = RealB;
      tOpNotEqual : If VarType1 = iString Then Result := StringA <> StringB Else
                    If VarType1 = iBool Then Result := BooleanA <> BooleanB Else
                    Result := RealA <> RealB;
      tOpGreater  : If VarType1 = iString Then Result := StringA > StringB Else
                    If VarType1 = iBool Then Result := BooleanA > BooleanB Else
                    Result := RealA > RealB;
      tOpLess     : If VarType1 = iString Then Result := StringA < StringB Else
                    If VarType1 = iBool Then Result := BooleanA < BooleanB Else
                    Result := RealA < RealB;
      tOpEqGreat  : If VarType1 = iString Then Result := StringA >= StringB Else
                    If VarType1 = iBool Then Result := BooleanA >= BooleanB Else
                    Result := RealA >= RealB;
      tOpEqLess   : If VarType1 = iString Then Result := StringA  <= StringB Else
                    If VarType1 = iBool Then Result := BooleanA <= BooleanB Else
                    Result := RealA <= RealB;
    End;
  End;

  If IsNot Then Result := Not Result;

  NextChar;

  Case TTokenOpsRec(Byte(Ch)) of
    opAnd : Result := EvaluateBoolean And Result;
    opOr  : Result := EvaluateBoolean Or  Result;
  Else
    PrevChar;
  End;
End;

Procedure TInterpEngine.SetString (VarNum: Word; Var A: TArrayInfo; Str: String);
Begin
  If Ord(Str[0]) >= VarData[VarNum]^.VarSize Then
    Str[0] := Chr(VarData[VarNum]^.VarSize - 1);

  Move (Str, xDataPtr(VarNum, A)^, VarData[VarNum]^.VarSize);
End;

Procedure TInterpEngine.SetVariable (VarNum: Word);
Var
  ArrayData : TArrayInfo;
  Target    : Byte;
  TempStr   : String;
Begin
  xCheckArray (VarNum, ArrayData);

  Case VarData[VarNum]^.vType of
    iString: Begin
               NextChar;

               If Ch = Char(opStrArray) Then Begin
                 TempStr         := String(xDataPtr(VarNum, ArrayData)^);
                 Target          := Byte(Round(EvaluateNumber));
                 TempStr[Target] := EvaluateString[1];

                 SetString (VarNum, ArrayData, TempStr);
               End Else Begin
                 PrevChar;
                 SetString (VarNum, ArrayData, EvaluateString);
               End;
             End;
    iByte    : Byte(xDataPtr(VarNum, ArrayData)^)     := Round(EvaluateNumber);
(*
    iByte    : begin
                 target := byte(round(evaluatenumber));
                 Byte(xDataPtr(VarNum, ArrayData)^) := target;
               end;
*)
    iShort   : ShortInt(xDataPtr(VarNum, ArrayData)^) := Round(EvaluateNumber);
    iWord    : Word(xDataPtr(VarNum, ArrayData)^)     := Round(EvaluateNumber);
    iInteger : Integer(xDataPtr(VarNum, ArrayData)^)  := Round(EvaluateNumber);
    iLongInt : LongInt(xDataPtr(VarNum, ArrayData)^)  := Round(EvaluateNumber);
    iReal    : Real(xDataPtr(VarNum, ArrayData)^)     := EvaluateNumber;
    iBool    : ByteBool(xDataPtr(VarNum, ArrayData)^) := EvaluateBoolean;
    { vFile   : will never occur ? }
  End;
End;

Procedure TInterpEngine.SetNumber (VN: Word; R: Real; Var A: TArrayInfo);
Begin
  Case VarData[VN]^.vType of
    iByte    : Byte(xDataPtr(VN, A)^)     := Round(R);
    iShort   : ShortInt(xDataPtr(VN, A)^) := Round(R);
    iWord    : Word(xDataPtr(VN, A)^)     := Round(R);
    iInteger : Integer(xDataPtr(VN, A)^)  := Round(R);
    iLongInt : LongInt(xDataPtr(VN, A)^)  := Round(R);
    iReal    : Real(xDataPtr(VN, A)^)     := R;
  end;
end;

Function TInterpEngine.xDataSize (VarNum: Word) : Word;
Var
  Count : Word;
Begin
  With VarData[VarNum]^ Do Begin
    Result := VarSize;
    For Count := 1 To ArrPos Do
      Result := Result * ArrDim[Count];
  End;
End;

Procedure TInterpEngine.DefineVariable;
Var
  VarType   : TIdentTypes;
  NumVars   : Word;
  SavedVar  : Word;
  StrSize   : Word;
  Count     : Word;
  ArrayPos  : Word;
  ArrayData : TArrayInfo;
begin
  NextChar;

  VarType  := cVarType(Ch);

  NextChar;

  StrSize  := 256;
  ArrayPos := 0;

  For Count := 1 To mplMaxArrayDem Do ArrayData[Count] := 1;

  If Ch = Char(opStrSize) Then Begin
    StrSize := Round(EvaluateNumber) + 1;
    NextChar;
  End;

  If Ch = Char(opArrDef) Then Begin
    NextWord;
    ArrayPos := W;
    For Count := 1 to ArrayPos Do ArrayData[Count] := Round(EvaluateNumber);
  End;

  NextWord;

  NumVars  := W;
  SavedVar := CurVarNum + 1;

  For Count := 1 to NumVars Do
    If ErrNum = 0 Then Begin
//      If CurVarNum >= mplMaxVars Then
//        Error(xrrTooManyVars, '')
//      Else Begin

        NextWord;

        If FindVariable(W) > 0 Then Begin
          Error (xrrMultiInit, '');
          Exit;
        End;

        Inc (CurVarNum);
        New (VarData[CurVarNum]);

        With VarData[CurVarNum]^ Do Begin
          VarID     := W;
          vType     := VarType;
          NumParams := 0;
          pPos      := 0;

          If VarType = iString Then
            VarSize := StrSize
          Else
            VarSize := xVarSize(VarType);

          Kill     := True;
          ArrPos   := ArrayPos;
          ArrDim   := ArrayData;
          DataSize := xDataSize(CurVarNum);

          GetMem   (Data, DataSize);
          FillChar (Data^, DataSize, 0);
        End;
  //    End;
    End;

//  if ErrNum <> 0 then Exit;

  NextChar;

  If Ch = Char(OpEqual) Then Begin
    SetVariable(SavedVar);
    For Count := SavedVar + 1 To CurVarNum Do
      Move (VarData[SavedVar]^.Data^, VarData[Count]^.Data^, VarData[SavedVar]^.DataSize);
  End Else
    PrevChar;
End;

Procedure TInterpEngine.FileReadLine (Var F: File; Var Str: String);
Var
  C : Char;
Begin
  Str := '';

  While Not Eof(F) Do Begin
    BlockRead (F, C, 1);

    IoError := IoResult;

    If IoError <> 0 Then Exit;

    If C = #10 Then Exit;
    If C = #13 Then Begin
      BlockRead (F, C, 1);
      IoError := IoResult;
      Exit;
    End;

    Str := Str + C;
  End;
End;

Procedure TInterpEngine.FileWriteLine (Var F: File; Str: String);
Begin
  {$IFDEF WIN32}
    Str := Str + #13#10;
  {$ENDIF}
  {$IFDEF UNIX}
    Str := Str + #10;
  {$ENDIF}

  BlockWrite (F, Str[1], Ord(Str[0]));

  IoError := IoResult;
End;

Function TInterpEngine.ExecuteProcedure (DP: Pointer) : TIdentTypes;
// okay... change this to:
// array[1..mplmaxprocparams] of record
//  vsize : word;
//  vdata : pointer;
// end;
// VAR passing: stores dataptr to passed variable -- DONE
// regular    : creates var and stores its pointer into vdata -- TODO
// doing this will reduce memory usage and make things even harder to
// understand =]
Type
  TParamInfo = Array[1..mplMaxProcParams] of Record
//    vType : TIdentTypes;
    vSize : Word;
    vID   : Word;
    vData : Pointer;
    Case TIdentTypes of
      iString  : (S : String);
      iByte    : (B : Byte);
      iShort   : (H : ShortInt);
      iWord    : (W : Word);
      iInteger : (I : Integer);
      iLongInt : (L : LongInt);
      iReal    : (R : Real);
      iBool    : (O : Boolean);
  End;

Var
  VarNum    : Word;
  Count     : Word;
  ProcID    : Word;
  SavedVar  : Word;
  Param     : TParamInfo;
  TempStr   : String;
  TempBool  : Boolean;
  TempByte  : Byte;
  TempLong  : LongInt;
  Sub       : LongInt;
  ArrayData : TArrayInfo;

  Procedure Store (Var Dat; Siz: Word);
  Begin
    If DP <> NIL Then Move (Dat, DP^, Siz);
  End;

Begin
  NextWord;

  ProcID := W;
  VarNum := FindVariable(ProcID);

  For Count := 1 to VarData[VarNum]^.NumParams Do Begin
    With VarData[VarNum]^ Do Begin
      If Params[Count] = UpCase(Params[Count]) Then Begin
//        NextChar; //i dont think we need this
        NextWord;

        Param[Count].vID := FindVariable(W);
        xCheckArray(Param[Count].vID, ArrayData);

        Param[Count].vData := xDataPtr(Param[Count].vID, ArrayData);

        If VarData[Param[Count].vID]^.vType = iString Then
          Param[Count].vSize := VarData[Param[Count].vID]^.VarSize;
      End Else Begin
        Case Params[Count] of
          's' : Begin
                  Param[Count].vSize := 256;
                  Param[Count].S     := EvaluateString;
                End;
          'b' : Param[Count].B := Round(EvaluateNumber);
          'h' : Param[Count].H := Round(EvaluateNumber);
          'w' : Param[Count].W := Round(EvaluateNumber);
          'i' : Param[Count].I := Round(EvaluateNumber);
          'l' : Param[Count].L := Round(EvaluateNumber);
          'r' : Param[Count].R := EvaluateNumber;
          'o' : Param[Count].O := EvaluateBoolean;
        End;
      End;

      NextChar;
    End;
  End;

  ExecuteProcedure := VarData[VarNum]^.vType;

  If VarData[VarNum]^.pPos > 0 Then Begin
    Sub      := CurFilePos;
    SavedVar := CurVarNum;

    MoveToPos(VarData[VarNum]^.pPos);

    For Count := 1 to VarData[VarNum]^.NumParams Do Begin
      Inc (CurVarNum);
      New (VarData[CurVarNum]);

      With VarData[CurVarNum]^ Do Begin
        VarID     := VarData[VarNum]^.pID[Count];
        vType     := cVarType(VarData[VarNum]^.Params[Count]);
        NumParams := 0;
        pPos      := 0;
        ArrPos    := 0;

        If vType = iString Then
          VarSize := Param[Count].vSize
        Else
          VarSize := xVarSize(vType);

        DataSize := xDataSize(CurVarNum);

        If VarData[VarNum]^.Params[Count] = UpCase(VarData[VarNum]^.Params[Count]) Then Begin
//          Data := VarData[Param[Count].vID]^.Data;
          Data := Param[Count].vData;
          Kill := False;
        End Else Begin
          GetMem (Data, DataSize);

          Case VarData[VarNum]^.Params[Count] of
            's' : Begin
                    If Ord(Param[Count].S[0]) >= VarSize Then
                      Param[Count].S[0] := Chr(VarSize - 1);

                    Move (Param[Count].S, Data^, VarSize);
                  End;
            'b' : Byte(Pointer(Data)^)     := Param[Count].B;
            'h' : ShortInt(Pointer(Data)^) := Param[Count].H;
            'w' : Word(Pointer(Data)^)     := Param[Count].W;
            'i' : Integer(Pointer(Data)^)  := Param[Count].I;
            'l' : LongInt(Pointer(Data)^)  := Param[Count].L;
            'r' : Real(Pointer(Data)^)     := Param[Count].R;
            'o' : Boolean(Pointer(Data)^)  := Param[Count].O;
          end;

          Kill := True;
        End;
      End;
    End;

    If VarData[VarNum]^.vType <> iNone Then Begin
      VarData[VarNum]^.DataSize := xDataSize(VarNum);
      VarData[VarNum]^.Kill     := False;

      GetMem   (VarData[VarNum]^.Data,  VarData[VarNum]^.DataSize);
      FillChar (VarData[VarNum]^.Data^, VarData[VarNum]^.DataSize, 0);
    End;

    ExecuteBlock (SavedVar, CurRecNum);

    If ExitProc Then Begin
      ExitProc := False;
      Done     := False;
    End;

    If VarData[VarNum]^.vType <> iNone Then Begin
      If DP <> NIL Then
        Move (VarData[VarNum]^.Data^, DP^, VarData[VarNum]^.DataSize);

      FreeMem(VarData[VarNum]^.Data, VarData[VarNum]^.DataSize);
      VarData[VarNum]^.DataSize := 0;
    End;

    MoveToPos(Sub);

    Exit;
  End;

  Case ProcID of
    0   : TBBSCore(Owner).Term.OutFull(Param[1].S);
    1   : TBBSCore(Owner).Term.OutFullLn(Param[1].S);
    2   : TBBSCore(Owner).Term.OutPipe(TBBSCore(Owner).Term.AnsiClear);
    3   : TBBSCore(Owner).Term.OutPipe(TBBSCore(Owner).Term.AnsiClrEOL);
    4   : TBBSCore(Owner).Term.OutPipe(TBBSCore(Owner).Term.AnsiGotoXY(Param[1].B, Param[2].B));
    5   : Begin
            TempByte := TBBSCore(Owner).Term.Console.CursorX;
            Store(TempByte, 1);
          End;
    6   : Begin
            TempByte := TBBSCore(Owner).Term.Console.CursorY;
            Store(TempByte, 1);
          End;
    7   : Begin
            TempBool := TBBSCore(Owner).Term.OutFile(Param[1].S);
            Store(TempBool, 1);
          End;
    8   : TBBSCore(Owner).Term.ShowTemplate(Param[1].S);
    9   : TBBSCore(Owner).Term.OutBS(Param[1].B, Param[2].O);
    10  : TBBSCore(Owner).Term.OutPipe(TBBSCore(Owner).Term.Attr2Ansi(Param[1].B, Param[2].O));
    11  : TBBSCore(Owner).Term.OutPipe(Param[1].S);
    12  : TBBSCore(Owner).Term.OutPipeLn(Param[1].S);
    13  : TBBSCore(Owner).Term.OutRaw(Param[1].S);
    14  : TBBSCore(Owner).Term.OutRawLn(Param[1].S);
    15  : TBBSCore(Owner).Term.BufAddStr(Param[1].S);
    16  : TBBSCore(Owner).Term.BufFlush;
    17  : Begin
            TempStr := TBBSCore(Owner).Term.NewGetKey(0);
            Store(TempStr, 256);
          End;
    18  : Begin
            TempStr := TBBSCore(Owner).Term.NewGetKey(Param[1].L);
            Store (TempStr, 256);
          End;
    19  : Begin
            TempBool := TBBSCore(Owner).Term.GetYN(Param[1].S, Param[2].O);
            Store (TempBool, 1);
          End;
    20  : Begin
            TempStr := TBBSCore(Owner).Term.GetStr(Param[1].B, Param[2].B, Param[3].H, Param[4].S);
            Store (TempStr, 256);
          End;
    21  : TBBSCore(Owner).Term.PausePrompt;
    22  : Begin
            TempStr := TBBSCore(Owner).Term.MorePrompt;
            Store (TempStr, 256);
          End;
    23  : Begin
            TempStr := TBBSCore(Owner).Term.OneKey(Param[1].S, Param[2].O);
            Store (TempStr, 256);
          End;
    24  : TBBSCore(Owner).Term.KeyBufStr := TBBSCore(Owner).Term.KeyBufStr + Param[1].S;
    25  : WaitMS(Param[1].L);
    26  : Begin
            TempLong := Random(Param[1].L);
            Store (TempLong, 4);
          End;
    27  : Begin
            TempStr := TBBSCore(Owner).Term.Mci2Str(Param[1].S);
            Store (TempStr, 256);
          End;
    28  : TBBSCore(Owner).SystemLog(Param[1].S);
    29  : Begin
            TempBool := TBBSCore(Owner).User.Access(Param[1].S);
            Store (TempBool, 1);
          End;
    30  : Begin
            TempStr := Chr(Param[1].B);
            Store (TempStr, 256);
          End;
    31  : Begin
            TempByte := Ord(Param[1].S[1]);
            Store (TempByte, 1);
          End;
    32  : Begin
            TempStr := Copy(Param[1].S, Param[2].L, Param[3].L);
            Store (TempStr, 256);
          End;
    33  : Delete(String(Pointer(Param[1].vData)^), Param[2].L, Param[3].L);
    34  : TBBSCore(Owner).ShutDown := True;
    35  : Insert(Param[1].S, String(Pointer(Param[2].vData)^), Param[3].L);
    36  : Begin
            TempLong := Length(Param[1].S);
            Store (TempLong, 4);
          End;
    37  : Begin
            TempBool := Odd(Param[1].L);
            Store (TempBool, 1);
          End;
    38  : Begin
            TempLong := Pos(Param[1].S, Param[2].S);
            Store (TempLong, 4);
          End;
    39  : Begin
            TempBool := (Ord(TBBSCore(Owner).Term.KeyBufStr[0]) > 0) or TBBSCore(Owner).Client.DataWaiting or (TBBSCore(Owner).Client.WaitForData(0) > 0);
            Store (TempBool, 1);
          End;
    40  : TBBSCore(Owner).User.Security_Upgrade(TBBSCore(Owner).User.ThisUser, Param[1].B);
    41  : Begin
            TempByte := TBBSCore(Owner).Node;
            Store (TempByte, 1);
          End;
    42  : Begin
            TempStr := strPadR(Param[1].S, Param[2].B, Param[3].S[1]);
            Store (TempStr, 256);
          End;
    43  : Begin
            TempStr := strPadL(Param[1].S, Param[2].B, Param[3].S[1]);
            Store (TempStr, 256);
          End;
    44  : Begin
            TempStr := strPadC(Param[1].S, Param[2].B, Param[3].S[1]);
            Store (TempStr, 256);
          End;
    45  : Begin
            TempStr := strUpper(Param[1].S);
            Store (TempStr, 256);
          End;
    46  : Begin
            TempStr := strLower(Param[1].S);
            Store (TempStr, 256);
          End;
    47  : Begin
            TempStr := strRep(Param[1].S[1], Param[2].B);
            Store (TempStr, 256);
          End;
    48  : Begin
            TempStr := strComma(Param[1].L);
            Store (TempStr, 256);
          End;
    49  : Begin
            TempStr := strI2S(Param[1].L);
            Store (TempStr, 256);
          End;
    50  : Begin
            TempLong := strS2I(Param[1].S);
            Store (TempLong, 4);
          End;
    51  : Begin
            TempStr := strI2H(Param[1].L);
            Store (TempStr, 256);
          End;
    52  : Begin
            TempStr := strWordGet(Param[1].B, Param[2].S, Param[3].S[1]);
            Store (TempStr, 256);
          End;
    53  : Begin
            TempByte := strWordPos(Param[1].B, Param[2].S, Param[3].S[1]);
            Store (TempByte, 1);
          End;
    54  : Begin
            TempByte := strWordNum(Param[1].S, Param[2].S[1]);
            Store (TempByte, 1);
          End;
    55  : Begin
            TempStr := strStripL(Param[1].S, Param[2].S[1]);
            Store (TempStr, 256);
          End;
    56  : Begin
            TempStr := strStripR(Param[1].S, Param[2].S[1]);
            Store (TempStr, 256);
          End;
    57  : Begin
            TempStr := strStripB(Param[1].S, Param[2].S[1]);
            Store (TempStr, 256);
          End;
    58  : Begin
            TempStr := strStripLow(Param[1].S);
            Store (TempStr, 256);
          End;
    59  : Begin
            TempStr := strStripMCI(Param[1].S);
            Store (TempStr, 256);
          End;
    60  : Begin
            TempByte := strMCILen(Param[1].S);
            Store (TempByte, 1);
          End;
    61  : Begin
            TempStr := strInitials(Param[1].S);
            Store (TempStr, 256);
          End;
    62  : Begin
            TempByte := strWrap(String(Pointer(Param[1].vData)^), String(Pointer(Param[2].vData)^), Param[3].B);
            Store (TempByte, 1);
          End;
    63  : Begin
            TempStr := strReplace(Param[1].S, Param[2].S, Param[3].S);
            Store (TempStr, 256);
          End;
    64  : Begin
            TempStr := ReadEnvironment(Param[1].S);
            Store (TempStr, 256);
          End;
    65  : Begin
            TempBool := FileExist(Param[1].S);
            Store (TempBool, 1);
          End;
    66  : FileErase(Param[1].S);
    67  : Begin
            TempBool := FileDirExists(Param[1].S);
            Store (TempBool, 1);
          End;
    68  : Begin
            TempLong := TimerMinutes;
            Store (TempLong, 4);
          End;
    69  : Begin
            TempLong := TimerSeconds;
            Store (TempLong, 4);
          End;
    70  : Begin
            TempLong := CurDateDos;
            Store (TempLong, 4);
          End;
    71  : Begin
            TempLong := CurDateJulian;
            Store (TempLong, 4);
          End;
    72  : Begin
            TempStr := DateDos2Str(Param[1].L, Param[2].B);
            Store (TempStr, 256);
          End;
    73  : Begin
            TempStr := DateJulian2Str(Param[1].L, Param[2].B);
            Store (TempStr, 256);
          End;
    74  : Begin
            TempLong := DateStr2Dos(Param[1].S);
            Store (TempLong, 4);
          End;
    75  : Begin
            TempLong := DateStr2Julian(Param[1].S);
            Store (TempLong, 4);
          End;
    76  : DateG2J(Param[1].L, Param[2].L, Param[3].L, LongInt(VarData[Param[4].vID]^.Data));
    77  : DateJ2G(Param[1].L, SmallInt(Pointer(Param[2].vData)^), SmallInt(Pointer(Param[3].vData)^), SmallInt(Pointer(Param[4].vData)^));
    78  : Begin
            TempBool := DateValid(Param[1].S);
            Store (TempBool, 1);
          End;
    79  : Begin
            TempStr := TimeDos2Str(Param[1].L, Param[2].O);
            Store (TempStr, 256);
          End;
    80  : Begin
            TempByte := DayOfWeek;
            Store (TempByte, 1);
          End;
    81  : Begin
            TempLong := DaysAgo(Param[1].L);
            Store (TempLong, 4);
          End;
    82  : Begin
            TempStr := JustFile(Param[1].S);
            Store (TempStr, 256);
          End;
    83  : Begin
            TempStr := JustFileName(Param[1].S);
            Store (TempStr, 256);
          End;
    84  : Begin
            TempStr := JustFileExt(Param[1].S);
            Store (TempStr, 256);
          End;
    85  : Begin
            Assign (File(Pointer(Param[1].vData)^), Param[2].S);
            FileMode := Param[3].L;
          End;
    86  : Begin
            Reset (File(Pointer(Param[1].vData)^), 1);
            IoError := IoResult;
          End;
    87  : Begin
            ReWrite (File(Pointer(Param[1].vData)^), 1);
            IoError := IoResult;
          End;
    88  : Begin
            Close (File(Pointer(Param[1].vData)^));
            IoError := IoResult;
          End;
    89  : Begin
            Seek (File(Pointer(Param[1].vData)^), Param[2].L);
            IoError := IoResult;
          End;
    90  : Begin
            TempBool := Eof(File(Pointer(Param[1].vData)^));
            IoError  := IoResult;
            Store (TempBool, 1);
          End;
    91  : Begin
            TempLong := FileSize(File(Pointer(Param[1].vData)^));
            IoError  := IoResult;
            Store (TempLong, 4);
          End;
    92  : Begin
            TempLong := FilePos(File(Pointer(Param[1].vData)^));
            IoError  := IoResult;
            Store (TempLong, 4);
          End;
    93  : Begin
            BlockRead (File(Pointer(Param[1].vData)^), VarData[Param[2].vID]^.Data^, Param[3].W);
            IoError := IoResult;
          End;
    94  : Begin
            BlockWrite (File(Pointer(Param[1].vData)^), VarData[Param[2].vID]^.Data^, Param[3].W);
            IoError := IoResult;
          End;
    95  : FileReadLine  (File(Pointer(Param[1].vData)^), String(Pointer(Param[2].vData)^));
    96  : FileWriteLine (File(Pointer(Param[1].vData)^), Param[2].S);
    97  : Begin
            TempStr := PathSep;
            Store (TempStr, 256);
          End;
    98  : ReloadMenu := TBBSCore(Owner).Menu.ExecuteCommand(strUpper(Param[1].S), Param[2].S);
    99  : Begin
            TempBool := BitCheck(Param[1].B, Param[2].vSize, VarData[Param[2].vID]^.Data^);
            Store (TempBool, 1);
          End;
    100 : BitToggle(Param[1].B, Param[2].vSize, VarData[Param[2].vID]^.Data^);
    101 : BitSet(Param[1].B, Param[2].vSize, VarData[Param[2].vID]^.Data^, Param[3].O);
    102 : Begin
            FindFirst(Param[1].S, Param[2].W, DirInfo);

            Move (DirInfo.Name, VarData[IdxVarDir    ]^.Data^, SizeOf(DirInfo.Name));
            Move (DirInfo.Size, VarData[IdxVarDir + 1]^.Data^, SizeOf(DirInfo.Size));
            Move (DirInfo.Time, VarData[IdxVarDir + 2]^.Data^, SizeOf(DirInfo.Time));
            Move (DirInfo.Attr, VarData[IdxVarDir + 3]^.Data^, SizeOf(DirInfo.Attr));
          End;
    103 : Begin
            FindNext(DirInfo);

            Move (DirInfo.Name, VarData[IdxVarDir    ]^.Data^, SizeOf(DirInfo.Name));
            Move (DirInfo.Size, VarData[IdxVarDir + 1]^.Data^, SizeOf(DirInfo.Size));
            Move (DirInfo.Time, VarData[IdxVarDir + 2]^.Data^, SizeOf(DirInfo.Time));
            Move (DirInfo.Attr, VarData[IdxVarDir + 3]^.Data^, SizeOf(DirInfo.Attr));
          End;
    104 : FindClose(DirInfo);
    105 : Begin
            TempLong := Param[1].L MOD Param[2].L;
            Store (TempLong, 4);
          End;
    106 : Begin
            TempStr := TBBSCore(Owner).GetPrompt(Param[1].L);
            Store (TempStr, 256);
          End;
    107 : Begin
            TempStr := TBBSCore(Owner).Term.PromptInfo[UpCase(Param[1].S[1])];
            Store (TempStr, 256);
          End;
    108 : Begin
            Param[2].B := TBBSCore(Owner).Term.ScreenInfo[Param[1].B].X;
            Param[3].B := TBBSCore(Owner).Term.ScreenInfo[Param[1].B].Y;
            Param[4].B := TBBSCore(Owner).Term.ScreenInfo[Param[1].B].A;
          End;
    109 : Begin
            TempStr := '';
            For Count := Param[2].B to Param[3].B Do
              TempStr := TempStr + Char(TBBSCore(Owner).Term.Console.Buffer[Param[1].B, Count].UnicodeChar);
            Store (TempStr, 256);
          End;
    110 : Begin
            TempStr := '';
            For Count := Param[2].B to Param[3].B Do
              TempStr := TempStr + Chr(TBBSCore(Owner).Term.Console.Buffer[Param[1].B, Count].Attributes);
            Store (TempStr, 256);
          End;
    111 : GetUserVars(TBBSCore(Owner).User.ThisUser);
    112 : PutUserVars(TBBSCore(Owner).User.ThisUser);
    113 : Begin
            TempBool := GetUserRecord(Param[1].L);
            Store (TempBool, 1);
          End;
    114 : PutUserRecord(Param[1].L);
    115 : Begin
            TempBool := GetUserByName(Param[1].S);
            Store (TempBool, 1);
          End;
    116 : Begin
            TempBool := GetUserByID(Param[1].L);
            Store (TempBool, 1);
          End;
    117 : Begin
            TempBool := GetSauce(Param[1].S, Param[2].S, Param[3].S, Param[4].S, Param[5].S);
            Store (TempBool, 1);
          End;
    118 : Begin
            TempBool := TBBSCore(Owner).User.IsUser(Param[1].S);
            Store (TempBool, 1);
          End;
    119 : Begin
            TempStr := JustPath(Param[1].S);
            Store (TempStr, 256);
          End;
    120 : Randomize;
    121 : Begin
            TempByte := strWordNum(ParamsStr, ' ');
            Store (TempByte, 1);
          End;
    122 : Begin
            If Param[1].B = 0 Then
              TempStr := MPEName
            Else
              TempStr := strWordGet(Param[1].B, ParamsStr, ' ');
            Store (TempStr, 256);
          End;
    123 : TBBSCore(Owner).User.SetTimeLeft(Param[1].I);
    124 : If Param[1].S[1] in ['A'..'Z'] Then
            TBBSCore(Owner).Term.PromptInfo[Param[1].S[1]] := Param[2].S;
    125 : Begin
            TempByte := TBBSCore(Owner).Term.Console.TextAttr;
            Store (TempByte, 1);
          End;
  End;
End;

Procedure TInterpEngine.SkipBlock;
begin
  NextChar; { open block }
  NextWord; { size of block }
  MoveToPos (CurFilePos + W);
end;

Procedure TInterpEngine.DefineProcedure;
Var
  Count   : Word;
  VarChar : Char;
  Params  : Word;
  NumVars : Word;
Begin
(*
  If CurVarNum >= mplMaxVars Then Begin
    Error (xrrTooManyVars, '');
    Exit;
  End;
*)

  NextWord; { procedure var id }

  If FindVariable(W) > 0 Then Begin  /// ????????????????????
    Error (xrrMultiInit, '');
    Exit;
  End;

  Inc (CurVarNum);
  New (VarData[CurVarNum]);

  With VarData[CurVarNum]^ Do Begin
    VarID     := W;
    vType     := iNone;
    NumParams := 0;
    pPos      := 0;
    VarSize   := 0;
    Datasize  := 0;
    ArrPos    := 0;
    Kill      := False;
    Data      := NIL;
  End;

  NextChar;
  Params := 0;

  While (ErrNum = 0) And (Not (Ch in [Char(opProcType), Char(opBlockOpen)])) Do Begin
    VarChar := Ch;
    NextWord;
    NumVars := W;
    For Count := 1 To NumVars Do Begin
      Inc(Params);
      VarData[CurVarNum]^.Params[Params] := VarChar;
      NextWord;
      VarData[CurVarNum]^.pID[Params] := W;
    End;
    NextChar;
  End;

  If Ch = Char(opProcType) Then Begin
    NextChar;

    VarData[CurVarNum]^.vType   := cVarType(Ch);
    VarData[CurVarNum]^.VarSize := xVarSize(VarData[CurVarNum]^.vType);
  End Else
    PrevChar;

  VarData[CurVarNum]^.NumParams := Params;
  VarData[CurVarNum]^.pPos      := CurFilePos;

  SkipBlock;
End;

Procedure TInterpEngine.StatementForLoop;
Var
  VarNum    : Word;
  VarArray  : TArrayInfo;
  LoopStart : Real;
  LoopEnd   : Real;
  Count     : Real;
  CountTo   : Boolean;
  SavedPos  : LongInt;
Begin
  NextWord;

  VarNum := FindVariable(W);

  xCheckArray (VarNum, VarArray);

  LoopStart := EvaluateNumber;

  NextChar;

  CountTo  := Ch = Char(opTo);
  LoopEnd  := EvaluateNumber;
  Count    := LoopStart;
  SavedPos := CurFilePos;

  If (CountTo And (LoopStart > LoopEnd)) Or ((Not CountTo) And (LoopStart < LoopEnd)) Then
    SkipBlock
  Else
  If CountTo Then
    While (Count <= LoopEnd) And Not TBBSCore(Owner).ShutDown And Not Done Do Begin
      SetNumber (VarNum, Count, VarArray);
      MoveToPos  (SavedPos);
      Count := Count + 1;
      If ExecuteBlock (CurVarNum, CurRecNum) = 1 Then Break;
    End
  Else
  While (Count >= LoopEnd) And Not TBBSCore(Owner).ShutDown And Not Done Do Begin
    SetNumber (VarNum, Count, VarArray);
    MoveToPos  (SavedPos);
    Count := Count - 1;
    If ExecuteBlock (CurVarNum, CurRecNum) = 1 Then Break;
  End;
End;

Procedure TInterpEngine.StatementWhileDo;
Var
  IsTrue   : Boolean;
  StartPos : LongInt;
begin
  StartPos := CurFilePos;
  IsTrue   := True;

  While (ErrNum = 0) And IsTrue And Not TBBSCore(Owner).ShutDown And Not Done Do Begin
    IsTrue := EvaluateBoolean;
    If IsTrue Then Begin
      If ExecuteBlock (CurVarNum, CurRecNum) = 1 Then Begin
        MoveToPos (StartPos);
        EvaluateBoolean;
        SkipBlock;
        Break;
      End Else
        MoveToPos (StartPos);
    End Else
      SkipBlock;
  End;
End;

Procedure TInterpEngine.StatementRepeatUntil;
Var
  StartPos: LongInt;
Begin
  StartPos := CurFilePos;

  Repeat
    MoveToPos (StartPos);
    If ExecuteBlock (CurVarNum, CurRecNum) = 1 Then Begin
      EvaluateBoolean;
      Break;
    End;
  Until (ErrNum <> 0) or (EvaluateBoolean) or (TBBSCore(Owner).ShutDown) or Done;
End;

Function TInterpEngine.StatementCase : Byte;
Var
  StartPos  : LongInt;
  EndPos    : LongInt;
  TempStr   : String;
  TempBol   : Boolean;
  TempNum   : Real;
  Found     : Boolean;
  VarType   : TIdentTypes;
  Numbers   : Array[1..mplMaxCaseNums] of Record
                Num   : Real;
                Range : Boolean;
              End;
  NumberPos : Word;
  Count     : Word;

Begin
  NextWord;   // statement size

  Result    := 0;
  StartPos  := CurFilePos;
  EndPos    := W;
  Found     := False;
  NumberPos := 0;

  NextChar;

  VarType := TIdentTypes(Byte(Ch));

  Case VarType of
    iString : TempStr := EvaluateString;
    iBool   : TempBol := EvaluateBoolean;
  Else
    TempNum := EvaluateNumber;
  End;

  Repeat
    Case VarType of
      iString : Repeat
                  Found := Found or (EvaluateString = TempStr);

                  NextChar;

                  If Ch <> Char(opParamSep) Then Begin
                    PrevChar;
                    Break;
                  End;
                Until ErrNum <> 0;
      iBool   : Found := EvaluateBoolean = TempBol;
    Else
      Repeat
        Inc (NumberPos);
        Numbers[NumberPos].Num := EvaluateNumber;

        NextChar;

        If Ch = Char(opParamSep) Then
          Numbers[NumberPos].Range := False
        Else
        If Ch = Char(opNumRange) Then
          Numbers[NumberPos].Range := True
        Else Begin
          Numbers[NumberPos].Range := False;
          PrevChar;
          Break;
        End;
      Until ErrNum <> 0;

      Count := 1;

      Repeat
        If Numbers[Count].Range Then
          Found := (TempNum >= Numbers[Count].Num) and (TempNum <= Numbers[Count + 1].Num)
        Else
          Found := TempNum = Numbers[Count].Num;

        Inc (Count);
      Until Found or (Count > NumberPos);
    End;

    If Found Then Begin
      Result := ExecuteBlock (CurVarNum, CurRecNum);
      MoveToPos (StartPos + EndPos);
      Exit;
    End Else
      SkipBlock;

    NextChar;

    If Ch = Char(opElse) Then Begin
      Result := ExecuteBlock(CurVarNum, CurRecNum);
      Break;
    End Else
    If Ch = Char(opBlockClose) Then
      Break
    Else
      PrevChar;

  Until (ErrNum > 0) or TBBSCore(Owner).ShutDown or Done;
End;

Function TInterpEngine.StatementIfThenElse : Byte;
Var
  Ok : Boolean;
Begin
  Ok := EvaluateBoolean;

  If Ok Then
    Result := ExecuteBlock(CurVarNum, CurRecNum)
  Else
    SkipBlock;

  NextChar;

  If Ch = Char(opElse) Then Begin
    If Not Ok Then
      Result := ExecuteBlock(CurVarNum, CurRecNum)
    Else
      SkipBlock;
  End Else
    PrevChar;
End;

Procedure TInterpEngine.DefineRecord;
Var
  Count : LongInt;
Begin
  NextWord;

  Inc (CurRecNum);
  New (RecData[CurRecNum]);

  RecData[CurRecNum]^.RecStart  := CurVarNum + 1;
  RecData[CurRecNum]^.NumFields := W;

  For Count := 1 to RecData[CurRecNum]^.NumFields Do Begin
    NextChar;
    DefineVariable;
  End;
End;

Function TInterpEngine.ExecuteBlock (StartVar, StartRec: Word) : Byte;
Var
  Count      : Word;
  BlockStart : LongInt;
  BlockSize  : Word;
Begin
  Result := 0;

  NextChar;
  NextWord;

  BlockStart := CurFilePos;
  BlockSize  := W;

  Repeat
    NextChar;

    Case TTokenOpsRec(Byte(Ch)) of
{0}   opBlockOpen  : Begin
                       PrevChar;
                       Self.ExecuteBlock(CurVarNum, CurRecNum);
                     End;
{1}   opBlockClose : Break;
{2}   opVarDeclare : DefineVariable;
{12}  opSetVar     : Begin
                       NextWord;
                       SetVariable(FindVariable(W));
                     End;
{18}  opProcDef    : DefineProcedure;
{19}  opProcExec   : ExecuteProcedure(NIL);
{21}  opFor        : StatementForLoop;
{34}  opIf         : Begin
                       Result := StatementIfThenElse;
                       If Result > 0 Then Begin
                         MoveToPos(BlockStart + BlockSize);
                         Break;
                       End;
                     End;
{36}  opWhile      : StatementWhileDo;
{39}  opRepeat     : StatementRepeatUntil;
{47}  opGoto       : Begin
                       NextWord;
                       MoveToPos(W);
                     End;
{49}  opHalt       : Done := True;
{50}  opCase       : Begin
                       Result := StatementCase;
                       If Result > 0 Then Begin
                         MoveToPos(BlockStart + BlockSize);
                         Break;
                       End;
                     End;
{52}  opTypeRec    : DefineRecord;
{53}  opBreak      : Begin
                       MoveToPos (BlockStart + BlockSize);
                       Result := 1;
                       Break;
                     End;
{54}  opContinue   : Begin
                       MoveToPos (BlockStart + BlockSize);
                       Result := 2;
                       Break;
                     End;
{55}  opUses       : Begin
                       Repeat
                         NextWord;
                         InitProcedures (Owner, Self, VarData, CurVarNum, CurVarID, W);
                         NextChar;
                         If Ch <> Char(opParamSep) Then Begin
                           PrevChar;
                           Break;
                         End;
                       Until ErrNum <> 0;
                     End;
{56}  opExit       : Begin
                       Done     := True;
                       ExitProc := True;
                     End;
    Else
      Error (xrrUnknownOp, strI2S(Ord(Ch)));
    End;
  Until (ErrNum <> 0) or (TBBSCore(Owner).ShutDown) or Done or DataFile^.EOF;

  For Count := CurVarNum DownTo StartVar + 1 Do Begin
    If (VarData[Count]^.Kill) And (VarData[Count]^.Data <> NIL) Then
      FreeMem(VarData[Count]^.Data, VarData[Count]^.DataSize);

    Dispose (VarData[Count]);
  End;

  For Count := CurRecNum DownTo StartRec + 1 Do Dispose(RecData[Count]);

  CurVarNum := StartVar;
  CurRecNum := StartRec;
End;

Function TInterpEngine.Execute (FN: String) : Byte;
// 0 = not found  1 = ok  2 = goto new menu
Var
  VerStr : String;
  Res    : LongInt;
Begin
//  CurPos     := 0;
  Result     := 0;
  CurVarNum  := 0;
  CurVarID   := 0;
  CurRecNum  := 0;
  ReloadMenu := False;
  Done       := False;
  ExitProc   := False;
  DataFile   := New(PCharFile, Init(mplExecuteBuffer));

  If strWordNum(FN, ' ') > 1 Then Begin
    ParamsStr := Copy(FN, strWordPos(2, FN, ' '), Length(FN));
    FN        := strWordGet(1, FN, ' ');
  End Else
    ParamsStr := '';

  If Pos('.', FN) = 0 Then FN := FN + mplExtExecute;

  If Pos(PathSep, FN) = 0 Then
    If FileExist(bbsConfig.PathScripts + FN) Then
      FN := TBBSCore(Owner).Theme.PathScripts + FN
    Else
      FN := BBSConfig.PathScripts + FN;

  MPEName := FN;

  If Not DataFile^.Open(FN) Then Begin
    Dispose(DataFile, Done);
    Exit;
  End;

  Result := 1;

  If DataFile^.FileSize < mplVerLength Then Begin
    DataFile^.Close;
    Error (xrrInvalidFile, FN);
    Dispose (DataFile, Done);
    Exit;
  End;

  DataFile^.BlockRead (VerStr[1], mplVerLength, Res);
  VerStr[0] := Chr(mplVerLength);

  If VerStr <> mplVersion Then Begin
    DataFile^.Close;
    Error(xrrVerMismatch, VerStr);
    Dispose (DataFile, Done);
    Exit;
  End;

  InitProcedures (Owner, Self, VarData, CurVarNum, CurVarID, 0);

  ExecuteBlock (CurVarNum, CurRecNum);

  DataFile^.Close;

  Dispose(DataFile, Done);

  Result := Ord(ReloadMenu) + 1;
End;

Function ExecuteMPE (Owner: Pointer; Str: String) : Byte;
Var
  Script : TInterpEngine;
Begin
  Script := TInterpEngine.Create(Owner);
  Result := Script.Execute(Str);

  If Script.ErrNum > 0 Then
    TBBSCore(Owner).Term.OutPipe ('MPE ERROR: ' + Script.GetErrorMsg);

  Script.Free;
End;

End.
