{$A+,B+,D-,F+,I+,L-,O-,R-,S-,V-,Q-}
Program Imp_CD_Import;

Uses  Crt,  Dos;

Const
  Version='v1.0';
  DefDrive='D';
  MaxConfs=20;

Type
  ulrec=                          { UPLOADS.DAT : File base records }
  record
    name:string[40];              { area description  }
    filename:string[12];          { filename + ".DIR" }
    dlpath,                       { download path     }
    ulpath:string[40];            { upload path       }
    maxfiles:integer;             { max files allowed }
    password:string[20];          { password required }
    arctype,                      { wanted archive type (1..max,0=inactive) }
    cmttype:byte;                 { wanted comment type (1..3,0=inactive) }
    fbdepth:integer;              { file base dir depth }
    fbstat:set of fbflags;        { file base status vars }
    acs,                          { access requirements }
    ulacs,                        { upload requirements }
    nameacs:acstring;             { see-names requirements }
    permindx:longint;             { permanent index # }
    Conf:byte;                    { fbase conference }
    res:array[1..5] of byte;      { RESERVED }
  end;

  ConfRec=                       {CONF.DAT}
  Record
    ACSlevel:Array [1..maxconfs] of String[5];  { SL level required. }
    ConfName:Array [1..maxconfs] of String[20];   { Name of Conference }
  End;

  ulfrec=                         { *.DIR : File records }
  record
    filename:string[12];          { Filename }
    description:string[60];       { File description }
    filepoints:integer;           { File points }
    nacc:integer;                 { Number DLs }
    ft:byte;                      { File type (useless?) }
    blocks:integer;               { # 128 byte blks }
    owner:integer;                { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[8];               { Date ULed }
    daten:integer;                { Numeric date ULed }
    vpointer:longint;             { Pointer to verbose descr, -1 if none }
    filestat:set of filstat;      { File status }
    res:array[1..10] of byte;     { RESERVED }
  end;


Var ConfDat:file of confrec;
    Confr:confrec;
    FileDat:File of ULRec;
    FileB:ULRec;
    DirRec:File of UlfRec;
    DirF:UlfRec;
    CurrentDir:PChar;
    ULRoot:String[80];
    CDRom:String[80];
    CurConf:Byte;

Function Exist(FN:String):Boolean;
Var SRec:SearchRec;
begin
  findfirst(sqoutsp(fn),anyfile,srec);
  exist:=(doserror=0);
end;

Procedure ExitMsg(B:Byte);
Var TermStr:String[30];
Begin
  Case B Of
   1:TermStr:='Must Specify a valid Directory';
   2:TermStr:='Error reading FILES.BBS';
   3:TermStr:='CD Read Error';
   4:;
   5:;
   6:;
   7:;
  End;
  ClrScr;
  WriteLn('ImpCD - '+Version);
  WriteLn('Copyright 1995 by Brandon Sneed');
  WriteLn;
  WriteLn('Exited: '+TermStr);
  WriteLn('Don''t forget to wipe!');
  WriteLn;
End;

Function Slash(Path:String):String;
Begin
  If Path[Length(Path)]='\' then Slash:=Path
    Else
      Slash:=Path+'\';
End;

Procedure AddFile(FileName,Desc,DirFile:String);
Var
Begin
  Assign(DirRec,DirFile);

  If (Not Exist('.\DATA\'+DirFile)) Then Rewrite(DirRec)
		else Reset(DirRec);

	Seek(DirRec, FileSize(DirRec));

	With (DirF) Do
	Begin
    filename:=FileName;
    description:=Desc;


    filepoints:=
    nacc:=
    ft:=
    blocks:=
    owner:=
    stowner:
    date:
    daten:
    vpointer:
    filestat:
    res:
	End;
End;

Procedure GetULPath;
Begin
  ULRoot:='';
  Writeln;
  ClrScr;
  Writeln('Due to the fact that most CD-Rom''s aren''t writeable, I');
  Writeln('Need a directory on your Hard Drive to send uploads to');
  Writeln('the CDrom area.  Please enter a root directory to stem');
  Writeln('from.  All the directorys on the cdrom will be mirrord');
  Writeln('to this directory and reside in its tree.');
  Writeln;
  Writeln('Target Dir for SubPaths: ');
  Repeat
    ReadLN(ULRoot);
    If (Not Exist(ULRoot)) Then
      {$I-} MkDir(ULRoot); {$I+}
  Until (Exist(ULRoot));
  ULRoot:=Slash(ULRoot);
End;

Procedure MakeNewArea(Path, AreaName:String);
Begin
  Assign(FileDat,'.\DATA\UPLOADS.DAT');
  Reset(FileDat);
  With FileB Do Begin
    name:=AreaName;
    filename:=AreaName:8;
    dlpath:=CDRom+Path;
    ulpath:=Slash(ULRoot+Path);
    maxfiles:=2000;
    password:='';
    arctype:=1;
    cmttype:=1;
    fbdepth:=0;
    fbstat:=[];
    acs:='s30ds30';
    ulacs:='s30';
    nameacs:='s30';
    permindx:=0;
    Conf:=CurConf;
    for i:=1 to 5 do res[i]:=0;
  End;
  Seek(FileDat, FileSize(FileDat));
  Write(FileDat, FileB);
  Close(FileDat);
End;

Procedure MakeNewConf(Name:String);
Var B:Byte;
Begin
  Assign(ConfDat,'.\DATA\CONF.DAT');
  Reset(ConfDat);
  Read(ConfDat, ConfR);
  CurConf:=0;
  While CurConf=0 Do
  Begin
    CurConf:=0;
    If Confr.ConfName[B] = '' Then CurConf:=B;
  End;
  Confr.ConfName[B]:=Name;
  Close(ConfDat);
End;

Procedure ReadFiles(Path:String);
Begin
End;

Function YNQ(Str:String):Boolean;
Var C:Char;
Begin
  GotoXy(1,24);
  Write(Str+' [Y/n]');
  C:=Upcase(ReadKey);
  Case C Of
    #13:YNQ:=True;
    'Y':YNQ:=True;
    'N':YNQ:=False;
  End;
  GotoXy(1,24);
  For I:=1 To Length(Str)+9 do Write(' ');
End;

Procedure Menu;
Var C:Char;
Begin
  New(CurrentDir);
  GetCurDir(CurDir, CDrive);

  Writeln('ImpCD - FILES.BBS Importer '+version);
  Writeln('Copyright 1995 by Brandon Sneed');
  Writeln;

  Write('Enter CD Drive: ');
  C:=Upcase(ReadKey);
  If (not C in ['A'..'Z']) then C:=DefDrive;

  Dispose(CurrentDir);
End;
