{$M 1024, 0, 1024}
{this needs DCC.EXE to compile}
program NPL_Compiler;

uses Dos, Crt;

const
  revision = '0.01';
  f_date   = '11/10/96';

var
  npl_text : text;
  npl_bin  : text;
  infile : string[12];
  outfile : string[12];
  total_bytes : longint;

function comp_line(s : string) : string;
var cnt : byte;
begin
  result := '';
  for cnt := 1 to length(s) do
    result := result + chr(255 - ord(s[cnt]));
end;

procedure error(err : byte);
begin
writeln('ERROR');
case err of
  1 : writeln(Infile+' does not exist!');
  2 : writeln('Unable to open '+Infile);
  end;
writeln;
writeln('Syntax is DNPL.EXE <filename.ext>');
writeln('ex:  DNPL.EXE TEST.N');
halt;
end;

procedure startup;
begin
writeln('Nexus Programming Language (NPL) Compiler.  (c)1996 by Brandon Sneed (Nivenh)');
writeln('Revision '+Revision+'.  Compiled on '+F_Date);
end;

procedure upstr(var s : string);
var i : byte;
begin
  for i := 1 to length(s)
    do s[i] := upcase(s[i]);
end;


var curline : string;
    cnt : longint;
    y : byte;

begin
  startup;
  cnt := 0;

  infile := paramstr(1);
  outfile := copy(paramstr(1), 1, pos('.',infile))+'N';

  upstr(infile);
  upstr(outfile);

  if infile = '' then
    error(1);
  assign(npl_text, infile);
  {$I-}
  reset(npl_text);
  {$I+}
  if ioresult <> 0 then
    error(2);
  assign(npl_bin, outfile);
  rewrite(npl_bin);

  y := wherey;

  while (not eof(npl_text)) do
    begin
    readln(npl_text, curline);
    inc(cnt);
    inc(total_bytes, length(curline));
    writeln(npl_bin, comp_line(curline));
    gotoxy(1, y);
    write(infile+'(',cnt,')');
    end;

  writeln;

  writeln('Compiled '+infile+', ',total_bytes,' bytes of code in ',cnt,' lines.');
  writeln('Created '+outfile);

  close(npl_bin);
  close(npl_text);
end.
