unit ipx;
interface

type
  ipxadress=record
              net: longint;
              node: array [0..5] of byte;
              socket: word;
            end;

  PBoolean=^Boolean;

var broadcast: ipxadress;

function testipx: boolean;
procedure getmyadress (var myadr:ipxadress);
procedure opensocket (socket: word);
procedure closesocket (socket: word);
procedure senddata (var data;len: word;receiver: ipxadress);
procedure getdata (var data;len: word;var sender: ipxadress);
function prepdatarec (var data;len,socket: word): PBoolean;
procedure finishdatarec (zeiger: PBoolean;var sender: ipxadress);
procedure finishipx;
function compadress (adr1,adr2: ipxadress): boolean;

implementation

uses dos;
type
  nodeadress=array [0..5] of byte;

  ipxheader=record
              chksum: word;
              len: word;
              tc: byte;
              typ: byte;
              dest,src: ipxadress;
            end;

  ecbrec=record
           link,esr: pointer;
           inuse,cmpl: byte;
           sckt: word;
           ipxwrk: longint;
           dwrk: ipxadress;
           dest: nodeadress;
           frgcount: word;
           frgdata: pointer;
           frgsize: word;
         end;

  PIPXHlpStruc=^TIPXHlpStruc;
  TIPXHlpStruc=record
                 head:ipxheader;
                 data:array [0..63999] of byte;
               end;

  PIPXWaitRec=^TIPXWaitRec;
  TIPXWaitRec=record
                ecb: ECBRec;
                ipxh: PIPXHlpStruc;
                datap: pointer;
                datal: word;
                next: PIPXWaitRec;
              end;



var
  ownadr: ipxadress;
  r: registers;
  firstipx,lastipx: PIPXWaitRec;


function testipx: boolean;
begin
  r.ax:=$7A00;intr ($2F,r);
  testipx:=(r.al=$FF);
  if r.al=$FF then getmyadress (ownadr);
  fillchar (broadcast.node,sizeof(broadcast.node),$FF);
  broadcast.net:=ownadr.net;broadcast.socket:=0;
end;

procedure getmyadress (var myadr: ipxadress);
begin
  r.bx:=9;r.es:=seg(myadr);r.si:=ofs(myadr);intr ($7A,r);
end;

procedure opensocket (socket: word);
begin
  r.bx:=0;r.al:=0;r.dx:=swap (socket);intr ($7A,r);
  broadcast.socket:=socket;
end;

procedure senddata (var data;len: word;receiver: ipxadress);
var
  ecb: ecbrec;
  ipxs: PIPXHlpStruc;
begin
  getmem (ipxs,sizeof (ipxheader)+len);
  move (data,ipxs^.data,len);
  fillchar (ecb,sizeof(ecb),0);
  fillchar (ipxs^.head,sizeof(ipxheader),0);

  ipxs^.head.chksum:=$FFFF;
  move (ownadr,ipxs^.head.src,sizeof(ipxadress));
  ipxs^.head.src.socket:=swap(receiver.socket);
  move (receiver,ipxs^.head.dest,sizeof(ipxadress));
  ipxs^.head.dest.socket:=swap (ipxs^.head.dest.socket);
  ipxs^.head.len:=swap(sizeof(ipxheader)+len);

  move (receiver.node,ecb.dest,sizeof(nodeadress));
  ecb.sckt:=swap (receiver.socket);
  ecb.frgcount:=1;
  ecb.frgsize:=sizeof(ipxheader)+len;
  ecb.frgdata:=ipxs;

  r.bx:=3;r.es:=seg(ecb);r.si:=ofs(ecb);intr ($7A,r);
  freemem (ipxs,sizeof(ipxheader)+len);
end;

procedure getdata (var data;len: word;var sender: ipxadress);
var
  ecb: ecbrec;
  ipxs: Pipxhlpstruc;
begin
  getmem (ipxs,sizeof(ipxheader)+len);
  fillchar (ecb,sizeof(ecb),0);
  fillchar (ipxs^.head,sizeof(ipxheader),0);
  ecb.sckt:=swap (sender.socket);
  ecb.inuse:=$1D;
  ecb.frgcount:=1;
  ecb.frgsize:=sizeof(ipxheader)+len;
  ecb.frgdata:=ipxs;
  r.bx:=4;r.es:=seg(ecb);r.si:=ofs(ecb);intr ($7A,r);
  while ecb.inuse<>0 do;
  ipxs^.head.src.socket:=swap (ipxs^.head.src.socket);
  move (ipxs^.head.src,sender,sizeof(ipxadress));
  move (ipxs^.data,data,len);
  freemem (ipxs,sizeof(ipxheader)+len);
end;

function prepdatarec (var data;len,socket: word): PBoolean;
var
  ecb: ecbrec;
  akt: PIPXWaitRec;
  help: PBoolean;
begin
  akt:=lastipx;akt^.datal:=len;akt^.datap:=@data;
  new (lastipx^.next);lastipx:=lastipx^.next;
  lastipx^.next:=NIL;lastipx^.ipxh:=NIL;
  getmem (akt^.ipxh,sizeof(ipxheader)+len);
  fillchar (akt^.ecb,sizeof(ecbrec),0);
  fillchar (akt^.ipxh^.head,sizeof(ipxheader),0);
  akt^.ecb.sckt:=swap (socket);
  akt^.ecb.inuse:=$1D;
  akt^.ecb.frgcount:=1;
  akt^.ecb.frgsize:=sizeof(ipxheader)+len;
  akt^.ecb.frgdata:=akt^.ipxh;
  r.bx:=4;r.es:=seg(akt^.ecb);r.si:=ofs(akt^.ecb);intr ($7A,r);
  prepdatarec:=@akt^.ecb.inuse;
end;

procedure finishdatarec (zeiger: PBoolean;var sender: ipxadress);
var akt,akt2: PIPXWaitRec;
begin
  akt:=firstipx;
  while (akt<>NIL) and (@akt^.ecb.inuse<>zeiger) do akt:=akt^.next;
  if akt<>NIL then
  begin
    akt^.ipxh^.head.src.socket:=swap (akt^.ipxh^.head.src.socket);
    move (akt^.ipxh^.head.src,sender,sizeof(ipxadress));
    move (akt^.ipxh^.data,akt^.datap^,akt^.datal);
    freemem (akt^.ipxh,sizeof(ipxheader)+akt^.datal);
    if akt<>firstipx then
    begin
      akt2:=akt;akt:=firstipx;
      while (akt<>NIL) and (akt^.next<>akt2) do akt:=akt^.next;
      akt^.next:=akt2^.next;
      if akt2^.next=NIL then lastipx:=akt;
      dispose (akt2);
    end;
    if akt^.next=lastipx then
    begin
      akt^.ipxh:=NIL;dispose (akt^.next);akt^.next:=NIL;lastipx:=akt;
    end;
  end;
end;

function compadress (adr1,adr2: ipxadress):boolean;
var
  a: byte;
  erg: boolean;
begin
  erg:=true;
  for a:=0 to 5 do erg:=erg and (adr1.node[a]=adr2.node[a]);
  compadress:=erg;
end;

procedure closesocket (socket: word);
begin
  r.bx:=1;r.dx:=swap (socket);intr ($7A,r);
end;

procedure finishipx;
var akt,akt2: PIPXWaitRec;
begin
  akt:=firstipx;
  while akt<>NIL do
  begin
    akt2:=akt^.next;
    if akt^.ipxh<>NIL then freemem (akt^.ipxh,sizeof(ipxheader)+akt^.datal);
    dispose (akt);
    akt:=akt2;
  end;
end;

begin
  new (firstipx);firstipx^.ipxh:=NIL;firstipx^.next:=NIL;
  lastipx:=firstipx;
end.

