{--------------------------------------------------------------------}
{-                           EXREDIR.PAS                            -}
{-                    Demo-Prg fr LFN ab v1.05                     -}
{-             Written by Andreas Killer, Germany, NRW              -}
{-      homepage: http://home.t-online.de/home/andreas.killer       -}
{--------------------------------------------------------------------}

uses
  Crt, Dos, Lfn;

const
  {-In diesen Variablen werden die ausgewerteten Parameter gespeichert}
  TestOption : Boolean = False;
  FileName : PathStr = '';

  procedure Help;
    {-Gibt eine Hilfestellung zum Aufruf aus}
  begin
    {-Sicherstellen das die Meldung auf den Bildschirm ausgegeben wird}
    AssignCrt(Output);
    Rewrite(Output);

    {-Den Hilfetext ausgeben}
    WriteLn('Aufruf:');
    WriteLn('  EXREDIR [-Option]');
    WriteLn('Optionen sind:');
    WriteLn('  f      = Dateiname   Beispiel: -f Dateiname');
    WriteLn('  t[+|-] = Testoption  Beispiel: -t oder -t- oder -t+');
    WriteLn;
    WriteLn('Diese Programm kann per <Dateiname Kommandozeilenparameter aus');
    WriteLn('einer Datei lesen. Desweiteren ist es mglich die Ausgabe z.B.');
    WriteLn('per >Dateiname in eine Datei umzuleiten.');
    WriteLn('Dies ermglicht z.B. auch Pipes:');
    WriteLn('  echo -f abc|exredir|more');
    WriteLn;
    Halt;
  end;

  procedure Abort(Msg : String);
    {-Gibt Msg auf den Bildschirm aus und beendet das Programm}
  begin
    {-Sicherstellen das die Meldung auf den Bildschirm ausgegeben wird}
    AssignCrt(Output);
    Rewrite(Output);
    {-Anmerkung: Ein mehrmaliges ffnen von Output verursacht keine Probleme,
      da ein Reset oder Rewrite ein ggf. offenes File zuerst schliet.}

    {-Msg ausgeben}
    WriteLn(Msg);
    Halt;
  end;

  procedure ParseParam;
    {-Wertet die Kommandozeile aus}
  var
    I : Byte;
    S : String;
    FileNameFollows : Boolean;
  begin
    FileNameFollows := False;

    {-Parameter auswerten}
    for I := 1 to ParamCount do begin
      S := ParamStr(I);
      case S[1] of
        '-' : if Length(S) < 2 then
                Abort('Parameter fehlt nach Optionseinleitung '+S)
              else
                case Upcase(S[2]) of
                  'F' : FileNameFollows := True;
                  'T' : if Length(S) < 3 then
                          TestOption := True
                        else
                          case S[3] of
                            '+' : TestOption := True;
                            '-' : TestOption := False;
                          else
                            Abort('Ungltige Option: '+S[3]);
                          end;
                else
                  Abort('Ungltige Option: '+S[2]);
                end;
      else
        if FileNameFollows then
          FileName := S
        else
          Abort('Ungltiger Parameter: '+S);
        FileNameFollows := False;
      end;
    end;
  end;

  function CharStr(C : Char; Len : Byte) : String; Assembler;
    {-Gibt einen String der Lnge Len gefllt mit C zurck}
  asm
    les     di, @Result           {-ES:DI => CharStr}
    cld                           {-Aufwrts fllen}
    mov     al, Len               {-AL:= Len}
    stosb                         {-Lngenbyte schreiben}
    xor     ch, ch                {-CX:= Len}
    mov     cl, Len
    mov     al, C                 {-AL:= C}
    rep     stosb                 {-CX mal AL nach ES:DI schreiben}
  end;

  {---------
    Anmerkung: Redirect ist auch in LFNEnh ab v1.01 enthalten
  ---------}

  function Redirect(var T : Text) : Boolean; Assembler;
    {-True wenn InPut/OutPut per DOS in auf eine Datei umgeleitet wurde.}
  asm
    les     di, T
    mov     ax, 4400h             {-IOCTL: Attribut lesen}
    mov     bx, es:[di]           {-BX = Handle}
    int     21h
    mov     al, False
    jc      @@Done                {-Fehler?}
{---
  DX enthlt die Attribute des Treibers. Ein gesetztes Bit bedeutet:
     0    Treiber ist CON-Eingabe (Tastatur)
     1    Treiber ist CON-Ausgabe (Bildschirm)
     2    Treiber ist NUL
     3    Treiber ist ein Clock-Device
     5    Treiber ist im RAW-Modus, ansonsten COOKED-Modus
     7    Treiber ist ein Zeichentreiber, ansonsten eine Datei
    14    Treiber kann Kontrollzeichen von AX=4402h/4403h INT 21 verarbeiten
  Alle anderen Bits sind reserviert.
---}
    test    dl, 80h
    jnz     @@Done
    mov     al, True
@@Done:
  end;

var
  SaveParamPtr : Pointer;
  Line : String;
  CON : Text;
begin
  {-Erstmal einen Header ausgeben. Dieser erscheint wegen "uses Crt" immer
    auf dem Bildschirm}
  WriteLn(CharStr('-', 79));
  WriteLn(' EXREDIR v1.0   Beispielprogramm fr die Anwendung von Umleitungen    A.Killer');
  WriteLn(CharStr('~', 79));

  {-Umleitung der Ausgabe trotz Unit CRT ermglichen}
  Assign(Output, '');
  Rewrite(Output);

  {-Device CON ffnen um auf den Bildschirm schreiben zu knnen}
  Assign(CON, 'CON');
  Rewrite(CON);

  {-Ist die Eingabe umgeleitet worden?}
  if Redirect(Input) then begin
    {-Ja, sie zeigt nun auf eine Datei die man auslesen kann}
    Assign(Input, '');
    {-Input auf diese Datei setzen}
    Reset(Input);

    {-Den Zeiger auf die Kommandozeile sichern...}
    SaveParamPtr := ParamPtr;
    {...und auf den String der zum Einlesen benutzt wird umstellen}
    ParamPtr := @Line;

    if EoF(Input) then
      Abort('Keine Parameter ber Eingabeumleitung angegeben');

    while not EoF(Input) do begin
      {-Anmerkung: ReadLn liest immer von InPut wenn nichts angegeben wird}
      ReadLn(Line);
      {-Zeile auswerten}
      ParseParam;
    end;
    {-Anmerkung: Es ist nicht notwendig InPut an dieser Stelle zu schlieen,
      da die Datei bereits vom Betriebssystem geffnet wurde}

    {-Den Zeiger auf die Kommandozeile wieder herstellen}
    ParamPtr := SaveParamPtr;
  end
  else
    if ParamCount = 0 then
      {-Hilfe ausgeben und Halt}
      Help;

  {-Jetzt wird die Kommandozeile ausgewertet. Dies sollte immer nach der
    Auswertung einer ggf. erfolgten Umleitung geschehen, da die Parameter in
    der Kommandozeile vor diesen Vorrang haben (sollten).}
  ParseParam;

  {-Wurde die Ausgabe umgeleitet?}
  if Redirect(Output) then begin
    {-Dieser Text erscheint trotz Ausgabeumleitung auf dem Bildschirm}
    WriteLn(CON, 'Zustzliche Ausgabe ber CON:');
    WriteLn(CON, 'FileName ist ', FileName);
    WriteLn(CON, 'TestOption ist ', TestOption);
  end;

  {-Dieser Text wird in ggf. in die Ausgabeumleitung geschrieben}
  WriteLn('FileName ist ', FileName);
  WriteLn('TestOption ist ', TestOption);

  WriteLn(CON, 'Ende von EXREDIR, nun wieder DOS:');
  {-CON-Device schlieen}
  Close(CON);
  {-Anmerkung: Es ist nicht notwendig InPut oder OutPut zu schlieen.}
end.
