UNIT tpzasync;
(* Modem interface routines for Turbo Pascal Zmodem *)
(* (c)1988 by J.R.Louvau                            *)
(* You will need a copy of PIBASYN45 to compile     *)
(* this unit.                                       *)

INTERFACE

  USES dos, pibasync;   (*, PibAsync, PibTimer, GlobType;*)

  FUNCTION z_asyncon(zport : word; zbaud : longint) : boolean;
  PROCEDURE z_asyncoff;
  FUNCTION z_charavail : boolean;
  PROCEDURE z_clearinbound;
  PROCEDURE z_flushoutbound;
  PROCEDURE z_clearoutbound;
  PROCEDURE z_sendbreak;
  FUNCTION z_receivebyte : integer;
  PROCEDURE z_sendbyte(b : byte);
  FUNCTION z_carrier : boolean;

IMPLEMENTATION

  FUNCTION z_charavail : boolean;
  (* See if there is a character coming in *)

    BEGIN (* z_charavail *)
    z_charavail := async_buffer_check;
    END; (* z_charavail *)

  (* 1---------------1 *)

  PROCEDURE z_clearinbound;
  (* Throw away any pending input to clear the line *)

    VAR
      n              : integer;

    BEGIN (* z_clearinbound *)
    WHILE (async_carrier_detect) AND (async_buffer_check) DO
      async_receive_with_timeout(1, n);
    END; (* z_clearinbound *)

  (* 1---------------1 *)

  PROCEDURE z_clearoutbound;
  (* Throw away any pending output in the buffer *)

    BEGIN (* z_clearoutbound *)
    async_flush_output_buffer;
    END; (* z_clearoutbound *)

  (* 1---------------1 *)

  PROCEDURE z_flushoutbound;

    BEGIN (* z_flushoutbound *)
    REPEAT
      (* nothing *)
    UNTIL (NOT async_carrier_detect) OR
          (async_obuffer_head = async_obuffer_tail);
    END; (* z_flushoutbound *)

  (* 1---------------1 *)

  PROCEDURE z_sendbreak;
  (* Send a break signal *)

    BEGIN (* z_sendbreak *)
    async_send_break;
    END; (* z_sendbreak *)

  (* 1---------------1 *)

  PROCEDURE z_sendbyte(b : byte);
  (* Output one byte *)

    BEGIN (* z_sendbyte *)
    async_send(chr(b));
    END; (* z_sendbyte *)

  (* 1---------------1 *)

  FUNCTION z_receivebyte : integer;
  (* Input one byte (N.B. : RETURNS AN INTEGER!) *)

    VAR
      n              : integer;

    BEGIN (* z_receivebyte *)
    async_receive_with_timeout(0, n);
    z_receivebyte := (n AND $00ff);
    END; (* z_receivebyte *)

  (* 1---------------1 *)

  FUNCTION z_carrier : boolean;
  (* Checks for the presence of a carrier *)

    BEGIN (* z_carrier *)
    z_carrier := (async_carrier_detect);
    END; (* z_carrier *)

  (* 1---------------1 *)

  PROCEDURE z_asyncoff;

    VAR
      i              : integer;
      m              : integer;

    BEGIN  (* z_asyncoff *)
    (* Read the RBR and reset any pending error conditions. *)
    (* First turn off the Divisor Access Latch Bit to allow *)
    (* access to RBR, etc.                                  *)
    inline($fa);                               (* disable interrupts *)
    port[uart_lcr + async_base] := port[uart_lcr + async_base] AND $7f;

    (* Read the Line Status Register to reset any errors *)
    (* it indicates                                      *)
    i := port[uart_lsr + async_base];

    (* Read the Receiver Buffer Register in case it *)
    (* contains a character                         *)
    i := port[uart_rbr + async_base];

    (* enable the irq on the 8259 controller *)
    i := port[i8088_imr];         (* get the interrupt mask register *)
    m := (1 shl async_irq) xor $00ff;
    port[i8088_imr] := i AND m;

    (* enable OUT2 on 8250 *)
    i := port[uart_mcr + async_base];
    port[uart_mcr + async_base] := i OR $0b;

    (* enable the data ready interrupt on the 8250 *)
    port[uart_ier + async_base] := $0f;

    (* Re-enable 8259 *)
    port[$20] := $20; inline($fb);              (* enable interrupts *)
    IF async_open_flag THEN BEGIN     (* disable the IRQ on the 8259 *)
      inline($fa);                             (* disable interrupts *)
      i := port[i8088_imr];       (* get the interrupt mask register *)
      m := 1 shl async_irq;       (* set mask to turn off interrupt  *)
      port[i8088_imr] := i OR m;  

      (* disable the 8250 interrupts *)
      port[uart_ier + async_base] := 0;

      (* Disable OUT2, RTS, OUT1 on the 8250, but *)
      (* possibly leave DTR enabled.              *)
      port[uart_mcr + async_base] := 1;
      inline($fb);                              (* enable interrupts *)

      (* re-initialize our data areas so we know *)
      (* the port is closed                      *)
      async_open_flag := false; async_xoff_sent := false;

      (* Restore the previous interrupt pointers *)
      setintvec( async_irq + 8 , async_save_iaddr);
      i := port[uart_lsr + async_base];

      (* Read the Receiver Buffer Register in case it *)
      (* contains a character                         *)
      i := port[uart_rbr + async_base];

      (* enable the irq on the 8259 controller *)
      i := port[i8088_imr];       (* get the interrupt mask register *)
      m := (1 shl async_irq) xor $00ff;
      port[i8088_imr] := i AND m;

      (* enable OUT2 on 8250 *)
      i := port[uart_mcr + async_base];
      port[uart_mcr + async_base] := i OR $0b;
      (* enable the data ready interrupt on the 8250 *)
      port[uart_ier + async_base] := $0f;

      (* Re-enable 8259 *)
      port[$20] := $20; inline($fb); (* enable interrupts *) END;
    END; (* z_asyncoff *)

  (* 1---------------1 *)

  FUNCTION z_asyncon(zport : word; zbaud : longint) : boolean;

    BEGIN (* z_asyncon *)
    async_do_cts := false; async_do_dsr := false;
    async_do_xonxoff := false; async_hard_wired_on := false;
    async_break_length := 500;
    async_init(2048, 2048, 0, 0, 0);
    z_asyncon := async_open(zport, zbaud, 'N', 8, 1);
    END; (* z_asyncon *)

  (* 1---------------1 *)

  END.