Program FilesBBS;
Uses CRT, DOS, RGAPI;

{$I 05-19rec.pas}

type
  FBBSRec = Record
     name : string;
     size : longint;
     date : string;
     desc : array[1..19] of string;
  end;


Var
  fbbs        : fbbsrec;
  WhichErr    : Byte;
  WhichRec    : longint;
  fbbstxt     : text;
  InStr       : String;

(* ini *)
  fini                     : text;
  fbasename                : string;
  fname                    : string;
  fname_lo,fname_hi        : integer;
  fsize                    : string;
  fsize_lo,fsize_hi        : integer;
  fdate                    : string;
  fdate_lo,fdate_hi        : integer;
  fdesc                    : string;
  fdesc_lo,fdesc_hi        : integer;
  findblanks               : string;
  fbbspath                 : string;
  filespath                : string;

(* temp vars *)
  a  : longint;

procedure HandleError(s:string; ha:boolean; c:byte );
begin
  pipeln('|12 |10Error #|15: |14'+IntToStr(c));
  pipeln('|12 |14'+s);
  if ha then halt;
end;

procedure ReadSetupIni;
 begin

   if fileexists('fbbs.ini') then begin
      assign(fini,'fbbs.ini');
      reset(fini)
   end else HandleError('No fbbs.ini found. Please make one',true,16);

   readln(fini,fbasename);
   readln(fini,fname);
   readln(fini,fsize);
   readln(fini,fdate);
   readln(fini,fdesc);
   readln(fini,findblanks);
   readln(fini,fbbspath);
   readln(fini,filespath);
   close(fini);

  {get hi, lo}
  {have to account for the ones without it}
  fname_lo := StrToInt(copy(fname,1,pos('-',fname)-1));
  fname_hi := StrToInt(copy(fname,pos('-',fname)+1,length(fname)));
  fsize_lo := StrToInt(copy(fsize,1,pos('-',fsize)-1));
  fsize_hi := StrToInt(copy(fsize,pos('-',fsize)+1,length(fsize)));
  fdate_lo := StrToInt(copy(fdate,1,pos('-',fdate)-1));
  fdate_hi := StrToInt(copy(fdate,pos('-',fdate)+1,length(fdate)));
  fdesc_lo := StrToInt(copy(fdesc,1,pos('-',fdesc)-1));
  fdesc_hi := StrToInt(copy(fdesc,pos('-',fdesc)+1,length(fdesc)));
 end;

procedure OpenReadFromCloseRenegadeDat;
 begin
  OpenRenegadeDat('',WhichErr);
    If WhichErr <> 0 then HandleError('Can''t find Renegade.dat',True,WhichErr);
  ReadFromRenegadeDat(WhichErr);
    If WhichErr <> 0 then HandleError('Can''t read from Renegade.dat',True,WhichErr);
  CloseRenegadeDat;
 end;

procedure OpenFBases;
 begin
    OpenFBasesDat(RenegadeDatIn.DataPath,WhichErr);
    if whicherr <> 0 then begin
       assign(fbasesdat,RenegadeDatIn.DataPath+'fbases.dat');
       rewrite(fbasesdat);
    end;
 end;

procedure FindWhichFBaseWeShouldAddorCreateTo;
 begin

  whichrec := -1;
  for a := 0 to (filesize(fbasesdat)-1) do begin
      ReadFromFBasesDat(a);
      If pos(fbasename,FBasesDatIn.filename) <> 0 then WhichRec := a;
      If pos(fbasename,FBasesDatIn.filename) <> 0 then break;
  end;

  if whichrec = -1 then begin


     With FbasesdatIn do begin
          name := 'New Base';
          filename := fbasename;
          dlpath := filespath;
          ulpath := filespath;
          maxfiles := 2000;
          arctype := 1;
          cmttype := 1;
          fbstat := [];
     end;

     WriteToFBasesDat(FileSize(Dir));
     CloseFBasesDat;
  end;

 end;

procedure CreateOrOpenTheDIRfile;
 begin
    writeln(AddSlash(RenegadeDatIn.DataPath)+fbasename+'.DIR');
    if fileexists(AddSlash(RenegadeDatIn.DataPath)+fbasename+'.DIR') then begin
       OpenDir(fbasename,RenegadeDatIn.DataPath,WhichErr);
         if whicherr <> 0 then HandleError('Can Open the DIR file',true,17);
    end else begin
        assign(Dir,AddSlash(RenegadeDatIn.DataPath)+fbasename+'.DIR');
        rewrite(Dir);
    end;
 end;

procedure OpenFBBSText;
  begin
    if fileexists(fbbspath) then begin
       assign(fbbstxt,fbbspath);
       reset(fbbstxt);
    end else HandleError('Where is the description located?',true,18);
  end;

         function value(s:astr):longint;
         var i:longint;
           j:integer;
         begin
           val(s,i,j);
           if (j > 0) then
           begin
             s[0] := chr(j-1);
             val(s,i,j)
           end;
           value := i;
           if (s = '') then
             value := 0;
         end;


function days(var mo,yr:integer):integer;
var d:integer;
begin
  d:=value(copy('312831303130313130313031',1+(mo-1)*2,2));
  if ((mo=2) and (yr mod 4 = 0)) then inc(d);
  days:=d;
end;

function daycount(var mo,yr:integer):integer;
var
  m,t:integer;
begin
  t:=0;
  for m:=1 to (mo-1) do
    t:=t+days(m,yr);
  daycount:=t;
end;

    function daynum(dt:string):integer;
    var
      d,m,y,c,t:integer;
    begin
      t:=0;
      m:=value(copy(dt,1,2));
      d:=value(copy(dt,4,2));
      y:=value(copy(dt,7,4));
      for c:=1985 to y-1 do
        if (c mod 4 = 0) then inc(t,366) else inc(t,365);
      t:=t+daycount(m,y)+(d-1);
      daynum:=t;
      if y<1985 then daynum:=0;
    end;

function RemoveSpacesAndCommas(Size2Change : String) : Integer;
 var tstr : string;
 begin
  tstr := Size2Change;
  repeat
     delete(tstr,pos(',',tstr),1);
  until pos(',',tstr) = 0;
  removespacesandcommas := StrToInt(tstr);
 end;


procedure MainProgram;
  begin
    while not eof(fbbstxt) do begin

          {what about stuff that goes over 255 chars!!}
          readln(fbbstxt,InStr);
          fillchar(fbbs,sizeof(fbbs),#0);

          if (instr[1] <> '') then begin

             fbbs.name    :=           copy( instr, fname_lo, (fname_hi-fname_lo)+1);
             fbbs.size    := removespacesandcommas( copy( instr, fsize_lo, (fsize_hi-fsize_lo)+1));
             fbbs.date    :=           copy( instr, fdate_lo, (fdate_hi-fdate_lo)+1);
             fbbs.desc[1] :=           copy( instr, fdesc_lo, (fdesc_hi-fdesc_lo)+1);


             writeln('--------------------------------------');
             writeln('File: '+fbbs.name);
             writeln('Size: '+copy(instr,fsize_lo,(fsize_hi-fsize_lo)+1));
             writeln('Date: '+fbbs.date);
             writeln('Desc: '+fbbs.desc[1]);
             readln;

             with DirIn Do begin
                  filename := fbbs.name;
                  description := fbbs.desc[1];
                  credits := 0;
                  downloaded := 0;
                  sizemod := fbbs.size mod 128;
                  blocks := fbbs.size div 128;
                  owner := 1;
                  stowner := 'Sysop';
                  date := fbbs.date;
                  daten := daynum(fbbs.date);
                  vpointer := -1;
                  filestat := [];
             end;
             WriteToDir(FileSize(Dir));
          end;
          break;
    end;
    CloseDir;
    Close(fbbstxt);
  end;

Begin
  ReadSetupIni;
  OpenReadFromCloseRenegadeDat;
  OpenFBases;
  FindWhichFBaseWeShouldAddorCreateTo;
  CreateOrOpenTheDIRfile;
  OpenFBBSText;
  MainProgram
End.