{$A+,B-,D-,E-,F+,I-,L-,N-,O+,R-,S+,V-}

unit Mail0;

interface


uses Crt, Dos, Overlay, Common, Timefunc;

procedure Updateboard;
procedure Extract(var x: longint);
procedure Dumpquote(var Mheader: Mheaderrec);
procedure Loadheader(x: word; var Mhead: Mheaderrec);
procedure Saveheader(x: word; var Mhead: Mheaderrec);
procedure Initboard (x: integer);
procedure Readmsg(Anum, Mnum, Tnum: word);
function MsgHeaderMCI(const s:astr; Data1, Data2:Pointer):string;
function Headerline(var Mhead: Mheaderrec; Mnum, Tnum: word; line: byte): string;
procedure Savelastread (Lastreaddate: longint);
function Togglenewscan: boolean;
function Toyou (var Messageheader: Mheaderrec) : boolean;
function Fromyou (var Messageheader: Mheaderrec) : boolean;

implementation

uses File0, Sysop4, File8, File2, Shortmsg;

function Fromyou (var Messageheader: Mheaderrec) : boolean;
begin
    if (Messageheader.From.Usernum = Usernum) or
        (Allcaps (Messageheader.From.A1S) = Thisuser.name) or
        (Allcaps (Messageheader.From.name) = Thisuser.name) or
        (Allcaps (Messageheader.From.A1S) = Allcaps (Thisuser.Realname) ) 
    then
        Fromyou := true
    else
        Fromyou := false;
end; { ? }

function Toyou (var Messageheader: Mheaderrec) : boolean;
begin
    if (Messageheader.Mto.Usernum = Usernum) or
        (Allcaps (Messageheader.Mto.A1S) = Thisuser.name) or
        (Allcaps (Messageheader.Mto.name) = Thisuser.name) or
        (Allcaps (Messageheader.Mto.A1S) = Allcaps (Thisuser.Realname) ) 
    then
        Toyou := true
    else
        Toyou := false;
end; { ? }

procedure Updateboard;
var
    Fo: boolean;
begin
    if (Readboard < 1) or (Readboard > Maxmbases) then exit;

    Fo := (filerec (Mbasesfile).mode <> fmclosed);
    if not Fo then
    begin
        reset (Mbasesfile);
        if (ioresult > 0) then
        begin
            Sysoplog ('error opening MBASES.DAT');
            exit;
        end; { if }
    end; { if }

    seek (Mbasesfile, Readboard -1);
    read (Mbasesfile, Memboard);
    Memboard.Mbstat := Memboard.Mbstat + [Mbscanout];
    seek (Mbasesfile, Readboard -1);
    write (Mbasesfile, Memboard);

    if (ioresult > 0) then
        Sysoplog ('error saving message base ' + Cstr (Readboard) );

    if not Fo then
    begin
        close (Mbasesfile);
        if (ioresult > 0) then
            Sysoplog ('error closing MBASES.DAT');
    end; { if }
end; { ? }

function Togglenewscan: boolean;
var
    Lastreadrecord: Scanrec;
    Index: integer;
begin
    reset (Msgscnf);
    Lasterror := ioresult;

    if (Usernum > filesize (Msgscnf) ) then     { was Usernum -1 >= }
    begin
        Lastreadrecord.Lastread := 0;
        Lastreadrecord.Newscan := true;
        seek (Msgscnf, filesize (Msgscnf) );
        for Index := filesize (Msgscnf) to (Usernum-2) do
            write (Msgscnf, Lastreadrecord);
    end { if }
    else
    begin
        seek (Msgscnf, Usernum-1);
        read (Msgscnf, Lastreadrecord);
        seek (Msgscnf, Usernum-1);
    end; { if else }

    Togglenewscan := Lastreadrecord.Newscan;
    Lastreadrecord.Newscan := not Lastreadrecord.Newscan;
    Newscanmbase := Lastreadrecord.Newscan;
    write (Msgscnf, Lastreadrecord);
    close (Msgscnf);

    Lasterror := ioresult;
end; { ? }

procedure Savelastread (Lastreaddate: longint);
var
    Lastreadrecord: Scanrec;
    Index: integer;
begin
    reset (Msgscnf);
    Lasterror := ioresult;
    if (Usernum > filesize (Msgscnf) ) then     { was Usernum -  >= }
    begin
        Lastreadrecord.Lastread := 0;
        Lastreadrecord.Newscan := true;
        seek (Msgscnf, filesize (Msgscnf) );
        for Index := filesize (Msgscnf) to (Usernum-2) do
            write (Msgscnf, Lastreadrecord);
    end { if }
    else
    begin
        seek (Msgscnf, Usernum-1);
        read (Msgscnf, Lastreadrecord);
        seek (Msgscnf, Usernum-1);
    end; { if else }

    Lastreadrecord.Lastread := Lastreaddate;
    Lastmsgread := Lastreaddate;
    write (Msgscnf, Lastreadrecord);
    close (Msgscnf);
    Lasterror := ioresult;
end; { ? }

procedure Loadheader (x: word; var Mhead: Mheaderrec);
var
    Fo: boolean;
begin
    Fo := filerec (Msghdrf).mode <> fmclosed;
    if not Fo then
    begin
        reset (Msghdrf);
        if (ioresult = 2) then
        begin
            rewrite (Msghdrf);
            if (ioresult <> 0) then
            begin
                Sysoplog ('error opening message file.');
                exit;
            end; { if }
        end; { if }
    end; { if }

    seek (Msghdrf, x-1);
    read (Msghdrf, Mhead);

    Lasterror := ioresult;

    if not Fo then
        close (Msghdrf);
end; { ? }

procedure Saveheader (x: word; var Mhead: Mheaderrec);
var
    Fo: boolean;
begin
    Fo := filerec (Msghdrf).mode <> fmclosed;
    if not Fo then
    begin
        reset (Msghdrf);
        if (ioresult = 2) then
        begin
            rewrite (Msghdrf);
            if (ioresult <> 0) then
            begin
                Sysoplog ('error opening message file.');
                exit;
            end; { if }
        end; { if }
    end; { if }

    seek (Msghdrf, x-1);
    write (Msghdrf, Mhead);

    Lasterror := ioresult;

    close (Msghdrf);

    if Fo then
        reset (Msghdrf);
end; { ? }

procedure Initboard (x: integer);        { x=-1,0 = e-mail }
var
    Lastreadrecord: Scanrec;
begin
    Loadboard (x);

    assign (Msghdrf, General.Msgpath+ Memboard.Filename+ '.HDR');
    assign (Msgtxtf, General.Msgpath+ Memboard.Filename+ '.DAT');

    if (x = -1) then
        exit;

    assign (Msgscnf, General.Msgpath+ Memboard.Filename+ '.SCN');
    reset (Msgscnf);
    if (ioresult = 2) then
        rewrite (Msgscnf);

    if (Usernum > filesize (Msgscnf) ) then  { was Usernum -1  >= filesize }
    begin
        Lastmsgread := 0;
        Newscanmbase := true;
    end { if }
    else
    begin
        seek (Msgscnf, Usernum-1);
        read (Msgscnf, Lastreadrecord);
        Lastmsgread := Lastreadrecord.Lastread;
        Newscanmbase := Lastreadrecord.Newscan;
    end; { if else }
    close (Msgscnf);
    Lasterror := ioresult;
end; { ? }


procedure Dumpquote (var Mheader: Mheaderrec);
var T: text;
    Totload: integer;
    S: string;
    S1, S2: string [80];
    Dt: datetime;

begin
    if (Mheader.Textsize < 1) then exit;
    assign (T, 'TEMPQ'+ Cstr (Node) );
    rewrite (T);
    if (ioresult <> 0) then
    begin
        Sysoplog ('error opening quote file.');
        exit;
    end; { if }
    Totload:= 0;
    if (Mbrealname in Memboard.Mbstat) then
        S := Caps (Mheader.From.real)
    else
        S := Caps (Mheader.From.A1S);

    for Totload:= 1 to 2 do begin
        S1:= Fstring.Quote_Line [Totload];
        S1:= Substitute (S1, '@F', Usename (Mheader.From.Anon, S) );
        if (Mbrealname in Memboard.Mbstat) then
            S2:= Caps (Mheader.Mto.real)
        else
            S2:= Caps (Mheader.Mto.A1S);
        S1:= Substitute (S1, '@T', Usename (Mheader.Mto.Anon, S2) );
        Packtodate (Dt, Mheader.Date);
        S2:= Cstr (Dt.day) + ' '+ copy (Monthstring [Dt.month], 1, 3) + ' '+
        copy (Cstr (Dt.year), 3, 2) + '  '+ Zeropad (Cstr (Dt.hour) ) + ':'+ Zeropad (Cstr (Dt.min) );
        if Mheader.Origindate= '' then S1:= Substitute (S1, '@D', S2)
        else S1:= Substitute (S1, '@D', Mheader.Origindate);
        if (Mheader.Fileattached = 0) then
            S1:= Substitute (S1, '@S', Mheader.Subject)
        else
            S1:= Substitute (S1, '@S', Stripname (Mheader.Subject) );
        S1:= Substitute (S1, '@B', Memboard.name);
        if S1<> '' then writeln (T, S1);
    end; { for }

    writeln (T);

    S1:= S [1];
    if (pos (' ', S) > 0) and (length (S) > pos (' ', S) ) then
        S1 := S1 + S [pos (' ', S) + 1]
    else
        if (length (S1) > 1) then
            S1 := S1 + S [2];

    Totload := 0;
    if (Mheader.From.Anon <> 0) then S1 := '';

    reset (Msgtxtf, 1);
    seek (Msgtxtf, Mheader.pointer-1);

    S1:= copy (S1, 1, 2);
    repeat
        blockread (Msgtxtf, S [0], 1);
        blockread (Msgtxtf, S [1], ord (S [0] ) );
        Lasterror := ioresult;
        if (Lasterror <> 0) then
        begin
            Sysoplog ('error loading message text.');
            Totload := Mheader.Textsize;
        end; { if }
        inc (Totload, length (S) + 1);
        if (pos ('> ', copy (S, 1, 4) ) > 0) then
            S := copy (Stripcolor (S), 1, 79)
        else
            S := copy (S1+ '> '+ Stripcolor (S), 1, 79);
        writeln (T, S);
    until (Totload>= Mheader.Textsize);
    close (T);
    close (Msgtxtf);
    Lasterror := ioresult;
end; { ? }


{used to extract a msg file!!}
procedure Extract(var x: longint);
var T: text;
    Totload: word;
    S: string;
    B: boolean;
    Mheader: Mheaderrec;

begin
    Prt (^M^J'Extract filename: ');
    Inputdefault (S, 'MSG.TXT', 40, 'UL', true);
    if Pynq ('Are you sure? ') then begin
        B:= Pynq ('Strip color codes from output? ');

        Loadheader (x, Mheader);

        assign (T, S);
        append (T);

        if (ioresult = 2) then
        begin
            rewrite (T);
            if (ioresult <> 0) then
            begin
                Print ('Cannot create file.');
                exit;
            end; { if }
        end; { if }

        for Totload := 1 to 7 do
        begin
            S:= Headerline(Mheader, x, Himsg, Totload);
            if S <> '' then writeln (T, Stripcolor (S) );
        end; { for }

        writeln (T);

        Totload:= 0;
        reset (Msgtxtf, 1);
        seek (Msgtxtf, Mheader.pointer-1);
        repeat
            blockread (Msgtxtf, S [0], 1);
            blockread (Msgtxtf, S [1], ord (S [0] ) );
            Lasterror := ioresult;
            if (Lasterror <> 0) then
            begin
                Sysoplog ('error loading message text.');
                Totload := Mheader.Textsize;
            end; { if }

            inc (Totload, length (S) + 1);
            if B then
                S:= Stripcolor (S);
            if S [length (S) ] = #29 then
            begin
                dec (S [0] );
                write (T, S);
            end { if }
            else
                writeln (T, S);
        until (Totload>= Mheader.Textsize);
        writeln (T);
        close (Msgtxtf);
        close (T);
        Print (^M^J'Message extracted.'^M^J);
    end; { if }
    Lasterror := ioresult;
end; { ? }

{bluewolf}
function MsgHeaderMCI(const s:astr; Data1, Data2:Pointer):string;
var
  i:integer;
  u:userrec;
  MsgHeaderPtr: ^MHeaderRec;
begin

  MsgHeaderPtr := Data1;
  MsgHeaderMCI := s;
{
  case s[1] of
    'X':case s[2] of
          'A':MsgHeaderMCI := BBSListPtr^.xA;
          'B':MsgHeaderMCI := BBSListPtr^.xB;
          'C':MsgHeaderMCI := BBSListPtr^.xC;
          'D':MsgHeaderMCI := BBSListPtr^.xD;
          'E':MsgHeaderMCI := BBSListPtr^.xE;
          'F':MsgHeaderMCI := BBSListPtr^.xF;
        end;
    'B':if (s[2] = 'N') then
          MsgHeaderMCI := BBSListPtr^.BBSName;
    'D':case s[2] of
         'A':MsgHeaderMCI := pd2date(BBSListPtr^.DateAdded);
         'E':MsgHeaderMCI := pd2date(BBSListPtr^.DateEdited);
         'S':MsgHeaderMCI := BBSListPtr^.Description;
         '2':MsgHeaderMCI := BBSListPtr^.Description2
        end;
    'P':if (s[2] = 'N') then MsgHeaderMCI := BBSListPtr^.PhoneNumber;
    'R':case s[2] of
         'N':MsgHeaderMCI := IntToStr(BBSListPtr^.RecordNum);
        end;
    'S':case s[2] of
         'N':MsgHeaderMCI := BBSListPtr^.SysOpName;
         'P':MsgHeaderMCI := BBSListPtr^.Speed;
         'W':MsgHeaderMCI := BBSListPtr^.Software;
        end;
    'T':case s[2] of
         'N':MsgHeaderMCI := BBSListPtr^.TelnetUrl;
        end;
    'U':if (s[2] = 'N') then
          begin
            loadurec(u, BBSListPtr^.UserID);
            MsgHeaderMCI := u.name;
          end;
    'W':case s[2] of
           'S' : MsgHeaderMCI := BBSListPtr^.WebSiteUrl;
        end;
  end;
}
end;

{bluewolf}
function Headerline(var Mhead: Mheaderrec; Mnum, Tnum: word; line: byte): string;
var
    Pub, Seeanon: boolean;
    S, S1: string;
    I: byte;
begin
   {bluewolf getting ready to export this}
   {if not ReadBuffer(fstring.msgheader) then exit;}
   {DisplayBuffer(BBSListMCI, @BBSList, Junk);}

    with Mhead do begin

        Pub:= (Readboard<>-1);
        if (Pub) then Seeanon := (Aacs (General.Anonpubread) or Msgsysop)
        else Seeanon := Aacs (General.Anonprivread);

        if (From.Anon = 2) then Seeanon := Cosysop;

        S:= '';

        case line of

            1 : begin {date and number}

                    if (Fileattached > 0) then Irt := Stripname(Subject)
                    else Irt := Subject;

                    if ((From.Anon = 0) or (Seeanon)) then Lastauthor := From.Usernum
                    else Lastauthor := 0;

                    if ((From.Anon = 0) or (Seeanon) ) then S:= Pdt2Dat (Date, Dayofweek)
                    else S:= '[Unknown]';

                    S := '^1Date: ^9'+ S;
                    S := Mln (S, 39) + '^1Number : ^9'+ Cstr (Mnum) + '^1 of ^9'+ Cstr (Tnum);

                end; { case label }

            2 : begin{from and base}
                    S1:= From.A1S;
                    if (Pub) and (Mbrealname in Memboard.Mbstat) then S1:= From.real;
                    S:= '^1From: ^5'+ Caps (Usename (From.Anon, S1) );
                    if (not Pub) and (Netmail in Status) then begin
                        S := S + '^2 (' + Cstr (From.Zone) + ':' +
                        Cstr (From.Net)  + '/' +
                        Cstr (From.Node);
                        if (From.Point > 0) then S := S + '.' + Cstr (From.Point);
                        S := S + ')';
                    end; { if }

                    S:= Mln (S, 38) + '^1 Base   : ^5';
                    if (Lennmci (Memboard.name) > 30) then S := S + Mln(Memboard.name, 30)
                    else S := S + Memboard.name;
                end; { case label }
            3 : begin
                    if (Pub) and (Mbrealname in Memboard.Mbstat) then S1:= Caps (Mto.real)
                    else S1 := Caps (Mto.A1S);
                    S:= '^1To  : ^5'+ Usename (Mto.Anon, S1);
                    if (not Pub) and (Netmail in Status) then begin
                        S := S + '^2 (' + Cstr (Mto.Zone) + ':' +
                        Cstr (Mto.Net)  + '/' +
                        Cstr (Mto.Node);
                        if (Mto.Point > 0) then S := S + '.' + Cstr (Mto.Point);
                        S := S + ')';
                    end; { if }
                    S:= Mln (S, 38) + '^1 Refer #: ^5';
                    if (Replyto > 0) and (Replyto < Mnum) then S:= S+ Cstr (Mnum-Replyto)
                    else S := S+ 'None';
                end; { case label }
            4 : begin
                    S:= '^1Subj: ';
                    if (Fileattached = 0) then S := S + '^5' + Subject
                    else S := S + '^8' + Stripname (Subject);

                    S:= Mln (S, 38) + '^1 Replies: ^5';

                    if (Replies<> 0) then S:= S+ Cstr (Replies)
                    else S := S+ 'None';
                end; { case label }

            5 : begin
                    S := '^1Stat: ^';
                    if (Mdeleted in Status) then S:= S+ '8Deleted'
                    else
                     if (Prvt in Status) then S:= S+ '8Private'
                    else
                     if (Unvalidated in Status) then S:= S+ '8Unvalidated'
                    else
                     if ((Pub) and (Permanent in Status)) then S:= S+ '5Permanent'
                    else
                     if (Memboard.Mbtype<> 0) then
                      if (Sent in Status) then S:= S+ '5Sent'
                      else S:= S+ '5Unsent'
                    else S:= S+ '5Normal';

                    if (not Pub) and (Netmail in Status) then S:= S+ ' Netmail';

                    S:= Mln (S, 39) + '^1Origin : ^5';
                    if (Origindate<> '') then S:= S+ Origindate
                    else S:= S+ 'Local';
                end; { case label }

            6 : begin
                  if ((Seeanon) and ((Mto.Anon + From.Anon) > 0) and (Memboard.Mbtype = 0) ) then begin
                     S := '^1Real: ^5';
                     if (Mbrealname in Memboard.Mbstat) then S:= S+ Caps(From.real)
                     else S:= S+ Caps (From.name);
                     S:= S+ '^1 to ^5';
                     if (Mbrealname in Memboard.Mbstat) then S := S+ Caps(Mto.real)
                     else S:= S+Caps (Mto.name);
                  end; { if }
                end; { case label }
        end; { case }
    end; { with }
    Headerline := S;
end; { ? }

{replace with old stuff}

{ anum=actual, mnum=M#/t# <-displayed, tnum=m#/T# <- max? }

procedure Readmsg (Anum, Mnum, Tnum: word);
var
    Mheader: Mheaderrec;
    S: string;
    Totload, I: word;
    Dok, Kabort: boolean;
    Tooktime: longint;
    F: file;

begin
    Allowabort := (Cosysop) or not (Mbforceread in Memboard.Mbstat);

    Allowcontinue := true;

    with Mheader do begin
        Loadheader (Anum, Mheader);
        if ( (Mdeleted in Status) or (Unvalidated in Status) ) and
           not (Cosysop or Fromyou (Mheader) or Toyou (Mheader) ) then exit;

        Abort:= false;
        Next:= false;

        for I := 1 to 6 do begin
            S:= Headerline (Mheader, Mnum, Tnum, I);
            if (I <> 2) then Mciallowed := (Allowmci in Status); { allowit in base name }
            if S <> '' then
                Printacr (S); {blah matrix stuff: bluewolf}
            Mciallowed := true;
        end; { for }

        Nl;
        reset (Msgtxtf, 1);
        if (ioresult <> 0) then begin
            Sysoplog ('error accessing message text.');
            Allowabort := true;
            exit;
        end; { if }

        if (not Abort) then begin
            Reading_A_Msg:= true;
            Mciallowed:= (Allowmci in Status);
            Totload:= 0;
            Abort:= false;
            Next:= false;
            Usercolor (Memboard.Text_Color);
            if Textsize > 0 then
                if (pointer- 1+ Textsize<= filesize (Msgtxtf) ) and (pointer> 0) then begin
                    seek (Msgtxtf, Mheader.pointer- 1);
                    repeat
                        blockread (Msgtxtf, S [0], 1);
                        blockread (Msgtxtf, S [1], ord (S [0] ) );
                        Lasterror := ioresult;
                        if (Lasterror <> 0) then begin
                            Sysoplog ('error loading message text.');
                            Totload := Mheader.Textsize;
                        end; { if }
                        inc (Totload, length (S) + 1);
                        if (' * Origin: ' = copy (S, 1, 11) ) then S := '^' + Cstr (Memboard.Origin_Color) + S
                        else
                        if ('---'= copy (S, 1, 3) ) and ( (length (S) = 3) or (S [4] <> '-') ) then
                           S:= '^' + Cstr (Memboard.Tear_Color) + S
                        else
                        if (pos ('> ', copy (S, 1, 5) ) > 0) then
                            S:= '^'+ Cstr (Memboard.Quote_Color) + S+ '^'+ Cstr (Memboard.Text_Color)
                        else
                        if pos (#254, copy (S, 1, 5) ) > 0 then
                           S:= '^'+ Cstr (Memboard.Tear_Color) + S;
                        Printacr (S);
                    until (Totload>= Textsize) or (Abort);
                end; { if }
            Mciallowed:= true;
            Reading_A_Msg:= false;
            if (Dosansion) then Redrawforansi;
        end; { if }
        close (Msgtxtf);
    end; { with }

    Lasterror := ioresult;

    if (Mheader.Fileattached > 0) and Exist (Mheader.Subject) then begin

        Print (^M^J'^4The following has been attached:');
        findfirst (Mheader.Subject, anyfile- directory- volumeid, Dirinfo);
        if (doserror = 0) then begin
            Printacr (^M^J'^4Filename.Ext Bytes   hh:mm:ss');
            Printacr ('------------ ------- --------');
            I := 0;
            while (doserror = 0) do begin
                Printacr ('^5' + Align (Dirinfo.name) + ' ^4'+Mrn(Cstr(Dirinfo.size), 7)+' ^7'+Ctim(Dirinfo.size div Rate));
                findnext (Dirinfo);
                inc (I, Dirinfo.size div Rate);
            end; { while }
            Nl;
            if (Incom) and (I <= Nsl) and Pynq ('Download now? ') then begin
                I := Fileboard;
                Fileboard := - 1;
                Send (Mheader.Subject, false, false, Dok, Kabort, false, Tooktime);
                if (Dok) and (not Kabort) then
                       Ssm(Mheader.From.Usernum,Caps(Thisuser.name)+' downloaded '+Stripname(Mheader.Subject));
                Fileboard := I;
            end { if }
            else
                if (not Incom) and (Cosysop) and (Pynq ('Move file(s)? ') ) then begin
                    Prt (^M^J'Enter path to move file(s) to: ');
                    input (S, 40);
                    if (S <> '') then begin
                        if ( (S [length (S) ] ) <> '\') then S := S + '\';
                        S := S + Stripname (Mheader.Subject);
                        Movefile (Dok, Kabort, false, Mheader.Subject, S);
                    end; { if }
                end { if }
                else
                    if (Incom) and (I > Nsl) then Print ('Insufficient time for download.'^M^J);
        end { if }
        else Print ('Nothing.'^M^J);
    end; { if }

  Allowabort := true;
  Temppause := (Pause in Thisuser.flags);
end; { ? }


end.
