Program BBSList_Patch;
Uses CRT;
Type

  OldBBSListRec=                        { *.BBS file records }
    record
      PhoneNumber:string[20];        { Phone number of BBS }
      BBSName,                       { Name of BBS }
      SysOpName:string[30];          { SysOp of BBS }
      Description:string[60];        { Description of BBS }
      Software,                      { Software used by BBS }
      Speed:string[8];               { Highest connect speed of BBS }
      DateAdded,                     { Date entry was added }
      DateEdited:longint;            { Date entry was last edited }
      UserID,                        { User ID of person adding this }
      Next:longint;                  { Next Record # }
      Reserved:array[1..78] of byte; { Reserved }
    end;

  { this will be the new bbs record }
  BBSListRec=                  { *.BBS file records }
  {$IFDEF WIN32} packed {$ENDIF} record
      RecordNum   :longint;    { Number of the Record For Edit }
      UserID      :longInt;    { User ID of person adding this }
      BBSName     :string[30]; { Name of BBS                   }
      SysOpName   :string[30]; { SysOp of BBS                  }
      TelnetUrl   :string[60]; { Telnet Urls                   }
      WebSiteUrl  :string[60]; { Web Site Url                  }
      PhoneNumber :string[20]; { Phone number of BBS           }
      Software    :string[8];  { Software used by BBS          }
      Speed       :string[8];  { Highest connect speed of BBS  }
      Description :string[60]; { Description of BBS            }
      Description2:string[60]; { Second line of descrition     }
      DateAdded   :longint;    { Date entry was added          }
      DateEdited  :longint;    { Date entry was last edited    }
      Next        :longint;    { not done yet                  }
      Prev        :longint;    { not done yet                  }
      xa          :string[8];  { sysop definable A             }
      xb          :string[30]; { sysop definable B             }
      xc          :string[30]; { sysop definable C             }
      xd          :string[40]; { sysop definable D             }
      xe          :string[60]; { sysop definable E             }
      xf          :string[60]; { sysop definable F             }
   end;

var
  OldBBSList  : OldBBSListRec;
  OldBBSListF : File of OldBBSListRec;
  BBSList     : BBSListRec;
  BBSListF    : File of BBSListRec;
  RGDataPath  : String;
  OnRec       : Longint;

Begin

  clrscr;
  writeln;
  writeln('BBSList.dat patch/update utility');
  writeln('-');
    write('-Where is your renegade data path:');readln(RGDataPath);
  writeln('-Working...');
  if RGDatapath <> '' then begin
     if RGDataPath[Length(RGDataPath)] <> '\' then RGDataPath := RGDataPath + '\';
  end;

  assign(OldBBSListF,RGDataPath + 'bbslist.dat');
  {$I-}reset(OldBBSListF);{$I+}
  if ioresult <> 0 then begin
     writeln('-Error Accessing BBSList.dat');
     halt;
  end;


  assign(BBSListF,RGDataPath + 'bbslist.new');
  {$I-}rewrite(BBSListF);{$I+}
  if ioresult <> 0 then begin
     writeln('-Error Accessing BBSList.new');
     halt;
  end;

 OnRec := 0;
 While OnRec <> FileSize(OldBBSListF) do begin

       seek(OldBBSListF,OnRec);
       read(OldBBSListF,OldBBSList);

       FillChar(BBSList,SizeOf(BBSList),#0);
       with OldBBSList do begin
            BBSList.RecordNum    := OnRec;
            BBSList.UserID       := UserID;
            BBSList.BBSName      := BBSName;
            BBSList.SysOpName    := SysOpName;
            BBSList.TelnetUrl    := '';
            BBSList.WebSiteUrl   := '';
            BBSList.PhoneNumber  := PhoneNumber;
            BBSList.Software     := Software;
            BBSList.Speed        := Speed;
            BBSList.Description  := Description;
            BBSList.Description2 := '';
            BBSList.DateAdded    := DateAdded;
            BBSList.DateEdited   := DateEdited;
            BBSList.Next         := 0;
            BBSList.Prev         := 0;
            BBSList.xa           := '';
            BBSList.xb           := '';
            BBSList.xc           := '';
            BBSList.xd           := '';
            BBSList.xe           := '';
            BBSList.xf           := '';
       end;{with}

       seek(BBSListF,OnRec);
       write(BBSListF,BBSList);

       writeln('-Records #:',OnRec+1,' of ',filesize(oldbbslistf),' convertted ');

       Inc(OnRec);

 end;{while}

       writeln('- done convertting');
       close(oldbbslistf);
       close(bbslistf);

       writeln('startting to rename the files');

       rename(oldbbslistf,RGDataPath+'bbslist.old');
       rename(bbslistf,RGDataPath+'bbslist.dat');

       writeln('-Renamed BBSList.dat -> bbslist.old');
       writeln('-Renamed BBSList.new -> bbslist.dat');
       writeln('-all done.. ;) ');

End.