UNIT BWSTRUCT;
(*****************************************************************************)
(*                                                                           *)
(*           The Blue Wave Offline Mail System Packet Structures             *)
(*     Copyright 1990-1994 by George Hatchew and Cutting Edge Computing      *)
(*                 All rights reserved - FidoNet 1:2240/176                  *)
(*                                                                           *)
(*                     Last Updated - December 26, 1993                      *)
(*                                                                           *)
(*        ---------------------------------------------------------          *)
(*            DISTRIBUTION OF THIS FILE IS LIMITED BY THE TERMS              *)
(*           SPECIFIED IN THE BLUE WAVE STRUCTURE DOCUMENTATION!             *)
(*        ---------------------------------------------------------          *)
(*                                                                           *)
(*   NOTE:  Refer to BLUEWAVE.H and the Blue Wave structure documentation    *)
(*          for additional comments and information.                         *)
(*                                                                           *)
(*****************************************************************************)

INTERFACE

CONST
  ORIGINAL_INF_HEADER_LEN=1230;   { Original *.INF header len   }
  ORIGINAL_INF_AREA_LEN=80;       { Original *.INF area rec len }
  ORIGINAL_MIX_STRUCT_LEN=14;     { Original *.MIX record len   }
  ORIGINAL_FTI_STRUCT_LEN=186;    { Original *.FTI record len   }

  Inf_FListNone  = 0;             { Door does not generate a list file  }
  Inf_FListText  = 1;             { Door generates plain text list file }
  Inf_FListAnsi  = 2;             { Door generates ANSI list file       }


TYPE

   Char4  = Array[1..4]  OF Char;
   Char6  = Array[1..6]  OF Char;
   Char9  = Array[1..9]  OF Char;
   Char10 = Array[1..10] OF Char;
   Char13 = Array[1..13] OF Char;
   Char16 = Array[1..16] OF Char;
   Char20 = Array[1..20] OF Char;
   Char21 = Array[1..21] OF Char;
   Char36 = Array[1..36] OF Char;
   Char41 = Array[1..41] OF Char;
   Char43 = Array[1..43] OF Char;
   Char44 = Array[1..44] OF Char;
   Char50 = Array[1..50] OF Char;
   Char65 = Array[1..65] OF Char;
   Char72 = Array[1..72] OF Char;
   Char78 = Array[1..78] OF Char;
   Char80 = Array[1..80] OF Char;

(*
**  Name of file:   *.INF
**
**  Description:    The *.INF file is the source of information for just about
**                  everything from the host BBS, as well as definitions for
**                  all of the message areas that are available to the user
**                  and their status (Local, EchoMail, NetMail, Read Only,
**                  etc.).
**
**  File format:    INF_HEADER          { only included one time!        }
**                  INF_AREA_INFO       { repeated for as many msg bases }
**                  INF_AREA_INFO       { as are available to the user   }
**                  ...
*)

   Inf_UFlags =
      (Inf_Hotkeys,         { User uses "hotkeys" in door prompts   }
       Inf_Xpert,           { Short menus displayed in door         }
       Inf_UFlagRes1,       { RESERVED FOR FUTURE USE               }
       Inf_Graphics,        { Enable ANSI control sequences in door }
       Inf_NotMyMail,       { Do not bundle mail from user          }
       Inf_ExtInfo,         { RESERVED FOR FUTURE USE               }
       Inf_NumericExt,      { RESERVED FOR FUTURE USE               }
       Inf_UFlagRes4,       { RESERVED FOR FUTURE USE               }
       Inf_UFlagRes5,       { RESERVED FOR FUTURE USE               }
       Inf_UFlagRes6,       { RESERVED FOR FUTURE USE               }
       Inf_UFlagRes7,       { RESERVED FOR FUTURE USE               }
       Inf_UFlagRes8,       { RESERVED FOR FUTURE USE               }
       Inf_UFlagRes9,       { RESERVED FOR FUTURE USE               }
       Inf_UFlagRes10,      { RESERVED FOR FUTURE USE               }
       Inf_UFlagRes11,      { RESERVED FOR FUTURE USE               }
       Inf_UFlagReS12);     { RESERVED FOR FUTURE USE               }

   Inf_NetmailFlags =
      (Inf_NetmailRes1,     { RESERVED FOR FUTURE USE     }
       Inf_Crash,           { Allow Crash status          }
       Inf_NetmailRes2,     { RESERVED FOR FUTURE USE     }
       Inf_NetmailRes3,     { RESERVED FOR FUTURE USE     }
       Inf_Attach,          { Allow File Attach messages  }
       Inf_NetmailRes4,     { RESERVED FOR FUTURE USE     }
       Inf_NetmailRes5,     { RESERVED FOR FUTURE USE     }
       Inf_KillSent,        { Allow Kill/Sent status      }
       Inf_NetmailRes6,     { RESERVED FOR FUTURE USE     }
       Inf_Hold,            { Allow Hold status           }
       Inf_Imm,             { Allow Immediate status      }
       Inf_FREQ,            { Allow File Request messages }
       Inf_Direct,          { Allow Direct status         }
       Inf_NetmailRes7,     { RESERVED FOR FUTURE USE     }
       Inf_NetmailRes8,     { RESERVED FOR FUTURE USE     }
       Inf_UpdREQ);         { Update Request              }

   Inf_CtrlFlags =
      (Inf_NoConfig,        { Do not allow offline configuration }
       Inf_NoFreq,          { Do not allow file requests }
       Inf_CtrlRes3,
       Inf_CtrlRes4,
       Inf_CtrlRes5,
       Inf_CtrlRes6,
       Inf_CtrlRes7,
       Inf_CtrlRes8,
       Inf_CtrlRes9,
       Inf_CtrlRes10,
       Inf_CtrlRes11,
       Inf_CtrlRes12,
       Inf_CtrlRes13,
       Inf_CtrlRes14,
       Inf_CtrlRes15,
       Inf_CtrlRes16);

   Inf_Header = RECORD
      BwVersion     : Byte;          { Packet version type (currently 2)        }
      ReaderFiles   : Array[1..5] OF { Files to be displayed by reader          }
                      Char13;
      RegNum        : Char9;         { User's registration number               }
      MashType      : Byte;          { Currently unused (door fills with 0)     }
                                     { Reserved for Blue Wave reader to store }
                                     { the compression type the packet uses.  }
      UserName      : Char43;        { Name user types at BBS login             }
      UserAlias     : Char43;        { User's "other" name                      }
      Password      : Char21;        { Password - Encrypted + 10                }
      PasswordUsage : Byte;          { Password type                            }
                                     {   0=none 1=door 2=reader 3=both          }
      Zone,                          { Main network address of host BBS         }
      Net,                           {   (zone:net/node.point)                  }
      Node,
      Point         : Word;
      Sysop         : Char41;        { Name of SysOp of host BBS                }
      CtrlFlags     : SET OF
                      Inf_CtrlFlags;
      SystemName    : Char65;        { Name of host BBS                         }
      MaxFREQs      : Byte;          { Max number of file requests allowed      }
      IsQwk         : Word;          { *.INF belongs to QWK packet }
      Obsolete2     : Char4;
      uFlags        : SET OF         { Bit-mapped door options/toggles          }
                      Inf_UFlags;
      Keywords      : Array[1..10]   { User's entire set of door keywords       }
                      OF Char21;
      Filters       : Array[1..10]   { User's entire set of door filters        }
                      OF Char21;
      Macros        : Array[1..3]    { User's door bundling command macros      }
                      OF Char80;
      NetmailFlags  : SET OF         { Bit-mapped NetMail options               }
                      Inf_NetmailFlags;
      Credits,                       { NetMail credits                          }
      Debits        : Word;          { NetMail debits                           }
      CanForward    : Boolean;       { 0=Message forwarding not allowed         }
      InfHeaderLen,                  { Size of INF_HEADER structure             }
      InfAreaLen,                    { Size of INF_AREA_INFO structure          }
      MixLen,                        { Size of MIX_REC structure                }
      FtiLen        : Word;          { Size of FTI_REC structure                }
      UsesUPLFile   : Boolean;       { If this field is not zero, door uses UPL }
      FromToLen,                     { The maximum length of the FROM: and TO:  }
                                     { fields. [Maximum = 35]                 }
      SubjectLen    : Byte;          { The maximum length of the SUBJECT: field }
                                     { [Maximum = 71]                         }
      PacketID      : Char9;         { Original root name of the mail packet }
      FileListType  : Byte;          { File listing type }
      AutoMacro     : Array[1..3] of Boolean;
      MaxPacketSize : Word;
      Reserved      : Array[1..228]  { RESERVED FOR FUTURE USE - Fill w/#0 }
                      OF Byte;
   END;


   Inf_AreaFlags =
      (Inf_Scanning,         { On=User is active for area               }
       Inf_Alias,            { On=Alias name, Off=Login name            }
       Inf_AnyName,          { On=Allow any name to be entered          }
       Inf_EchoArea,         { On=Network area, Off=Local area          }
       Inf_Netmail,          { On=Private network mail                  }
       Inf_Post,             { On=User can post, Off=User CANNOT post   }
       Inf_NoPrivate,        { On=Private messages are NOT allowed      }
       Inf_NoPublic,         { On=Public messages are NOT allowed       }
       Inf_NoTagline,        { On=Taglines are not allowed              }
       Inf_NoHighBit,        { On=ASCII 1-127 only, Off=ASCII 1-255     }
       Inf_NoEcho,           { On=User can prevent msgs from echoing    }
       Inf_HasFile);         { On=User can attach files to messages     }


   Inf_NetworkTypes =
      (Inf_NetFidoNet,        { 0=Set up for FidoNet-style network mail  }
       Inf_NetInternet);      { 1=Set up for Internet/Uuusenet mail      }


   Inf_AreaInfo = RECORD
      AreaNum   : Char6;              { Area number this record corresponds to  }
      EchoTag   : Char21;             { Area tag name (*.BRD name for Telegard) }
      Title     : Char50;             { Area description/title                  }
      AreaFlags : SET OF              { Bit-mapped area options                 }
                  Inf_AreaFlags;
      network_type:Inf_NetworkTypes;  { Network mail type (if INF_ECHO set)   }
                                      { If INF_ECHO is OFF, then this field   }
                                      { can be ignored.                       }
   END;


(*---------------------------------------------------------------------------*)

(*
**  Name of file:   *.FTI
**
**  Description:    The *.FTI file contains the information for each message
**                  in the packet.  Each record includes all of the
**                  information about the message, including the pointer to
**                  the actual message text in the *.DAT file.
**
**                  NOTE:   Messages in the *.FTI file will ALWAYS be in area
**                          number order.  That is to say, if the MIX_REC
**                          indicates there are 100 messages for this area,
**                          all 100 messages will follow in sequential order.
**
**  File format:    FTI_REC     { repeated for as many messages }
**                  FTI_REC     { as obtained from the host BBS }
**                  ...
*)

   Fti_Flags =
      (Fti_MsgPrivate,       { Private = For addressee ONLY         }
       Fti_MsgCrash,         { Crash = High priority mail           }
       Fti_MsgRead,          { Read = Message read by addressee     }
       Fti_MsgSent,          { Sent = Message sent                  }
       Fti_MsgFile,          { File Attach = Send file(s)           }
       Fti_MsgFWD,           { Forward = Message to/from others     }
       Fti_MsgOrphan,        { Orphan = Message destination unknown }
       Fti_MsgKill,          { Kill/Sent = Delete after sending     }
       Fti_MsgLocal,         { Local = Message originated here      }
       Fti_MsgHold,          { Hold = Hold for pickup, don't send   }
       Fti_MsgImmediate,     { Immediate = Send message NOW         }
       Fti_MsgFREQ,          { File Request = Request file(s)       }
       Fti_MsgDirect,        { Direct = Send direct, no routing     }
       Fti_MsgUnused1,       {                                      }
       Fti_MsgUnused2,       {                                      }
       Fti_MsgUPDREQ);       { Update Request = Req updated file(s) }


   FtiRec = RECORD
      MFrom,                 { Person message is from                       }
      MTo      : Char36;     { Person message is to                         }
      Subject  : Char72;     { Subject/title of message                     }
      Date     : Char20;     { Origin date of message                       }
      MsgNum,                { Number of THIS message on BBS                }
      ReplyTo,               { "This is a reply to #xx"                     }
      ReplyAt  : Word;       { "There is a reply at #xx"                    }
      MsgPtr,                { Offset to start of message in *.DAT file     }
      MsgSize  : LongInt;    { Length of message text (in bytes)            }
      Flags    : SET OF      { Bit-mapped message status flags              }
                 Fti_Flags;
      OrigZone,              { Origin address of message                    }
      OrigNet,               {   These three fields will most likely be 0,  }
      OrigNode : Word;       {   unless the current message is netmail.     }
   END;


(*---------------------------------------------------------------------------*)

(*
**  Name of file:   *.MIX
**
**  Description:    The *.MIX file is a very small file, with one record for
**                  every message area that was scanned.  It contains the
**                  information to get into the *.FTI file.
**
**  File format:    MIX_REC     { repeated for each message area scanned }
**                  MIX_REC
**                  ...
*)

   MixRec = RECORD
      AreaNum     : Char6;   { Area number on host BBS                    }
      NumMsgs,               { Number of messages for this area           }
      NumPersonal : Word;    { Number of personal messages in this area   }
      HdrPtr      : LongInt; { Pointer to first message header .FTI file  }
   END;


(*
**  Name of file:   *.MSG
**
**  Description:    The Fido *.MSG message (named for the BBS program on which
**                  it originated) has become a de-facto standard among BBS
**                  implementations, due to the sheer number of utilities
**                  available that operate with *.MSG messages.  It is as
**                  close to a universal message format as one can get in
**                  FidoNet (and FidoNet-style networks), and is the reason
**                  why it is used here (well, the *.MSG header, anyway).
**
**                  NOTE:   Most of the fields in the FTI_REC structure (shown
**                          above) correspond to similar fields in MSG_REC.
**                          This was done deliberately, in order to make
**                          *.FTI file processing a little more intuitive for
**                          programmers.  Also note that MSG_REC is only used
**                          by the NET_REC structure, which will soon become
**                          obsolete (replaced by UPL_REC).
**
**  File format:    MSG_REC         { only included one time!                }
**                  message text    { text can be terminated by an ASCII NUL }
**                                  { character (0x00), or by an ASCII CR,   }
**                                  { LF, NUL (0x0D 0x0A 0x00) sequence      }
*)

   MsgAttr =
      (MsgPrivate,          { Private                }
       MsgCrash,            { Crash mail             }
       MsgReceived,         { Received               }
       MsgSent,             { Sent                   }
       MsgFAttach,          { File attached          }
       MsgInTransit,        { In-transit             }
       MsgOrphan,           { Orphaned               }
       MsgKill,             { Kill after sending     }
       MsgLocal,            { Local message          }
       MsgHold,             { Hold for pickup        }
       MsgReserved,         { RESERVED               }
       MsgFReq,             { File request           }
       MsgRReq,             { Return receipt request }
       MsgReceipt,          { Return receipt message }
       MsgAuditReq,         { Audit request          }
       MsgUpdReq);          { File update request    }


   MsgRec = RECORD
      MFrom,               { Person message is from                         }
      MTo       : Char36;  { Person message is to                           }
      Subject   : Char72;  { Subject/title of message                       }
      Date      : Char20;  { Creation date/time                             }
      TimesRead,           { Number of times read (fairly obsolete)         }
      DestNode,            { Destination node (of net/node)                 }
      OrigNode,            { Origin node (of net/node)                      }
      Cost,                { Cost of sending message (usually in US cents)  }
      OrigNet,             { Origin net (of net/node)                       }
      DestNet   : Word;    { Destination net (of net/node)                  }
      unused1,             { Undefined                                      }
      unused2   : LongInt;
      Reply     : Word;    { Message # that this message replies to         }
      Attr      : SET OF   { Message attributes and behavior flags          }
                  MsgAttr;
      Up        : Word;    { Message # that replies to this message         }
end;


(*---------------------------------------------------------------------------*)

(*
**  Name of file:   *.XTI
**
**  Description:    The *.XTI file contains extended information for each
**                  message in the packet.  The number of records in the *.XTI
**                  file will always equal the number of messages in the
**                  packet, with each record corresponding to a record in the
**                  *.FTI file (i.e. record #1 in the *.XTI file corresponds
**                  to record #1 in the *.FTI file, and so on).
**
**                  NOTE:   This file is currently created ONLY by the Blue
**                          Wave reader, and is not a part of the official
**                          Blue Wave packet specification; it is merely
**                          documented here for third party programmers to use
**                          if they so desire.  How other readers store which
**                          messages have been read/replied-to/marked is left
**                          as an option to be implemented by the individual
**                          reader authors.  You may use this method if you so
**                          desire; however, PLEASE do not name any external
**                          files not conforming to this specification as
**                          <packet-ID>.XTI, due to the fact that the Blue
**                          Wave reader will expect the file to be in the
**                          format described.  If it's not in the expected
**                          format, things will get interesting. :-)
**
**  File format:    XTI_REC     { repeated for as many messages }
**                  XTI_REC     { as obtained from the host BBS }
**                  ...
*)

   XtiFlags =
      (Xti_HasRead,            { Message has been read }
       Xti_HasReplied,         { Message has been replied to }
       Xti_IsPersonal,         { Message is personal }
       Xti_IsTagged,           { Message has been tagged }
       Xti_HasSaved,           { Message has been saved }
       Xti_HasPrinted);        { Message has been printed }

   XtiMarks =
      (Xti_MarkSave,           { Message marked for saving   }
       Xti_MarkReply,          { Message marked for replying }
       Xti_MarkPrint,          { Message marked for printing }
       Xti_MarkDelete);        { Message marked for deletion }

   XtiRec = RECORD
      Flags : SET OF XtiFlags; { Bit-mapped message flags   }
      Marks : SET OF XtiMarks; { Bit-mapped message markers }
   END;


(*****************************************************************************)
(* >>>>>>>>>>>>>>>>>>>>  READER DATA FILE STRUCTURES  <<<<<<<<<<<<<<<<<<<<<< *)
(*****************************************************************************)


(*
**  Name of file:   *.NET
**
**  Description:    The *.NET file is created ONLY when there is NetMail to be
**                  sent.  It contains the FULL header of the Fido-style *.MSG
**                  structure plus the fields defined below (which aren't part
**                  of the standard *.MSG structure yet required by the door).
**
**  File format:    NET_REC     { repeated for as many NetMail    }
**                  NET_REC     { messages as exist in the packet }
**                  ...
*)


   NetRec = RECORD
      Msg     : MsgRec;      { The Fido-style *.MSG header                }
      FName   : Char13;      { Filename the message text is in            }
      EchoTag : Char21;      { NetMail area tag (*.BRD name for Telegard) }
      Zone,                  { Destination zone (of zone:net/node.point)  }
      Point   : Word;        { Destination point (of zone:net/node.point) }
      Date    : LongInt;     { Date/time of message                       }
   END;


(*---------------------------------------------------------------------------*)

(*
**  Name of file:   *.UPI
**
**  Description:    The *.UPI file contains the information for each message
**                  in the reply packet, as well as information on the reader
**                  version and registration numbers.  Each record includes
**                  all of the information about the message.
**
**  File format:    UPI_HEADER      { only included one time!        }
**                  UPI_REC         { repeated for as many msg bases }
**                  UPI_REC         { as are available to the user   }
**                  ...
*)

   UpiHeader = RECORD
      RegNum : Char9;        { Reader registration number                   }
      VerNum : Char13;       { Reader version number - Encrypted by + 10    }
      Future : Array[1..33]  { RESERVED FOR FUTURE USE                      }
               OF Byte;
   END;


   UpiFlags =
      (UpiRes1,          { RESERVED FOR FUTURE USE                   }
       UpiRes2,          { RESERVED FOR FUTURE USE                   }
       UpiRes3,          { RESERVED FOR FUTURE USE                   }
       UpiRes4,          { RESERVED FOR FUTURE USE                   }
       UpiRes5,          { RESERVED FOR FUTURE USE                   }
       UpiRes6,          { RESERVED FOR FUTURE USE                   }
       UpiPrivate,       { Message is PRIVATE                        }
       UpiNoEcho);       { Message is NOT to be echoed               }


   UpiRec = RECORD
      MFrom,                   { Person message is from                     }
      MTo       : Char36;      { Person message is to                       }
      Subject   : Char72;      { Subject/title of message                   }
      DateTime  : LongInt;     { Date/time of message                       }
      FName     : Char13;      { Filename the message text is in            }
      EchoTag   : Char21;      { Area tag name (*.BRD name for Telegard)    }
      Flags     : SET OF       { Bit-mapped flags                           }
                  UpiFlags;
      ReEdit    : Byte;        { INTERNAL USE ONLY!                         }
   END;


(*---------------------------------------------------------------------------*)

(*
**  Name of file:   *.UPL
**
**  Description:    The *.UPL file contains the information for each message
**                  in the reply packet, as well as information on the reader
**                  version and registration numbers.  Each record includes
**                  all of the information about the message.
**
**                  NOTE:   The *.UPL file is only generated by the Blue Wave
**                          reader version 2.11 and later.  *.UPL is intended
**                          to eventually replace the *.NET and *.UPI files,
**                          but door authors should code for the possibility
**                          of both instances (however, *.UPL should be used
**                          if present).
**
**  File format:    UPL_HEADER      { only included one time!       }
**                  UPL_REC         { repeated for as many messages }
**                  UPL_REC         { as are included in the packet }
**                  ...
*)

   UplHeader = RECORD
      RegNum     : Char10;    { Reader registration number (if desired)      }
      VerNum     : Char20;    { Reader version number - Encrypted + 10       }
      ReaderVer,              { Major version of the reader                  }
      ReaderRev  : Byte;      { Minor revision number of the reader          }
      ReaderName : Char80;    { String containing name of the reader         }
      UplHdrLen,              { Size of UPL_HEADER structure                 }
      UplRecLen  : Word;      { Size of UPL_REC structure                    }
      RealName   : Char44;    { Name found in InfHeader.LoginName            }
      UserName   : Char44;    { Name found in InfHeader.AliasName            }
      ReaderTear : Char16;    { String containing abbreviated name of the    }
                              { reader, such as "Blue Wave", "Q-Blue".     }
      Pad : Array[1..36] OF   { RESERVED FOR FUTURE USE, and to pad struct   }
            Byte              {   out to a 'nice' 256 bytes                  }
   END;


   UplMsgAttr =
     (UplInactive,         { Message is INACTIVE - Don't import        }
      UplPrivate,          { Message is PRIVATE                        }
      UplNoEcho,           { Message is NOT to be echoed               }
      UplHasFile,          { Message has file "attached" to it         }
      UplNetmail,          { Message is NetMail                        }
      UplMRes6,            { RESERVED FOR FUTURE USE                   }
      UplMRes7,            { RESERVED FOR FUTURE USE                   }
      UplMRes8,            { RESERVED FOR FUTURE USE                   }
      UplMRes9,            { RESERVED FOR FUTURE USE                   }
      UplMRes10,           { RESERVED FOR FUTURE USE                   }
      UplMRes11,           { RESERVED FOR FUTURE USE                   }
      UplMRes12,           { RESERVED FOR FUTURE USE                   }
      UplMRes13,           { RESERVED FOR FUTURE USE                   }
      UplMRes14,           { RESERVED FOR FUTURE USE                   }
      UplMRes15,           { RESERVED FOR FUTURE USE                   }
      UplMRes16);          { RESERVED FOR FUTURE USE                   }


   UplNetAttr =
      (UplNRes1,            { RESERVED FOR FUTURE USE             }
       UplCrash,            { Crash = High priority mail          }
       UplNRes2,            { RESERVED FOR FUTURE USE             }
       UplNRes3,            { RESERVED FOR FUTURE USE             }
       UplFile,             { File Attach = Send file(s) listed   }
       UplNRes4,            { RESERVED FOR FUTURE USE             }
       UplNRes5,            { RESERVED FOR FUTURE USE             }
       UplKillSent,         { Kill/Sent = Delete after sending    }
       UplLocal,            { Local = Message originated here     }
       UplHold,             { Hold = Hold for pickup, do not send }
       UplImmediate,        { Immediate = Send message NOW        }
       UplFREQ,             { File Request = Request file(s)      }
       UplNetDirect,        { Direct = Send direct, no routing    }
       UplNRes6,            { RESERVED FOR FUTURE USE             }
       UplNRes7,            { RESERVED FOR FUTURE USE             }
       UplUpdREQ);          { Update Request = Request updated    }


   UplRec = RECORD
      MFrom,                  { Person message is from                        }
      MTo        : Char36;    { Person message is to                          }
      Subject    : Char72;    { Subject/Title of message                      }
      DestZone,               { Destination zone of message (NetMail only)    }
      DestNet,                { Destination net of message (NetMail only)     }
      DestNode,               { Destination node of message (NetMail only)    }
      DestPoint  : Word;      { Destination point of message (NetMail only)   }
      MsgAttr    : SET OF     { Bit-mapped message attributes                 }
                   UplMsgAttr;
      NetAttr    : SET OF     { Bit-mapped NetMail message attributes         }
                   UplNetAttr;
      DateTime,               { Date/time of message                          }
      ReplyTo    : LongInt;   { This unsigned long word stores the message #  }
      FileName   : Char13;    { Filename the message text is in               }
      EchoTag    : Char21;    { Area tag the message goes in                  }
      AreaFlags  : Word;      { The Blue Wave Offline Mail Reader uses this   }
      FAttach    : Char13;    { If the UPL_HAS_FILE flag is set, this field   }
      UserDef : Array[1..7]   { User-defined storage.  Doors should ignore    }
                OF Byte;      {   this field, and reader authors should feel  }
                              {   free to utilize this field for their own    }
                              {   internal use, if necessary.                 }
      NetDest : Array[1..100] { Network destination address                   }
                OF Char;      {   If the message is for a non-FidoNet network }
                              {   message area, this field will contain the   }
                              {   ASCII representation of the destination     }
                              {   address.                                    }
   END;


(*---------------------------------------------------------------------------*)

(*
**  Name of file:   *.REQ
**
**  Description:    The *.REQ file is simply a list of filenames the user
**                  wants to request from the host BBS.  Wildcard characters
**                  ("*" and "?" under MS-DOS) are allowed, but are not
**                  guaranteed to produce accurate results on all door
**                  implementations.
**
**                  NOTE:   Current Blue Wave doors do not accept wildcard
**                          characters in filenames, and will consider any
**                          filenames which contain them as being invalid.
**                          Additionally, if there are more than 10 entries in
**                          the *.REQ file, current Blue Wave doors will read
**                          the first 10 and discard the rest.  These are
**                          limitations of the Blue Wave doors, not of the
**                          Blue Wave format itself.
**
**  File format:    REQ_REC     { repeated for as many files as }
**                  REQ_REC     { requested from the host BBS   }
**                  ...
*)


   ReqRec = RECORD
      FileName : Char13;        { Name of file to request }
   END;


(*---------------------------------------------------------------------------*)

(*
**  Name of file:   *.PDQ
**
**  Description:    The *.PDQ file contains the information used for the
**                  offline configuration feature of the mail door.  After the
**                  header is a series of records which indicate the message
**                  areas to enable for scanning the next time a mail packet
**                  is requested.
**
**                  NOTE:   If the AREA_CHANGES flag in PDQ_HEADER.FLAGS is
**                          set, the door should process the offline
**                          configuration as well as changes to the list of
**                          areas the user wants to download.  In the Blue
**                          Wave door, this is done by first turning OFF all
**                          message areas that were active, then turning ON
**                          the ones specified in the *.PDQ file.  This seems
**                          to be the simplest, most straight-forward method
**                          of accomplishing this task, though other, more
**                          complex schemes could easily have been devised.
**
**  File format:    PDQ_HEADER      { only included one time!
**                  PDQ_REC         { repeated for as many message areas }
**                  PDQ_REC         { as the user wishes to enable       }
**                  ...
*)


   PdqFlags =
      (PdqHotkeys,          { Toggle "hotkeys" in prompts        }
       PdqXpert,            { Toggle expert mode (menu displays) }
       PdqAreaChanges,      { Change active message areas        }
       PdqGraphics,         { Toggle IBM 8-bit ASCII characters  }
       PdqNotMyMail,        { Toggle bundling mail from user     }
       PdqReserved1,        { RESERVED FOR FUTURE USE            }
       PdqReserved2,        { RESERVED FOR FUTURE USE            }
       PdqReserved3,        { RESERVED FOR FUTURE USE            }
       PdqReserved4,        { RESERVED FOR FUTURE USE            }
       PdqReserved5,        { RESERVED FOR FUTURE USE            }
       PdqReserved6,        { RESERVED FOR FUTURE USE            }
       PdqReserved7,        { RESERVED FOR FUTURE USE            }
       PdqReserved8,        { RESERVED FOR FUTURE USE            }
       PdqReserved9,        { RESERVED FOR FUTURE USE            }
       PdqReserved10,       { RESERVED FOR FUTURE USE            }
       PdqReserved11);      { RESERVED FOR FUTURE USE            }


   PdqRec = RECORD
      Keywords : Array[1..10]       { User's entire set of door keywords  }
                 OF Char21;
      Filters  : Array[1..10]       { User's entire set of door filters   }
                 OF Char21;
      Macros   : Array[1..3]        { User's door bundling command macros }
                 OF Char78;
      Password : Char21;            { Password                            }
      PassType : Byte;              { Password type                       }
                                    {   0=none 1=door 2=reader 3=both     }
      Flags    : SET OF PdqFlags;   { Bit-mapped flags                    }
   END;


   PdqArea = RECORD
      EchoTag : Char21;           { Echo tag of message area to activate    }
   END;


{ Password/encryption stuff }
FUNCTION  DecryptPW(s:String):String;
FUNCTION  EncryptPW(s:String):String;


IMPLEMENTATION


FUNCTION EncryptPW(s:String):String;
VAR StrPos:Byte; TempStr:String;
BEGIN
    TempStr := s;
    FOR StrPos := 1 TO Length(TempStr) DO
       TempStr[StrPos] := Chr(Ord(TempStr[StrPos])+10);
    EncryptPW := TempStr;
END;


FUNCTION DecryptPW(s:String):String;
VAR StrPos:Byte; TempStr:String;
BEGIN
    TempStr := s;
    FOR StrPos := 1 TO Length(TempStr) DO
       TempStr[StrPos] := Chr(Ord(TempStr[StrPos])-10);
    DecryptPW := TempStr;
END;


END.

