UNIT Cursor;

(* 

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES CRT,DOS;

TYPE CursorType = (cmOn,cmOff,cmUnderline,cmHalf,cmBlock);

PROCEDURE SetCursor(Mode:CursorType);


IMPLEMENTATION


{$IFDEF OS2}

USES OS2BASE;

VAR CursOrig,CursNew:VioCursorInfo;

PROCEDURE SetCursor(Mode:CursorType);
BEGIN
   CursNew := CursOrig;
   CASE Mode OF
      cmOn        : ;
      cmOff       : CursNew.Attr := $FFFF;
      cmUnderline : CursNew.yStart := $0E;
      cmHalf      : CursNew.yStart := $07;
      cmBlock     : CursNew.yStart := $00;
   END;
   { CursNew.cEnd := 12 }
   VioSetCurType(CursNew,0);
END; { SetCursor (OS/2) }
{$ENDIF}


{$IFDEF DELPHI}
USES WINDOWS;

VAR  CursOrig,CursNew:TConsoleCursorInfo;

PROCEDURE SetCursor(Mode:CursorType);
BEGIN
   CursNew := CursOrig;
   CASE Mode OF
      cmOn        : CursNew.bVisible := TRUE;
      cmOff       : CursNew.bVisible := FALSE;
      cmUnderline : CursNew.dwSize := $0E;
      cmHalf      : CursNew.dwSize := $07;
      cmBlock     : CursNew.dwSize := $00;
   END;
   { CursNew.cEnd := 12 }
   SetConsoleCursorInfo(Handle_Output,CursNew);
END;
{$ENDIF}


{$IFDEF DOS}
PROCEDURE SetCursor(Mode:CursorType);
VAR Regs:Registers;
BEGIN   { SetCursor }
   Regs.Ah := $03;
   Intr($10,Regs);
   WITH Regs DO
    BEGIN
       CASE Mode OF
          cmOn : Ch := Ch and $1F;
          cmOff: Ch := Ch or $20;
          ELSE CASE Lastmode OF
             $07 : BEGIN
                CASE Mode OF
                   cmUnderline : Ch := $0B;
                   cmHalf      : Ch := $07;
                   cmBlock     : Ch := $00;
                END;  { Case Mode }
                Cl := $0C;
             END { $07 }
             ELSE BEGIN
                CASE Mode OF
                   cmUnderline : Ch := $06;
                   cmHalf      : Ch := $04;
                   cmBlock     : Ch := $00;
                END;  { Case Mode }
                Cl := $07;
             END;  { Else Case }
          END;  { Case Lastmode }
       END;  { Case Mode }
       Ah := $01;
     END;  { With Regs }
   Intr($10, Regs);
END;  { SetCursor }
{$ENDIF}


BEGIN
   {$IFDEF OS2}    VioGetCurType(CursOrig,0); {$ENDIF}
   {$IFDEF DELPHI} GetConsoleCursorInfo(Handle_Output,CursOrig); {$ENDIF}
END.
