Unit GInput1;

{ The GetInput function will get user input in a customized format.   }
{ You may change the record "UseFormat" to your suitings.             }

(* 

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

CONST
   { ASCII Codes }

   NUL = #0  {^@};   VT  = #11 {^K};  SYN = #22 {^V};  LArrow = #75;
   SOH = #1  {^A};   FF  = #12 {^L};  ETB = #23 {^W};  RArrow = #77;
   STX = #2  {^B};   CR  = #13 {^M};  CAN = #24 {^X};  TArrow = #72;
   ETX = #3  {^C};   SO  = #14 {^N};  EM  = #25 {^Y};  BArrow = #80;
   EOT = #4  {^D};   SI  = #15 {^O};  SUB = #26 {^Z};
   ENQ = #5  {^E};   DLE = #16 {^P};  ESC = #27     ;
   ACK = #6  {^F};   DC1 = #17 {^Q};  FS  = #28     ;
   BEL = #7  {^G};   DC2 = #18 {^R};  GS  = #29     ;
   BS  = #8  {^H};   DC3 = #19 {^S};  RS  = #30     ;
   HT  = #9  {^I};   DC4 = #20 {^T};  US  = #31     ;
   LF  = #10 {^J};   NAK = #21 {^U};  SP  = #32     ;

   { END }

TYPE
   WhichFormat = (Num,Letter,Chr,Scientific,Hex);

VAR
   UseFormat : Array[Num..Hex] of Char;
   UseSet : Set of Char;
   TheFormat : WhichFormat;
   ValidChars : Set of char;


FUNCTION GetInput(Format : String) : String;


IMPLEMENTATION

Uses CRT;


FUNCTION GetInput(Format : String) : String;

VAR
   CurrPos : Word;
   FinalStr : String;
   SetValid, TB : Boolean;
   TempCh : Char;
   CtrlCodes : Set of char;
   x, y : byte;
   Label 1;

Begin
   CurrPos := 1; FinalStr := Format;
   1: While CurrPos <= Length(Format) do begin
      Tb := False;
      Case FinalStr[CurrPos] of
         '#' : ValidChars := ['0'..'9'];
         'L' : ValidChars := ['A'..'Z','a'..'z'];
         '@' : ValidChars := [#32..#255];
         'H' : ValidChars := ['0'..'9','A'..'F','a'..'f'];
         Else Begin
            Write(FinalStr[CurrPos]);
            Inc(CurrPos);
            Goto 1;
         End;
      End;
      If NOT tb then
         Repeat
            TempCh := Readkey;
            If (TempCh in ValidChars) then Begin
               Write(TempCh);
               FinalStr[CurrPos] := TempCh;
               Inc(CurrPos);
            End;
         Until NOT (TempCh in ValidChars)
   End;
   GetInput := FinalStr;
End;

Begin
   UseFormat[Num] := '#';
   UseFormat[Letter] := 'L';
   UseFormat[Chr] := '@';
   UseFormat[Scientific] := 'N';
   UseFormat[Hex] := 'H';
   UseSet := ['#','L','@','N','H'];
   TheFormat := Num;
End.





