UNIT MSFOSBAS;

(* 

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES {$IFDEF OS2}
     OS2BASE,MSFOSOS2,
     {$ELSE}
     MSFOSDOS,
     {$ENDIF}
     CRT,DOS,MSTRINGS,MISC1,UNIXDATE,FASTW,CURSOR;


CONST fk_StandardInput = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&*()-+\[]{};:`''".,/<> =_?|';
      fk_HighBitInput  = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&*()-+\[]{};:`''".,/<> =_?|'
                        +''
                        +''
                        +'';
      fk_FilenameInput = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&()-_{}.';
      fk_FilespecInput = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&()-_{}.?*';
      fk_FilepathInput = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&()-_{}.?*:\';
      fk_NumberInput   = '123456790.-+';

      fk_DriverVersion = '1.00';
      fk_DriverName    = 'MatrixSoft''s Virtual Pascal OS/2 Communications Unit';

      AnsiColorArray   : Array[0..7] OF Byte = (0,4,2,6,1,5,3,7);

      On               = TRUE;
      Off              = FALSE;

      ExtTTY           : String[3]='ASC';
      ExtANSI          : String[3]='ANS';
      ExtAvatar        : String[3]='AVT';


TYPE  fk_FossilRec = RECORD
         Started      : Boolean;
         Port         : LongInt;
         Baud         : LongInt;
         Locked       : LongInt;
         Carrier      : Boolean;
         Driver       : String[80];
         Version      : Byte;
         Revision     : Byte;
      END;

      fk_ProgramInfoRec = RECORD
         Title        : String[25];
         Version      : String[8];
         Author       : String[20];
         Other        : String[20];
      END;

      fk_TaskRec = RECORD
         System       : String[15];  { OS/2 }
         TaskType     : Byte;        { 2=OS/2 }
         Window       : Integer;     { unused }
         Share        : Boolean;     { TRUE }
      END;

      fk_ClientRec = RECORD
         BBSName      : String[35];
         Calls        : LongInt;
         CityState    : String[30];
         Downloads    : LongInt;
         FirstDate    : String[8];
         Handle       : String[35];
         HomePhone    : String[15];
         LastDate     : String[8];
         LastTime     : String[5];
         Name         : String[35];
         PageLength   : Byte;
         Password     : String[30];
         RecordPos    : LongInt;
         ScreenType   : Byte;
         Security     : LongInt;
         SysopName    : String[35];
         TimeLeft     : LongInt;
         Uploads      : LongInt;
         WorkPhone    : String[15];
      END;

      fk_MusicRec = RECORD
         MusicType    : Byte;
         NoteLength   : Byte; { Default = 4, Quarter Note }
         Octave       : Byte; { Current Octave, Default=4 }
         Tempo        : Byte; { Tempo }
      END;

      fk_HostRec = RECORD
         AnsiTimer     : Word;       { Countdown f/ANSI detection (default=2500) }
         Blink         : Boolean;    { Blink attribute }
         Clock         : Boolean;    { Decrease time, increase lastkey }
         CurrentInput  : String[80];
         Error         : Byte;
         ExitCode      : Byte;
         High          : Boolean;
         HostScreen    : Boolean;
         HostKey       : Boolean;
         Inactivity    : Word;
         SaveX         : Byte;
         SaveY         : Byte;
         LastBg        : Byte;
         LastFg        : Byte;
         LastKP        : LongInt;
         LastStatDraw  : LongInt;
         LastTimeCheck : LongInt;
         Mono          : Boolean;
         Multinode     : Boolean;
         Node          : Byte;
         OutputChar    : Char;
         OutputLines   : Word;
         RemoteScreen  : Boolean;
         RemoteKey     : Boolean;
         Sound         : Boolean;
         StatusLineBuf : Byte;       { Blank lines before status line }
         StatusLinePos : Byte;       { Position of status line (25) }
         StrictColour  : Boolean;
         TimeSlice     : Boolean;
         TitleLine     : Boolean;
         ValidInput    : String;
         WaitForChar   : Boolean;
         WarningBell   : Boolean;
         WarningTime   : Boolean;

         Colour : RECORD
            Baud,
            Handle,
            InfoDesc,
            LastKey,
            Multitasker,
            Name,
            Node,
            NoTimeLeft,
            ScreenType,
            StatusLine,
            TimeLeft,
            TitleLine,
            Warning      : Byte;
         END;
      END;


VAR   fk_Fossil       : fk_FossilRec;
      fk_ProgramInfo  : fk_ProgramInfoRec;
      fk_Task         : fk_TaskRec;
      fk_Client       : fk_ClientRec;
      fk_Music        : fk_MusicRec;
      fk_Host         : fk_HostRec;

      fk_LocalInput   : FUNCTION(ch:Char):Char;
      fk_RemoteInput  : FUNCTION(ch:Char):Char;
      fk_MCI          : FUNCTION(s:String):String;
      fk_CarrierLoss  : PROCEDURE;
      fk_TimeOut      : PROCEDURE;
      fk_NoTimeLeft   : PROCEDURE;
      fk_Close        : PROCEDURE;
      fk_Open         : PROCEDURE;


PROCEDURE Ms_DrawStatus;
PROCEDURE Ms_DrawStatusTimes;
PROCEDURE Ms_UpdateStatus;

PROCEDURE Ms_VarsInit_Fossil;
PROCEDURE Ms_VarsInit_ProgramInfo;
PROCEDURE Ms_VarsInit_Task;
PROCEDURE Ms_VarsInit_Client;
PROCEDURE Ms_VarsInit_Music;
PROCEDURE Ms_VarsInit_Host;


IMPLEMENTATION


FUNCTION Ms_LastKeyStr:String;
VAR s:String; i:LongInt;
BEGIN
   i := CurrentSecsFunc;
   s := StrFunc((i-fk_Host.LastKP) DIV 60)+':'+LeadingZero((i-fk_Host.LastKP) MOD 60,2);
   Ms_LastKeyStr := PadLeft(s,' ',5);
END;


FUNCTION Ms_TimeLeftStr:String;
VAR s:String;
BEGIN
   s := StrFunc(fk_Client.TimeLeft DIV 60)+':'+LeadingZero(fk_Client.TimeLeft MOD 60,2);
   Ms_TimeLeftStr := PadLeft(s,' ',7);
END;


PROCEDURE Ms_DrawStatus;
VAR TempX,TempY:Byte;
BEGIN
   IF fk_Host.StatusLinePos = 0 THEN Exit;

   TempX := WhereX;
   TempY := WhereY;

   IF (fk_Host.StatusLinePos > 10)
      THEN BEGIN
            Window(1,1,80,fk_Host.StatusLinePos-1-fk_Host.StatusLineBuf);
            FastClr(' ',1,fk_Host.StatusLinePos-fk_Host.StatusLineBuf,80,fk_Host.StatusLinePos-1,0);
            FastClr(' ',1,fk_Host.StatusLinePos,80,fk_Host.StatusLinePos,fk_Host.Colour.StatusLine);
         END
      ELSE IF (fk_Host.StatusLinePos > 0) THEN
         BEGIN
            Window(1,fk_Host.StatusLinePos+1+fk_Host.StatusLineBuf,80,25);
            FastClr(' ',1,fk_Host.StatusLinePos+1,80,fk_Host.StatusLinePos+fk_Host.StatusLineBuf,0);
            FastClr(' ',1,fk_Host.StatusLinePos,80,fk_Host.StatusLinePos,16);
         END;
   IF fk_Client.Handle <> fk_Client.Name
      THEN WITH fk_Client,fk_Host DO BEGIN
            WriteFast(2,StatusLinePos,CutTo(Handle,35),Colour.Handle);
            WriteFast(3+Length(Handle),StatusLinePos,CutTo(Name,35-Length(Handle)-2),Colour.Name);
         END
      ELSE WriteFast(2,fk_Host.StatusLinePos,CutTo(fk_Client.Name,35),fk_Host.Colour.Name);

   WriteFast(38,fk_Host.StatusLinePos,'Node',fk_Host.Colour.InfoDesc);
   WriteFast(43,fk_Host.StatusLinePos,StrFunc(fk_Host.Node),fk_Host.Colour.Node);

   IF fk_Fossil.Baud = 0
      THEN WriteFast(49,fk_Host.StatusLinePos,'Local',fk_Host.Colour.Baud)
      ELSE WriteFast(49,fk_Host.StatusLinePos,StrFunc(fk_Fossil.Baud),fk_Host.Colour.Baud);

   CASE fk_Client.ScreenType OF
      0 : WriteFast(55,fk_Host.StatusLinePos,'TTY',fk_Host.Colour.ScreenType);
      1 : WriteFast(55,fk_Host.StatusLinePos,'Ansi',fk_Host.Colour.ScreenType);
      2 : WriteFast(55,fk_Host.StatusLinePos,'Avt',fk_Host.Colour.ScreenType);
   END;

   WriteFast(61,fk_Host.StatusLinePos,'KP:',fk_Host.Colour.InfoDesc);
   WriteFast(70,fk_Host.StatusLinePos,'TL:',fk_Host.Colour.InfoDesc);

   fk_Host.LastStatDraw := CurrentSecsFunc;
   Ms_DrawStatusTimes;
   GotoXY(TempX,TempY);
END;


PROCEDURE Ms_DrawStatusTimes;
BEGIN
   IF fk_Host.StatusLinePos = 0 THEN Exit;

   IF fk_Host.WarningBell
      THEN WriteFast(64,fk_Host.StatusLinePos,Ms_LastKeyStr,fk_Host.Colour.Warning)
      ELSE IF (CurrentSecsFunc-fk_Host.LastKP >= 15)
         THEN WriteFast(64,fk_Host.StatusLinePos,Ms_LastKeyStr,fk_Host.Colour.LastKey)
         ELSE WriteFast(64,fk_Host.StatusLinePos,PadLeft('0:00',' ',5),fk_Host.Colour.LastKey);

   IF fk_Host.WarningTime
      THEN WriteFast(73,fk_Host.StatusLinePos,Ms_TimeLeftStr,fk_Host.Colour.Warning)
      ELSE WriteFast(73,fk_Host.StatusLinePos,Ms_TimeLeftStr,fk_Host.Colour.TimeLeft);
END;


PROCEDURE Ms_UpdateStatus;

   PROCEDURE UpdateTimes;
   BEGIN
      IF fk_Host.Clock THEN
         BEGIN
            fk_Client.TimeLeft := fk_Client.TimeLeft-(CurrentSecsFunc-fk_Host.LastTimeCheck);
            IF (CurrentSecsFunc-fk_Host.LastKP >= fk_Host.Inactivity) AND (fk_Host.Inactivity > 0) THEN fk_TimeOut;
         END;
      fk_Host.LastTimeCheck := CurrentSecsFunc;
   END;

BEGIN
   IF (fk_Fossil.Port > 0) AND (fk_Fossil.Baud > 0) AND NOT Ms_Carrier THEN fkp_CarrierLoss;
   UpdateTimes;
   IF (CurrentSecsFunc-fk_Host.LastStatDraw) > 30
      THEN Ms_DrawStatus
      ELSE Ms_DrawStatusTimes;
END;


PROCEDURE Ms_VarsInit_Fossil;
BEGIN
   fk_Fossil.Started := FALSE;
   fk_Fossil.Port := 0;
   fk_Fossil.Baud := 0;
   fk_Fossil.Locked := 0;
   fk_Fossil.Carrier := FALSE;
   fk_Fossil.Driver := '';
   fk_Fossil.Version := 0;
   fk_Fossil.Revision := 0;
END;


PROCEDURE Ms_VarsInit_ProgramInfo;
BEGIN
   fk_ProgramInfo.Title := 'Unknown Program';
   fk_ProgramInfo.Version := '1.00';
   fk_ProgramInfo.Author := 'Lars Hellsten';
   fk_ProgramInfo.Other := '';
END;


PROCEDURE Ms_VarsInit_Task;
BEGIN
   fk_Task.System := 'DOS';
   fk_Task.TaskType := 2;
   fk_Task.Window := 0;
   fk_Task.Share := TRUE;
END;


PROCEDURE Ms_VarsInit_Client;
BEGIN
   FillChar(fk_Client,SizeOf(fk_Client),0);
END;


PROCEDURE Ms_VarsInit_Music;
BEGIN
   FillChar(fk_Music,SizeOf(fk_Music),0);
   fk_Music.NoteLength  := 4;
   fk_Music.Octave := 4;
   fk_Music.Tempo := 120;
END;


PROCEDURE Ms_VarsInit_Host;
BEGIN
   FillChar(fk_Host,SizeOf(fk_Host),0);
   fk_Host.AnsiTimer := 2500;
   fk_Host.Clock := TRUE;
   fk_Host.HostScreen := TRUE;
   fk_Host.HostKey := TRUE;
   fk_Host.Inactivity := 180;
   fk_Host.SaveX := 1;
   fk_Host.SaveY := 1;
   fk_Host.LastBG := 0;
   fk_Host.LastFG := 7;
   fk_Host.LastKP := CurrentSecsFunc;
   fk_Host.LastStatDraw := fk_Host.LastKP;
   fk_Host.LastTimeCheck := fk_Host.LastKP;
   fk_Host.Multinode := TRUE;
   fk_Host.RemoteScreen := TRUE;
   fk_Host.RemoteKey := TRUE;
   fk_Host.Sound := TRUE;
   fk_Host.StatusLineBuf := 1;
   fk_Host.StatusLinePos := 25;
   fk_Host.StrictColour := TRUE;
   fk_Host.TimeSlice := TRUE;
   fk_Host.TitleLine := FALSE;
   fk_Host.ValidInput := fk_StandardInput;
   fk_Host.WaitForChar := TRUE;
   fk_Host.WarningBell := FALSE;
   fk_Host.WarningTime := FALSE;

   fk_Host.Colour.Baud := $19;
   fk_Host.Colour.Handle := $1B;
   fk_Host.Colour.InfoDesc := $19;
   fk_Host.Colour.LastKey := $1B;
   fk_Host.Colour.Multitasker := $19;
   fk_Host.Colour.Name := $1E;
   fk_Host.Colour.Node := $19;
   fk_Host.Colour.NoTimeLeft := $1C;
   fk_Host.Colour.ScreenType := $19;
   fk_Host.Colour.StatusLine := $11;
   fk_Host.Colour.TimeLeft := $1B;
   fk_Host.Colour.TitleLine := $1B;
   fk_Host.Colour.Warning := $9C;
END;


END.
